/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.converter;

import java.io.File;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.MalformedURLException;
import net.jcip.annotations.Immutable;
import org.geotoolkit.util.converter.NonconvertibleObjectException;
import org.geotoolkit.util.converter.SimpleConverter;

@Immutable
abstract class FileConverter<T>
extends SimpleConverter<File, T>
implements Serializable {
    private static final long serialVersionUID = -2150865427977735620L;

    FileConverter() {
    }

    @Override
    public final Class<File> getSourceClass() {
        return File.class;
    }

    @Override
    public boolean isOrderPreserving() {
        return false;
    }

    @Immutable
    static final class URL
    extends FileConverter<java.net.URL> {
        private static final long serialVersionUID = 621496099287330756L;
        public static final URL INSTANCE = new URL();

        private URL() {
        }

        @Override
        public Class<java.net.URL> getTargetClass() {
            return java.net.URL.class;
        }

        @Override
        public java.net.URL convert(File file) throws NonconvertibleObjectException {
            if (file == null) {
                return null;
            }
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new NonconvertibleObjectException(malformedURLException);
            }
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class URI
    extends FileConverter<java.net.URI> {
        private static final long serialVersionUID = 1032598133849975567L;
        public static final URI INSTANCE = new URI();

        private URI() {
        }

        @Override
        public Class<java.net.URI> getTargetClass() {
            return java.net.URI.class;
        }

        @Override
        public java.net.URI convert(File file) throws NonconvertibleObjectException {
            return file != null ? file.toURI() : null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }

    @Immutable
    static final class String
    extends FileConverter<java.lang.String> {
        private static final long serialVersionUID = -6811286687809954151L;
        public static final String INSTANCE = new String();

        private String() {
        }

        @Override
        public Class<java.lang.String> getTargetClass() {
            return java.lang.String.class;
        }

        @Override
        public java.lang.String convert(File file) throws NonconvertibleObjectException {
            return file != null ? file.getAbsolutePath() : null;
        }

        protected Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }
    }
}

