/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.logging;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotoolkit.util.logging.LoggerAdapter;

final class DualLogger
extends LoggerAdapter {
    private final Logger first;
    private final Logger second;

    DualLogger(String string, Logger logger, Logger logger2) {
        super(string);
        this.first = logger;
        this.second = logger2;
    }

    @Override
    public void setLevel(Level level) {
        this.first.setLevel(level);
        this.second.setLevel(level);
    }

    @Override
    public Level getLevel() {
        Level level = this.first.getLevel();
        Level level2 = this.second.getLevel();
        return level.intValue() < level2.intValue() ? level : level2;
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.first.isLoggable(level) || this.second.isLoggable(level);
    }

    @Override
    public void log(Level level, String string) {
        this.first.log(level, string);
        this.second.log(level, string);
    }

    @Override
    public void log(Level level, String string, Throwable throwable) {
        this.first.log(level, string, throwable);
        this.second.log(level, string, throwable);
    }

    @Override
    public void severe(String string) {
        this.first.severe(string);
        this.second.severe(string);
    }

    @Override
    public void warning(String string) {
        this.first.warning(string);
        this.second.warning(string);
    }

    @Override
    public void info(String string) {
        this.first.info(string);
        this.second.info(string);
    }

    @Override
    public void config(String string) {
        this.first.config(string);
        this.second.config(string);
    }

    @Override
    public void fine(String string) {
        this.first.fine(string);
        this.second.fine(string);
    }

    @Override
    public void finer(String string) {
        this.first.finer(string);
        this.second.finer(string);
    }

    @Override
    public void finest(String string) {
        this.first.finest(string);
        this.second.finest(string);
    }
}

