/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.OS;
import org.geotoolkit.io.ExpandedTabWriter;
import org.geotoolkit.io.LineWriter;
import org.geotoolkit.io.X364;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.logging.Logging;
import org.geotoolkit.util.logging.PerformanceLevel;

@ThreadSafe
public class MonolineFormatter
extends Formatter {
    private static final String MARGIN = "";
    private static final int NO_SOURCE = 0;
    private static final int NO_SOURCE_EX = 1;
    private static final int LOGGER_SHORT = 2;
    private static final int LOGGER_LONG = 3;
    private static final int CLASS_SHORT = 4;
    private static final int CLASS_LONG = 5;
    private static final String[] FORMAT_LABELS = new String[6];
    private static final Level LEVEL_THRESHOLD;
    private static final Comparator<Level> COMPARATOR;
    private static final int CONTEXT_STACK_TRACE_ELEMENTS = 2;
    private SortedMap<Level, X364> colors;
    private final boolean faintSupported;
    private transient int[] colorLevels;
    private transient String[] colorSequences;
    private final String lineSeparator;
    private int levelWidth;
    private final long startMillis = System.currentTimeMillis();
    private SimpleDateFormat timeFormat = null;
    private int sourceFormat = 0;
    private final StringBuffer buffer;
    private final LineWriter writer;
    private final PrintWriter printer;

    public MonolineFormatter(Handler handler) {
        Object object;
        Level level = handler != null ? handler.getLevel() : null;
        int n = 0;
        block13: while (true) {
            int n2;
            switch (n) {
                case 0: {
                    object = Level.FINEST;
                    break;
                }
                case 1: {
                    object = Level.FINER;
                    break;
                }
                case 2: {
                    object = Level.FINE;
                    break;
                }
                case 3: {
                    object = Level.CONFIG;
                    break;
                }
                case 4: {
                    object = Level.INFO;
                    break;
                }
                case 5: {
                    object = Level.WARNING;
                    break;
                }
                case 6: {
                    object = Level.SEVERE;
                    break;
                }
                default: {
                    break block13;
                }
            }
            if ((level == null || ((Level)object).intValue() >= level.intValue()) && (n2 = ((Level)object).getLocalizedName().length()) > this.levelWidth) {
                this.levelWidth = n2;
            }
            ++n;
        }
        StringWriter stringWriter = new StringWriter();
        this.writer = new LineWriter(stringWriter);
        this.buffer = stringWriter.getBuffer().append(MARGIN);
        this.printer = new PrintWriter(new ExpandedTabWriter(this.writer, 4));
        this.lineSeparator = this.writer.getLineSeparator();
        object = LogManager.getLogManager();
        String string = MonolineFormatter.class.getName();
        try {
            this.setTimeFormat(((LogManager)object).getProperty(string + ".time"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
        }
        try {
            this.setSourceFormat(((LogManager)object).getProperty(string + ".source"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
        }
        if (handler instanceof ConsoleHandler && X364.isSupported()) {
            SortedMap<Level, X364> sortedMap = this.colors = new TreeMap<Level, X364>(COMPARATOR);
            sortedMap.put(Level.ALL, X364.BACKGROUND_GRAY);
            sortedMap.put(Level.CONFIG, X364.BACKGROUND_BLUE);
            sortedMap.put(Level.INFO, X364.BACKGROUND_GREEN);
            sortedMap.put(Level.WARNING, X364.BACKGROUND_YELLOW);
            sortedMap.put(Level.SEVERE, X364.BACKGROUND_RED);
            sortedMap.put(PerformanceLevel.PERFORMANCE, X364.BACKGROUND_CYAN);
        }
        this.faintSupported = OS.current() != OS.MAC_OS;
    }

    public synchronized String getTimeFormat() {
        return this.timeFormat != null ? this.timeFormat.toPattern() : null;
    }

    public synchronized void setTimeFormat(String string) {
        if (string == null) {
            this.timeFormat = null;
        } else if (this.timeFormat == null) {
            this.timeFormat = new SimpleDateFormat(string);
            this.timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            this.timeFormat.applyPattern(string);
        }
    }

    public synchronized String getSourceFormat() {
        return FORMAT_LABELS[this.sourceFormat];
    }

    public synchronized void setSourceFormat(String string) {
        if (string != null) {
            string = string.trim().toLowerCase();
        }
        for (int i = 0; i < FORMAT_LABELS.length; ++i) {
            if (!Utilities.equals(FORMAT_LABELS[i], string)) continue;
            this.sourceFormat = i;
            return;
        }
        throw new IllegalArgumentException(string);
    }

    public synchronized X364 getLevelColor(Level level) {
        return this.colors != null ? (X364)((Object)this.colors.get(level)) : null;
    }

    public synchronized void setLevelColor(Level level, X364 x364) {
        boolean bl = false;
        if (x364 != null) {
            if (this.colors == null) {
                this.colors = new TreeMap<Level, X364>(COMPARATOR);
            }
            bl = this.colors.put(level, x364) != x364;
        } else if (this.colors != null) {
            boolean bl2 = bl = this.colors.remove(level) != null;
            if (this.colors.isEmpty()) {
                this.colors = null;
            }
        }
        if (bl) {
            this.colorLevels = null;
            this.colorSequences = null;
        }
    }

    public synchronized void clearLevelColors() {
        this.colors = null;
        this.colorLevels = null;
        this.colorSequences = null;
    }

    private String interpolateColor(Level level) {
        int n;
        if (this.colorSequences == null) {
            this.colorSequences = new String[this.colors.size()];
            this.colorLevels = new int[this.colorSequences.length];
            n = 0;
            for (Map.Entry<Level, X364> entry : this.colors.entrySet()) {
                this.colorSequences[n] = entry.getValue().background().sequence();
                this.colorLevels[n++] = entry.getKey().intValue();
            }
        }
        if ((n = Arrays.binarySearch(this.colorLevels, level.intValue())) < 0) {
            n = Math.max(~n - 1, 0);
        }
        return this.colorSequences[n];
    }

    @Override
    public synchronized String format(LogRecord logRecord) {
        String string;
        String string2;
        Level level = logRecord.getLevel();
        boolean bl = this.colors != null;
        boolean bl2 = !this.faintSupported || level.intValue() >= LEVEL_THRESHOLD.intValue();
        StringBuffer stringBuffer = this.buffer;
        stringBuffer.setLength(MARGIN.length());
        if (this.timeFormat != null) {
            Date date = new Date(Math.max(0L, logRecord.getMillis() - this.startMillis));
            this.timeFormat.format(date, stringBuffer, new FieldPosition(0));
            stringBuffer.append(' ');
        }
        int n = stringBuffer.length();
        if (bl) {
            stringBuffer.append(this.interpolateColor(level));
        }
        int n2 = stringBuffer.length();
        stringBuffer.append(level.getLocalizedName());
        stringBuffer.append(Strings.spaces(this.levelWidth - (stringBuffer.length() - n2)));
        n += stringBuffer.length() - n2;
        if (bl) {
            stringBuffer.append(X364.BACKGROUND_DEFAULT.sequence());
        }
        stringBuffer.append(' ');
        ++n;
        switch (this.sourceFormat) {
            case 2: 
            case 3: {
                string2 = logRecord.getLoggerName();
                break;
            }
            case 4: 
            case 5: {
                string2 = logRecord.getSourceClassName();
                break;
            }
            default: {
                string2 = null;
            }
        }
        if (string2 != null) {
            switch (this.sourceFormat) {
                case 2: 
                case 4: {
                    string2 = string2.substring(string2.lastIndexOf(46) + 1);
                }
            }
            string2 = string2.replace('$', '.');
            if (bl && bl2) {
                stringBuffer.append(X364.BOLD.sequence());
            }
            stringBuffer.append('[').append(string2).append(']');
            if (bl && bl2) {
                stringBuffer.append(X364.NORMAL.sequence());
            }
            stringBuffer.append(' ');
        }
        if ((string = this.writer.getLineSeparator()).length() != this.lineSeparator.length() + n) {
            string = this.lineSeparator + Strings.spaces(n);
            this.writer.setLineSeparator(string);
        }
        if (bl && !bl2) {
            stringBuffer.append(X364.FAINT.sequence());
        }
        Throwable throwable = logRecord.getThrown();
        String string3 = this.formatMessage(logRecord);
        if (string3 != null) {
            string3 = string3.substring(0, MonolineFormatter.trim(string3));
        }
        if (throwable != null) {
            if (string3 != null) {
                this.printer.println(string3);
                this.printer.print("Caused by: ");
            }
            if (level.intValue() >= LEVEL_THRESHOLD.intValue()) {
                throwable.printStackTrace(this.printer);
            } else {
                MonolineFormatter.printAbridged(throwable, this.printer, logRecord.getLoggerName(), logRecord.getSourceClassName(), logRecord.getSourceMethodName());
            }
        } else {
            this.printer.print(string3);
        }
        this.printer.flush();
        stringBuffer.setLength(MonolineFormatter.trim(stringBuffer));
        if (bl && !bl2) {
            stringBuffer.append(X364.NORMAL.sequence());
        }
        stringBuffer.append(this.lineSeparator);
        return stringBuffer.toString();
    }

    private static void printAbridged(Throwable throwable, PrintWriter printWriter, String string, String string2, String string3) {
        StackTraceElement stackTraceElement = null;
        for (int i = 0; i < 10; ++i) {
            StackTraceElement stackTraceElement2;
            int n;
            StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
            int n2 = stackTraceElementArray.length;
            boolean bl = string != null;
            boolean bl2 = true;
            for (n = 0; n < stackTraceElementArray.length; ++n) {
                stackTraceElement2 = stackTraceElementArray[n];
                String string4 = stackTraceElement2.getClassName();
                if (string4 == null) continue;
                if (bl && string4.startsWith(string)) {
                    n2 = n;
                    bl = false;
                }
                if (!string4.contains(string2)) continue;
                String string5 = stackTraceElement2.getMethodName();
                if (string5 != null && string5.equals(string3)) {
                    n2 = n;
                    break;
                }
                if (bl2) {
                    n2 = n;
                    bl2 = false;
                }
                bl = false;
            }
            if (n2 < (n = stackTraceElementArray.length)) {
                stackTraceElement2 = stackTraceElementArray[n2];
                if (stackTraceElement2.equals(stackTraceElement)) {
                    n = 2;
                }
                stackTraceElement = stackTraceElement2;
            }
            n = Math.min(n2 + 3, n);
            printWriter.println(throwable);
            for (int j = 0; j < n; ++j) {
                int n3;
                if (j == 2 && (n3 = n2 - 4) > 1) {
                    MonolineFormatter.more(printWriter, n3, true);
                    j += n3;
                }
                if (j == n2) {
                    printWriter.print("  \u2192");
                }
                printWriter.print("\tat ");
                printWriter.println(stackTraceElementArray[j]);
            }
            MonolineFormatter.more(printWriter, stackTraceElementArray.length - n, false);
            throwable = throwable.getCause();
            if (throwable == null) break;
            printWriter.print("Caused by: ");
        }
    }

    private static void more(PrintWriter printWriter, int n, boolean bl) {
        if (n > 0) {
            printWriter.print("... ");
            printWriter.print(n);
            printWriter.print(" more");
            if (bl) {
                printWriter.print(" ...");
            }
            printWriter.println();
        }
    }

    private static int trim(CharSequence charSequence) {
        int n;
        for (n = charSequence.length(); n != 0 && Character.isWhitespace(charSequence.charAt(n - 1)); --n) {
        }
        return n;
    }

    public static MonolineFormatter configureConsoleHandler(Logger logger, Level level) {
        Object object;
        MonolineFormatter monolineFormatter = null;
        boolean bl = false;
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            Handler handler = handlerArray[i];
            if (handler.getClass() != ConsoleHandler.class) continue;
            bl = true;
            object = handler.getFormatter();
            if (object instanceof MonolineFormatter) {
                if (monolineFormatter != null) continue;
                monolineFormatter = (MonolineFormatter)object;
                MonolineFormatter.setLevel(handler, level);
                continue;
            }
            if (object.getClass() != SimpleFormatter.class) continue;
            try {
                MonolineFormatter.setLevel(handler, level);
            }
            catch (SecurityException securityException) {
                MonolineFormatter.unexpectedException(securityException);
            }
            if (monolineFormatter == null) {
                monolineFormatter = new MonolineFormatter(handler);
            }
            try {
                handler.setFormatter(monolineFormatter);
                continue;
            }
            catch (SecurityException securityException) {
                MonolineFormatter.unexpectedException(securityException);
            }
        }
        Logger logger2 = logger;
        while (logger2.getUseParentHandlers() && (logger2 = logger2.getParent()) != null) {
            handlerArray = logger2.getHandlers();
            for (int i = 0; i < handlerArray.length; ++i) {
                object = handlerArray[i];
                if (object.getClass() == ConsoleHandler.class) {
                    if (!bl) continue;
                    bl = true;
                    Formatter formatter = ((Handler)object).getFormatter();
                    if (formatter.getClass() == SimpleFormatter.class) {
                        monolineFormatter = MonolineFormatter.addHandler(logger, level);
                        continue;
                    }
                }
                logger.addHandler((Handler)object);
            }
        }
        logger.setUseParentHandlers(false);
        if (!bl) {
            monolineFormatter = MonolineFormatter.addHandler(logger, level);
        }
        return monolineFormatter;
    }

    private static MonolineFormatter addHandler(Logger logger, Level level) {
        MonolineFormatter monolineFormatter = null;
        try {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            monolineFormatter = new MonolineFormatter(consoleHandler);
            consoleHandler.setFormatter(monolineFormatter);
            MonolineFormatter.setLevel(consoleHandler, level);
            logger.addHandler(consoleHandler);
        }
        catch (SecurityException securityException) {
            MonolineFormatter.unexpectedException(securityException);
        }
        return monolineFormatter;
    }

    private static void setLevel(Handler handler, Level level) {
        if (level != null) {
            int n = level.intValue();
            int n2 = handler.getLevel().intValue();
            if (n < LEVEL_THRESHOLD.intValue() ? n < n2 : n > n2) {
                handler.setLevel(level);
            }
        }
    }

    private static void unexpectedException(Exception exception) {
        Logging.unexpectedException(MonolineFormatter.class, "configureConsoleHandler", exception);
    }

    static {
        MonolineFormatter.FORMAT_LABELS[1] = "none";
        MonolineFormatter.FORMAT_LABELS[2] = "logger:short";
        MonolineFormatter.FORMAT_LABELS[3] = "logger:long";
        MonolineFormatter.FORMAT_LABELS[4] = "class:short";
        MonolineFormatter.FORMAT_LABELS[5] = "class:long";
        LEVEL_THRESHOLD = Level.INFO;
        COMPARATOR = new Comparator<Level>(){

            @Override
            public int compare(Level level, Level level2) {
                int n;
                int n2 = level.intValue();
                if (n2 < (n = level2.intValue())) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                return 0;
            }
        };
    }
}

