/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.geotoolkit.internal.jaxb.IdentifierMapAdapter;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.xml.IdentifierSpace;
import org.geotoolkit.xml.XLink;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;

final class IdentifierMapWithSpecialCases
extends IdentifierMapAdapter {
    private static final long serialVersionUID = 5139573827448780289L;

    IdentifierMapWithSpecialCases(Collection<Identifier> collection) {
        super(collection);
    }

    private static boolean isSpecialCase(Object object) {
        return object == IdentifierSpace.HREF;
    }

    private String getHRef() {
        URI uRI;
        XLink xLink = super.getSpecialized(IdentifierSpace.XLINK);
        if (xLink != null && (uRI = xLink.getHRef()) != null) {
            return uRI.toString();
        }
        return null;
    }

    private URI setHRef(URI uRI) {
        super.putSpecialized(IdentifierSpace.HREF, null);
        XLink xLink = super.getSpecialized(IdentifierSpace.XLINK);
        if (xLink != null) {
            URI uRI2 = xLink.getHRef();
            xLink.setHRef(uRI);
            return uRI2;
        }
        if (uRI != null) {
            xLink = new XLink();
            xLink.setHRef(uRI);
            super.putSpecialized(IdentifierSpace.XLINK, xLink);
        }
        return null;
    }

    @Override
    public boolean containsValue(Object object) {
        return super.containsValue(object) || Utilities.equals((Object)object, (Object)this.getHRef());
    }

    @Override
    public boolean containsKey(Object object) {
        XLink xLink;
        if (super.containsKey(object)) {
            return true;
        }
        if (IdentifierMapWithSpecialCases.isSpecialCase(object) && (xLink = super.getSpecialized(IdentifierSpace.XLINK)) != null) {
            return xLink.getHRef() != null;
        }
        return false;
    }

    @Override
    public <T> T getSpecialized(IdentifierSpace<T> identifierSpace) {
        XLink xLink;
        Object object = super.getSpecialized(identifierSpace);
        if (object == null && IdentifierMapWithSpecialCases.isSpecialCase(identifierSpace) && (xLink = super.getSpecialized(IdentifierSpace.XLINK)) != null) {
            object = xLink.getHRef();
        }
        return object;
    }

    @Override
    public String get(Object object) {
        String string = super.get(object);
        if (string == null && IdentifierMapWithSpecialCases.isSpecialCase(object)) {
            string = this.getHRef();
        }
        return string;
    }

    @Override
    public String put(Citation citation, String string) throws UnsupportedOperationException {
        if (IdentifierMapWithSpecialCases.isSpecialCase(citation)) {
            try {
                URI uRI = this.setHRef(string != null ? new URI(string) : null);
                return uRI != null ? uRI.toString() : null;
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return super.put(citation, string);
    }

    @Override
    public <T> T putSpecialized(IdentifierSpace<T> identifierSpace, T t) throws UnsupportedOperationException {
        if (IdentifierMapWithSpecialCases.isSpecialCase(identifierSpace)) {
            return (T)this.setHRef((URI)t);
        }
        return super.putSpecialized(identifierSpace, t);
    }
}

