/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.jaxb.code;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.XmlValue;
import org.geotoolkit.internal.CodeLists;
import org.geotoolkit.internal.jaxb.MarshalContext;
import org.geotoolkit.internal.jaxb.code.CodeListAdapter;
import org.geotoolkit.resources.Locales;
import org.geotoolkit.util.logging.Logging;
import org.opengis.util.CodeList;

@XmlType(name="CodeList", propOrder={"codeSpace", "codeListValue", "codeList"})
public final class CodeListProxy {
    @XmlAttribute(required=true)
    public String codeList;
    @XmlAttribute(required=true)
    public String codeListValue;
    @XmlAttribute
    public String codeSpace;
    @XmlValue
    public String value;

    private static String schemaURL(String string, String string2) {
        return MarshalContext.schema("gmd", "resources/Codelist", string, string2);
    }

    public CodeListProxy() {
    }

    public CodeListProxy(String string) {
        this.value = string;
    }

    public CodeListProxy(String string, String string2, String string3, String string4) {
        this.codeList = CodeListProxy.schemaURL(string, string2);
        this.codeListValue = string3;
        this.value = string4;
    }

    public CodeListProxy(CodeList<?> codeList) {
        String string = CodeLists.classname(codeList);
        String string2 = CodeLists.identifier(codeList);
        this.codeList = CodeListProxy.schemaURL("gmxCodelists.xml", string);
        Locale locale = MarshalContext.getLocale();
        if (locale != null) {
            String string3 = string + '.' + string2;
            try {
                this.value = ResourceBundle.getBundle("org.opengis.metadata.CodeLists", locale).getString(string3);
            }
            catch (MissingResourceException missingResourceException) {
                Logging.recoverableException(CodeListAdapter.class, (String)"marshal", (Throwable)missingResourceException);
            }
        }
        if (this.value != null) {
            this.codeSpace = Locales.getLanguage((Locale)locale);
        } else {
            this.value = CodeLists.sentence(codeList);
        }
        this.codeListValue = string2;
    }

    public String identifier() {
        String string = this.codeListValue;
        if (string == null) {
            string = this.value;
        }
        return string;
    }
}

