/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.xml;

import java.util.ConcurrentModificationException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.xml.bind.JAXBException;
import javax.xml.bind.PropertyException;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.validation.Schema;
import org.geotoolkit.internal.InternalUtilities;
import org.geotoolkit.internal.jaxb.MarshalContext;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Strings;
import org.geotoolkit.util.Version;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.xml.ObjectConverters;
import org.geotoolkit.xml.ObjectLinker;

abstract class Pooled {
    private static final String INTERNAL = "com.sun.xml.bind.";
    private final boolean internal;
    private final Map<Object, Object> initial;
    private ObjectConverters converters;
    private ObjectLinker linker;
    private Version versionGML;
    private Map<String, String> schemas;
    private Locale locale;
    private TimeZone timezone;
    private int bitMasks;

    Pooled(boolean bl) {
        this.internal = bl;
        this.initial = new LinkedHashMap<Object, Object>();
    }

    public final void reset() throws JAXBException {
        for (Map.Entry<Object, Object> entry : this.initial.entrySet()) {
            this.reset(entry.getKey(), entry.getValue());
        }
        this.initial.clear();
        this.converters = null;
        this.linker = null;
        this.versionGML = null;
        this.schemas = null;
        this.locale = null;
        this.timezone = null;
    }

    protected abstract void reset(Object var1, Object var2) throws JAXBException;

    final boolean containsKey(Class<?> clazz) {
        return this.initial.containsKey(clazz);
    }

    final <E> void save(Class<E> clazz, E e) {
        if (this.initial.put(clazz, e) != null) {
            throw new ConcurrentModificationException(clazz.toString());
        }
    }

    private String convertPropertyKey(String string) {
        if (this.internal && string.startsWith(INTERNAL)) {
            string = "com.sun.xml.internal.bind." + string.substring(INTERNAL.length());
        }
        return string;
    }

    public final void setProperty(String string, Object object) throws PropertyException {
        try {
            if (string.equals("org.geotoolkit.xml.converters")) {
                this.converters = (ObjectConverters)object;
                return;
            }
            if (string.equals("org.geotoolkit.xml.linker")) {
                this.linker = (ObjectLinker)object;
                return;
            }
            if (string.equals("org.geotoolkit.xml.schemas")) {
                this.schemas = InternalUtilities.subset((Map)((Map)object), String.class, (Object[])new String[]{"gmd"});
                return;
            }
            if (string.equals("org.geotoolkit.gml.version")) {
                this.versionGML = object instanceof CharSequence ? new Version(object.toString()) : (Version)object;
                return;
            }
            if (string.equals("org.geotoolkit.xml.locale")) {
                this.locale = (Locale)object;
                return;
            }
            if (string.equals("org.geotoolkit.xml.timezone")) {
                this.timezone = (TimeZone)object;
                return;
            }
            if (string.equals("org.geotoolkit.xml.stringSubstitutes")) {
                int n = 0;
                String[] stringArray = Strings.split((String)((String)object), (char)',');
                if (XArrays.containsIgnoreCase((String[])stringArray, (String)"language")) {
                    n |= 2;
                }
                if (XArrays.containsIgnoreCase((String[])stringArray, (String)"country")) {
                    n |= 4;
                }
                this.bitMasks = n;
                return;
            }
        }
        catch (ClassCastException classCastException) {
            throw new PropertyException(Errors.format((int)254, (Object)string, object.getClass()), (Throwable)classCastException);
        }
        string = this.convertPropertyKey(string);
        if (!this.initial.containsKey(string) && this.initial.put(string, this.getStandardProperty(string)) != null) {
            throw new ConcurrentModificationException(string);
        }
        this.setStandardProperty(string, object);
    }

    public final Object getProperty(String string) throws PropertyException {
        if (string.equals("org.geotoolkit.xml.converters")) {
            return this.converters;
        }
        if (string.equals("org.geotoolkit.xml.linker")) {
            return this.linker;
        }
        if (string.equals("org.geotoolkit.xml.schemas")) {
            return this.schemas;
        }
        if (string.equals("org.geotoolkit.gml.version")) {
            return this.versionGML;
        }
        if (string.equals("org.geotoolkit.xml.locale")) {
            return this.locale;
        }
        if (string.equals("org.geotoolkit.xml.timezone")) {
            return this.timezone;
        }
        if (string.equals("org.geotoolkit.xml.stringSubstitutes")) {
            int n;
            StringBuilder stringBuilder = new StringBuilder();
            if ((this.bitMasks & 2) != 0) {
                stringBuilder.append("language,");
            }
            if ((this.bitMasks & 4) != 0) {
                stringBuilder.append("country,");
            }
            if ((n = stringBuilder.length()) != 0) {
                stringBuilder.setLength(n - 1);
                return stringBuilder.toString();
            }
            return null;
        }
        return this.getStandardProperty(this.convertPropertyKey(string));
    }

    abstract void setStandardProperty(String var1, Object var2) throws PropertyException;

    abstract Object getStandardProperty(String var1) throws PropertyException;

    public final void setAdapter(XmlAdapter xmlAdapter) {
        this.setAdapter(xmlAdapter.getClass(), xmlAdapter);
    }

    public <A extends XmlAdapter> void setAdapter(Class<A> clazz, A a) {
        if (!this.initial.containsKey(clazz)) {
            this.save(clazz, this.getAdapter(clazz));
        }
    }

    public abstract <A extends XmlAdapter> A getAdapter(Class<A> var1);

    public void setSchema(Schema schema) {
        if (!this.containsKey(Schema.class)) {
            this.save(Schema.class, this.getSchema());
        }
    }

    public abstract Schema getSchema();

    public void setEventHandler(ValidationEventHandler validationEventHandler) throws JAXBException {
        if (!this.initial.containsKey(ValidationEventHandler.class)) {
            this.save(ValidationEventHandler.class, this.getEventHandler());
        }
    }

    public abstract ValidationEventHandler getEventHandler() throws JAXBException;

    final MarshalContext begin() {
        return MarshalContext.begin(this.converters, this.linker, this.versionGML, this.schemas, this.locale, this.timezone, this.bitMasks);
    }
}

