/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api;

import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.TimestampDoubleMap;
import org.gephi.graph.impl.GraphStoreConfiguration;

public class Configuration {
    private Class nodeIdType = GraphStoreConfiguration.DEFAULT_NODE_ID_TYPE;
    private Class edgeIdType = GraphStoreConfiguration.DEFAULT_EDGE_ID_TYPE;
    private Class edgeLabelType = GraphStoreConfiguration.DEFAULT_EDGE_LABEL_TYPE;
    private Class edgeWeightType = GraphStoreConfiguration.DEFAULT_EDGE_WEIGHT_TYPE;
    private TimeRepresentation timeRepresentation = GraphStoreConfiguration.DEFAULT_TIME_REPRESENTATION;

    public Class getNodeIdType() {
        return this.nodeIdType;
    }

    public void setNodeIdType(Class nodeIdType) {
        if (!AttributeUtils.isSimpleType(nodeIdType)) {
            throw new IllegalArgumentException("Unsupported type " + nodeIdType.getClass().getCanonicalName());
        }
        this.nodeIdType = nodeIdType;
    }

    public Class getEdgeIdType() {
        return this.edgeIdType;
    }

    public void setEdgeIdType(Class edgeIdType) {
        if (!AttributeUtils.isSimpleType(edgeIdType)) {
            throw new IllegalArgumentException("Unsupported type " + edgeIdType.getClass().getCanonicalName());
        }
        this.edgeIdType = edgeIdType;
    }

    public Class getEdgeLabelType() {
        return this.edgeLabelType;
    }

    public void setEdgeLabelType(Class edgeLabelType) {
        if (!AttributeUtils.isSimpleType(edgeLabelType)) {
            throw new IllegalArgumentException("Unsupported type " + edgeLabelType.getClass().getCanonicalName());
        }
        this.edgeLabelType = edgeLabelType;
    }

    public Class getEdgeWeightType() {
        return this.edgeWeightType;
    }

    public void setEdgeWeightType(Class edgeWeightType) {
        if (!(Double.class.equals((Object)edgeWeightType) || TimestampDoubleMap.class.equals((Object)edgeWeightType) || IntervalDoubleMap.class.equals((Object)edgeWeightType))) {
            throw new IllegalArgumentException("Unsupported type " + edgeWeightType.getClass().getCanonicalName());
        }
        this.edgeWeightType = edgeWeightType;
    }

    public TimeRepresentation getTimeRepresentation() {
        return this.timeRepresentation;
    }

    public void setTimeRepresentation(TimeRepresentation timeRepresentation) {
        if (timeRepresentation == null) {
            throw new IllegalArgumentException("timeRepresentation cannot be null");
        }
        this.timeRepresentation = timeRepresentation;
    }

    public Configuration copy() {
        Configuration copy = new Configuration();
        copy.nodeIdType = this.nodeIdType;
        copy.edgeIdType = this.edgeIdType;
        copy.edgeLabelType = this.edgeLabelType;
        copy.edgeWeightType = this.edgeWeightType;
        copy.timeRepresentation = this.timeRepresentation;
        return copy;
    }

    public int hashCode() {
        int hash = 7;
        hash = 19 * hash + (this.nodeIdType != null ? this.nodeIdType.hashCode() : 0);
        hash = 19 * hash + (this.edgeIdType != null ? this.edgeIdType.hashCode() : 0);
        hash = 19 * hash + (this.edgeLabelType != null ? this.edgeLabelType.hashCode() : 0);
        hash = 19 * hash + (this.edgeWeightType != null ? this.edgeWeightType.hashCode() : 0);
        hash = 19 * hash + (this.timeRepresentation != null ? this.timeRepresentation.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Configuration other = (Configuration)obj;
        if (!(this.nodeIdType == other.nodeIdType || this.nodeIdType != null && this.nodeIdType.equals(other.nodeIdType))) {
            return false;
        }
        if (!(this.edgeIdType == other.edgeIdType || this.edgeIdType != null && this.edgeIdType.equals(other.edgeIdType))) {
            return false;
        }
        if (!(this.edgeLabelType == other.edgeLabelType || this.edgeLabelType != null && this.edgeLabelType.equals(other.edgeLabelType))) {
            return false;
        }
        if (!(this.edgeWeightType == other.edgeWeightType || this.edgeWeightType != null && this.edgeWeightType.equals(other.edgeWeightType))) {
            return false;
        }
        return this.timeRepresentation == other.timeRepresentation || this.timeRepresentation != null && this.timeRepresentation.equals((Object)other.timeRepresentation);
    }
}

