/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import org.gephi.graph.api.Column;
import org.gephi.graph.api.ColumnObserver;
import org.gephi.graph.impl.ColumnImpl;

public class ColumnObserverImpl
implements ColumnObserver {
    protected final ColumnImpl column;
    protected int version = Integer.MIN_VALUE;
    protected boolean destroyed;

    public ColumnObserverImpl(ColumnImpl column) {
        this.column = column;
        this.version = column.version.version.get();
    }

    @Override
    public synchronized boolean hasColumnChanged() {
        int v = this.column.version.version.get();
        boolean changed = v != this.version;
        this.version = v;
        return changed;
    }

    @Override
    public Column getColumn() {
        return this.column;
    }

    @Override
    public void destroy() {
        this.column.destroyColumnObserver(this);
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    protected void destroyObserver() {
        this.destroyed = true;
    }
}

