/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.impl.utils.MapDeepEquals;

public class GraphAttributesImpl {
    protected final Map<String, Object> attributes = new HashMap<String, Object>();

    public synchronized Set<String> getKeys() {
        return this.attributes.keySet();
    }

    public synchronized void setValue(String key, Object value) {
        if (value != null) {
            this.checkSupportedTypes(value.getClass());
        }
        this.attributes.put(key, value);
    }

    public synchronized Object getValue(String key) {
        return this.attributes.get(key);
    }

    public synchronized Object getValue(String key, double timestamp) {
        TimestampMap valueSet = (TimestampMap)this.attributes.get(key);
        if (valueSet != null) {
            return valueSet.get(timestamp, null);
        }
        return null;
    }

    public synchronized void setValue(String key, Object value, double timestamp) {
        if (value == null) {
            throw new NullPointerException("The value can't be null for the key '" + key + "'");
        }
        this.checkSupportedDynamicTypes(value.getClass());
        TimestampMap valueSet = null;
        if (this.attributes.containsKey(key)) {
            valueSet = (TimestampMap)this.attributes.get(key);
        } else {
            try {
                valueSet = AttributeUtils.getTimestampMapType(value.getClass()).newInstance();
                this.attributes.put(key, valueSet);
            }
            catch (Exception ex) {
                throw new RuntimeException("The dynamic type can't be created", ex);
            }
        }
        if (!value.getClass().equals(valueSet.getTypeClass())) {
            throw new IllegalArgumentException("The value type " + value.getClass().getName() + " doesn't match with the expected type " + valueSet.getTypeClass().getName());
        }
        valueSet.put(timestamp, value);
    }

    protected void setGraphAttributes(GraphAttributesImpl graphAttributes) {
        this.attributes.putAll(graphAttributes.attributes);
    }

    private void checkSupportedTypes(Class type) {
        if (!AttributeUtils.isSupported(type)) {
            throw new IllegalArgumentException("Unknown type " + type.getName());
        }
    }

    private void checkSupportedDynamicTypes(Class type) {
        try {
            AttributeUtils.getTimestampMapType(type);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unsupported dynamic type " + type.getName());
        }
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public int deepHashCode() {
        int hash = 3;
        hash = 47 * hash + (this.attributes != null ? this.attributes.hashCode() : 0);
        return hash;
    }

    public boolean deepEquals(GraphAttributesImpl obj) {
        if (obj == null) {
            return false;
        }
        return MapDeepEquals.mapDeepEquals(this.attributes, obj.attributes);
    }
}

