/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.gephi.graph.api.Configuration;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.DirectedSubgraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.Subgraph;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalSet;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.EdgeStore;
import org.gephi.graph.impl.EdgeTypeStore;
import org.gephi.graph.impl.GraphAttributesImpl;
import org.gephi.graph.impl.GraphFactoryImpl;
import org.gephi.graph.impl.GraphLock;
import org.gephi.graph.impl.GraphModelImpl;
import org.gephi.graph.impl.GraphObserverImpl;
import org.gephi.graph.impl.GraphStoreConfiguration;
import org.gephi.graph.impl.GraphVersion;
import org.gephi.graph.impl.GraphViewStore;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.NodeStore;
import org.gephi.graph.impl.TableImpl;
import org.gephi.graph.impl.TimeStore;
import org.gephi.graph.impl.UndirectedDecorator;
import org.joda.time.DateTimeZone;

public class GraphStore
implements DirectedGraph,
DirectedSubgraph {
    protected final GraphModelImpl graphModel;
    protected final Configuration configuration;
    protected final NodeStore nodeStore;
    protected final EdgeStore edgeStore;
    protected final EdgeTypeStore edgeTypeStore;
    protected final TableImpl<Node> nodeTable;
    protected final TableImpl<Edge> edgeTable;
    protected final GraphViewStore viewStore;
    protected final TimeStore timeStore;
    protected final GraphAttributesImpl attributes;
    protected final GraphFactoryImpl factory;
    protected final GraphLock lock;
    protected final GraphVersion version;
    protected final List<GraphObserverImpl> observers;
    protected final UndirectedDecorator undirectedDecorator;
    protected final GraphView mainGraphView;
    protected TimeFormat timeFormat;
    protected DateTimeZone timeZone;

    public GraphStore() {
        this(null);
    }

    public GraphStore(GraphModelImpl model) {
        this.configuration = model != null ? model.configuration : new Configuration();
        this.graphModel = model;
        this.lock = new GraphLock();
        this.edgeTypeStore = new EdgeTypeStore();
        this.mainGraphView = new MainGraphView();
        this.viewStore = new GraphViewStore(this);
        this.version = new GraphVersion(this);
        this.observers = new ArrayList<GraphObserverImpl>();
        this.edgeStore = new EdgeStore(this.edgeTypeStore, this.lock, this.viewStore, this.version);
        this.nodeStore = new NodeStore(this.edgeStore, this.lock, this.viewStore, this.version);
        this.nodeTable = new TableImpl<Node>(this, Node.class, true);
        this.edgeTable = new TableImpl<Edge>(this, Edge.class, true);
        this.timeStore = new TimeStore(this, this.lock, true);
        this.attributes = new GraphAttributesImpl();
        this.factory = new GraphFactoryImpl(this);
        this.timeFormat = GraphStoreConfiguration.DEFAULT_TIME_FORMAT;
        this.timeZone = GraphStoreConfiguration.DEFAULT_TIME_ZONE;
        this.undirectedDecorator = new UndirectedDecorator(this);
        this.nodeTable.store.addColumn(new ColumnImpl(this.nodeTable, "id", this.configuration.getNodeIdType(), "Id", null, Origin.PROPERTY, false, true));
        this.edgeTable.store.addColumn(new ColumnImpl(this.edgeTable, "id", this.configuration.getEdgeIdType(), "Id", null, Origin.PROPERTY, false, true));
        this.nodeTable.store.addColumn(new ColumnImpl(this.nodeTable, "label", String.class, "Label", null, Origin.PROPERTY, false, false));
        this.edgeTable.store.addColumn(new ColumnImpl(this.edgeTable, "label", String.class, "Label", null, Origin.PROPERTY, false, false));
        if (this.configuration.getTimeRepresentation().equals((Object)TimeRepresentation.TIMESTAMP)) {
            this.nodeTable.store.addColumn(new ColumnImpl(this.nodeTable, "timeset", TimestampSet.class, "Timestamp", null, Origin.PROPERTY, false, false));
            this.edgeTable.store.addColumn(new ColumnImpl(this.edgeTable, "timeset", TimestampSet.class, "Timestamp", null, Origin.PROPERTY, false, false));
        } else {
            this.nodeTable.store.addColumn(new ColumnImpl(this.nodeTable, "timeset", IntervalSet.class, "Interval", null, Origin.PROPERTY, false, false));
            this.edgeTable.store.addColumn(new ColumnImpl(this.edgeTable, "timeset", IntervalSet.class, "Interval", null, Origin.PROPERTY, false, false));
        }
        this.edgeTable.store.addColumn(new ColumnImpl(this.edgeTable, "weight", this.configuration.getEdgeWeightType(), "Weight", null, Origin.PROPERTY, false, false));
    }

    @Override
    public boolean addNode(Node node) {
        this.autoWriteLock();
        try {
            boolean bl = this.nodeStore.add(node);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public boolean addAllNodes(Collection<? extends Node> nodes) {
        this.autoWriteLock();
        try {
            boolean bl = this.nodeStore.addAll(nodes);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addEdge(Edge edge) {
        this.autoWriteLock();
        try {
            int type = edge.getType();
            if (this.edgeTypeStore != null && !this.edgeTypeStore.contains(type)) {
                this.edgeTypeStore.addType(String.valueOf(type), type);
            }
            boolean bl = this.edgeStore.add(edge);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public boolean addAllEdges(Collection<? extends Edge> edges) {
        this.autoWriteLock();
        try {
            boolean bl = this.edgeStore.addAll(edges);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public NodeImpl getNode(Object id) {
        this.autoReadLock();
        try {
            NodeImpl nodeImpl = this.nodeStore.get(id);
            return nodeImpl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public EdgeImpl getEdge(Object id) {
        this.autoReadLock();
        try {
            EdgeImpl edgeImpl = this.edgeStore.get(id);
            return edgeImpl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public Edge getMutualEdge(Edge edge) {
        this.autoReadLock();
        try {
            EdgeImpl edgeImpl = this.edgeStore.getMutualEdge(edge);
            return edgeImpl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public NodeIterable getNodes() {
        return this.nodeStore;
    }

    @Override
    public EdgeIterable getEdges() {
        return this.edgeStore;
    }

    @Override
    public EdgeIterable getSelfLoops() {
        return new EdgeIterableWrapper(this.edgeStore.iteratorSelfLoop());
    }

    @Override
    public boolean removeNode(Node node) {
        this.autoWriteLock();
        try {
            this.nodeStore.checkNonNullNodeObject(node);
            EdgeStore.EdgeInOutIterator edgeIterator = this.edgeStore.edgeIterator((NodeImpl)node);
            while (edgeIterator.hasNext()) {
                edgeIterator.next();
                edgeIterator.remove();
            }
            boolean bl = this.nodeStore.remove(node);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public boolean removeEdge(Edge edge) {
        this.autoWriteLock();
        try {
            boolean bl = this.edgeStore.remove(edge);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAllNodes(Collection<? extends Node> nodes) {
        this.autoWriteLock();
        try {
            for (Node node : nodes) {
                this.nodeStore.checkNonNullNodeObject(node);
                EdgeStore.EdgeInOutIterator edgeIterator = this.edgeStore.edgeIterator((NodeImpl)node);
                while (edgeIterator.hasNext()) {
                    edgeIterator.next();
                    edgeIterator.remove();
                }
            }
            boolean bl = this.nodeStore.removeAll(nodes);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public boolean removeAllEdges(Collection<? extends Edge> edges) {
        this.autoWriteLock();
        try {
            boolean bl = this.edgeStore.removeAll(edges);
            return bl;
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    public NodeStore getNodeStore() {
        return this.nodeStore;
    }

    public EdgeStore getEdgeStore() {
        return this.edgeStore;
    }

    @Override
    public boolean contains(Node node) {
        this.autoReadLock();
        try {
            boolean bl = this.nodeStore.contains(node);
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public boolean contains(Edge edge) {
        this.autoReadLock();
        try {
            boolean bl = this.edgeStore.contains(edge);
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Edge getEdge(Node node1, Node node2, int type) {
        this.autoReadLock();
        try {
            EdgeImpl edgeImpl = this.edgeStore.get(node1, node2, type);
            return edgeImpl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Edge getEdge(Node node1, Node node2) {
        this.autoReadLock();
        try {
            EdgeImpl edgeImpl = this.edgeStore.get(node1, node2);
            return edgeImpl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public NodeIterable getNeighbors(Node node) {
        return new NodeIterableWrapper(this.edgeStore.neighborIterator(node));
    }

    @Override
    public NodeIterable getNeighbors(Node node, int type) {
        return new NodeIterableWrapper(this.edgeStore.neighborIterator(node, type));
    }

    @Override
    public NodeIterable getPredecessors(Node node) {
        return new NodeIterableWrapper(this.edgeStore.neighborInIterator(node));
    }

    @Override
    public NodeIterable getPredecessors(Node node, int type) {
        return new NodeIterableWrapper(this.edgeStore.neighborInIterator(node, type));
    }

    @Override
    public NodeIterable getSuccessors(Node node) {
        return new NodeIterableWrapper(this.edgeStore.neighborOutIterator(node));
    }

    @Override
    public NodeIterable getSuccessors(Node node, int type) {
        return new NodeIterableWrapper(this.edgeStore.neighborOutIterator(node, type));
    }

    @Override
    public EdgeIterable getEdges(Node node) {
        return new EdgeIterableWrapper(this.edgeStore.edgeIterator(node));
    }

    @Override
    public EdgeIterable getEdges(Node node, int type) {
        return new EdgeIterableWrapper(this.edgeStore.edgeIterator(node, type));
    }

    @Override
    public EdgeIterable getInEdges(Node node) {
        return new EdgeIterableWrapper(this.edgeStore.edgeInIterator(node));
    }

    @Override
    public EdgeIterable getInEdges(Node node, int type) {
        return new EdgeIterableWrapper(this.edgeStore.edgeInIterator(node, type));
    }

    @Override
    public EdgeIterable getOutEdges(Node node) {
        return new EdgeIterableWrapper(this.edgeStore.edgeOutIterator(node));
    }

    @Override
    public EdgeIterable getOutEdges(Node node, int type) {
        return new EdgeIterableWrapper(this.edgeStore.edgeOutIterator(node, type));
    }

    @Override
    public int getNodeCount() {
        return this.nodeStore.size();
    }

    @Override
    public int getEdgeCount() {
        return this.edgeStore.size();
    }

    @Override
    public int getEdgeCount(int type) {
        this.autoReadLock();
        try {
            if (this.edgeTypeStore.contains(type)) {
                int n = this.edgeStore.size(type);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public Node getOpposite(Node node, Edge edge) {
        this.nodeStore.checkNonNullNodeObject(node);
        this.edgeStore.checkNonNullEdgeObject(edge);
        return edge.getSource() == node ? edge.getTarget() : edge.getSource();
    }

    @Override
    public int getDegree(Node node) {
        this.nodeStore.checkNonNullNodeObject(node);
        return ((NodeImpl)node).getDegree();
    }

    public int getUndirectedDegree(Node node) {
        this.nodeStore.checkNonNullNodeObject(node);
        return ((NodeImpl)node).getUndirectedDegree();
    }

    @Override
    public int getInDegree(Node node) {
        this.nodeStore.checkNonNullNodeObject(node);
        return ((NodeImpl)node).getInDegree();
    }

    @Override
    public int getOutDegree(Node node) {
        this.nodeStore.checkNonNullNodeObject(node);
        return ((NodeImpl)node).getOutDegree();
    }

    @Override
    public boolean isSelfLoop(Edge edge) {
        return edge.isSelfLoop();
    }

    @Override
    public boolean isDirected(Edge edge) {
        return edge.isDirected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdjacent(Node node1, Node node2) {
        this.autoReadLock();
        try {
            boolean bl = this.edgeStore.isAdjacent(node1, node2);
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdjacent(Node node1, Node node2, int type) {
        this.autoReadLock();
        try {
            boolean bl = this.edgeStore.isAdjacent(node1, node2, type);
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIncident(Edge edge1, Edge edge2) {
        this.autoReadLock();
        try {
            this.edgeStore.checkNonNullEdgeObject(edge1);
            this.edgeStore.checkNonNullEdgeObject(edge2);
            boolean bl = this.edgeStore.isIncident((EdgeImpl)edge1, (EdgeImpl)edge2);
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIncident(Node node, Edge edge) {
        this.autoReadLock();
        try {
            this.nodeStore.checkNonNullNodeObject(node);
            this.edgeStore.checkNonNullEdgeObject(edge);
            boolean bl = this.edgeStore.isIncident((NodeImpl)node, (EdgeImpl)edge);
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public void clearEdges(Node node) {
        this.autoWriteLock();
        try {
            EdgeStore.EdgeInOutIterator itr = this.edgeStore.edgeIterator(node);
            while (itr.hasNext()) {
                itr.next();
                itr.remove();
            }
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearEdges(Node node, int type) {
        this.autoWriteLock();
        try {
            EdgeStore.EdgeTypeInOutIterator itr = this.edgeStore.edgeIterator(node, type);
            while (itr.hasNext()) {
                itr.next();
                itr.remove();
            }
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public void clear() {
        this.autoWriteLock();
        try {
            this.edgeStore.clear();
            this.nodeStore.clear();
            this.edgeTypeStore.clear();
            this.edgeTable.store.indexStore.clear();
            this.nodeTable.store.indexStore.clear();
            this.timeStore.clear();
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public void clearEdges() {
        this.autoWriteLock();
        try {
            this.edgeStore.clear();
            this.edgeTypeStore.clear();
            this.edgeTable.store.indexStore.clear();
            this.timeStore.clearEdges();
        }
        finally {
            this.autoWriteUnlock();
        }
    }

    @Override
    public GraphView getView() {
        return this.mainGraphView;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.getValue(key);
    }

    @Override
    public Object getAttribute(String key, double timestamp) {
        return this.attributes.getValue(key, timestamp);
    }

    @Override
    public Set<String> getAttributeKeys() {
        return this.attributes.getKeys();
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.setValue(key, value);
    }

    @Override
    public void setAttribute(String key, Object value, double timestamp) {
        this.attributes.setValue(key, value, timestamp);
    }

    @Override
    public void readLock() {
        this.lock.readLock();
    }

    @Override
    public void readUnlock() {
        this.lock.readUnlock();
    }

    @Override
    public void readUnlockAll() {
        this.lock.readUnlockAll();
    }

    @Override
    public void writeLock() {
        this.lock.writeLock();
    }

    @Override
    public void writeUnlock() {
        this.lock.writeUnlock();
    }

    protected void autoReadLock() {
        this.readLock();
    }

    protected void autoReadUnlock() {
        this.readUnlock();
    }

    protected void autoWriteLock() {
        this.writeLock();
    }

    protected void autoWriteUnlock() {
        this.writeUnlock();
    }

    @Override
    public GraphModel getModel() {
        return this.graphModel;
    }

    @Override
    public boolean isDirected() {
        this.autoReadLock();
        try {
            boolean bl = this.edgeStore.isDirectedGraph();
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public boolean isUndirected() {
        this.autoReadLock();
        try {
            boolean bl = this.edgeStore.isUndirectedGraph();
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public boolean isMixed() {
        this.autoReadLock();
        try {
            boolean bl = this.edgeStore.isMixedGraph();
            return bl;
        }
        finally {
            this.autoReadUnlock();
        }
    }

    @Override
    public void union(Subgraph subGraph) {
        throw new UnsupportedOperationException("Not supported for the main view.");
    }

    @Override
    public void intersection(Subgraph subGraph) {
        throw new UnsupportedOperationException("Not supported for the main view.");
    }

    @Override
    public void fill() {
        throw new UnsupportedOperationException("Not supported for the main view.");
    }

    @Override
    public void not() {
        throw new UnsupportedOperationException("Not supported for the main view.");
    }

    @Override
    public Graph getRootGraph() {
        return this;
    }

    protected GraphObserverImpl createGraphObserver(Graph graph, boolean withDiff) {
        if (graph.getView() != this.mainGraphView) {
            throw new RuntimeException("This graph doesn't belong to this store");
        }
        if (this.observers != null) {
            GraphObserverImpl observer = new GraphObserverImpl(this, this.version, graph, withDiff);
            this.observers.add(observer);
            return observer;
        }
        return null;
    }

    protected void destroyGraphObserver(GraphObserverImpl observer) {
        if (this.observers != null) {
            if (observer.graph.getView() != this.mainGraphView) {
                throw new RuntimeException("This graph doesn't belong to this store");
            }
            this.observers.remove(observer);
            observer.destroyObserver();
        }
    }

    protected EdgeIterableWrapper getEdgeIterableWrapper(Iterator<Edge> edgeIterator) {
        return new EdgeIterableWrapper(edgeIterator);
    }

    protected NodeIterableWrapper getNodeIterableWrapper(Iterator<Node> nodeIterator) {
        return new NodeIterableWrapper(nodeIterator);
    }

    protected EdgeIterableWrapper getEdgeIterableWrapper(Iterator<Edge> edgeIterator, boolean blocking) {
        return new EdgeIterableWrapper(edgeIterator, blocking);
    }

    protected NodeIterableWrapper getNodeIterableWrapper(Iterator<Node> nodeIterator, boolean blocking) {
        return new NodeIterableWrapper(nodeIterator, blocking);
    }

    public int deepHashCode() {
        int hash = 3;
        hash = 29 * hash + (this.nodeStore != null ? this.nodeStore.deepHashCode() : 0);
        hash = 29 * hash + (this.edgeStore != null ? this.edgeStore.deepHashCode() : 0);
        hash = 29 * hash + (this.edgeTypeStore != null ? this.edgeTypeStore.deepHashCode() : 0);
        hash = 29 * hash + (this.nodeTable != null ? this.nodeTable.deepHashCode() : 0);
        hash = 29 * hash + (this.edgeTable != null ? this.edgeTable.deepHashCode() : 0);
        return hash;
    }

    public boolean deepEquals(GraphStore obj) {
        if (obj == null) {
            return false;
        }
        if (!(this.nodeStore == obj.nodeStore || this.nodeStore != null && this.nodeStore.deepEquals(obj.nodeStore))) {
            return false;
        }
        if (!(this.edgeStore == obj.edgeStore || this.edgeStore != null && this.edgeStore.deepEquals(obj.edgeStore))) {
            return false;
        }
        if (!(this.edgeTypeStore == obj.edgeTypeStore || this.edgeTypeStore != null && this.edgeTypeStore.deepEquals(obj.edgeTypeStore))) {
            return false;
        }
        if (!(this.nodeTable == obj.nodeTable || this.nodeTable != null && this.nodeTable.deepEquals(obj.nodeTable))) {
            return false;
        }
        return this.edgeTable == obj.edgeTable || this.edgeTable != null && this.edgeTable.deepEquals(obj.edgeTable);
    }

    private final class MainGraphView
    implements GraphView {
        private MainGraphView() {
        }

        @Override
        public GraphModel getGraphModel() {
            return GraphStore.this.graphModel;
        }

        @Override
        public boolean isMainView() {
            return true;
        }

        @Override
        public boolean isNodeView() {
            return true;
        }

        @Override
        public boolean isEdgeView() {
            return true;
        }

        @Override
        public boolean isDestroyed() {
            return false;
        }

        @Override
        public Interval getTimeInterval() {
            return Interval.INFINITY_INTERVAL;
        }
    }

    protected class EdgeIterableWrapper
    implements EdgeIterable {
        protected final Iterator<Edge> iterator;
        protected final boolean blocking;

        public EdgeIterableWrapper(Iterator<Edge> iterator) {
            this(iterator, true);
        }

        public EdgeIterableWrapper(Iterator<Edge> iterator, boolean blocking) {
            this.iterator = iterator;
            this.blocking = blocking;
        }

        @Override
        public Iterator<Edge> iterator() {
            return this.iterator;
        }

        @Override
        public Edge[] toArray() {
            ArrayList<Edge> list = new ArrayList<Edge>();
            while (this.iterator.hasNext()) {
                list.add(this.iterator.next());
            }
            return list.toArray(new Edge[0]);
        }

        @Override
        public Collection<Edge> toCollection() {
            ArrayList<Edge> list = new ArrayList<Edge>();
            while (this.iterator.hasNext()) {
                list.add(this.iterator.next());
            }
            return list;
        }

        @Override
        public void doBreak() {
            if (this.blocking) {
                GraphStore.this.autoReadUnlock();
            }
        }
    }

    protected class NodeIterableWrapper
    implements NodeIterable {
        protected final Iterator<Node> iterator;
        protected final boolean blocking;

        public NodeIterableWrapper(Iterator<Node> iterator) {
            this(iterator, true);
        }

        public NodeIterableWrapper(Iterator<Node> iterator, boolean blocking) {
            this.iterator = iterator;
            this.blocking = blocking;
        }

        @Override
        public Iterator<Node> iterator() {
            return this.iterator;
        }

        @Override
        public Node[] toArray() {
            ArrayList<Node> list = new ArrayList<Node>();
            while (this.iterator.hasNext()) {
                list.add(this.iterator.next());
            }
            return list.toArray(new Node[0]);
        }

        @Override
        public Collection<Node> toCollection() {
            ArrayList<Node> list = new ArrayList<Node>();
            while (this.iterator.hasNext()) {
                list.add(this.iterator.next());
            }
            return list;
        }

        @Override
        public void doBreak() {
            if (this.blocking) {
                GraphStore.this.autoReadUnlock();
            }
        }
    }
}

