/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.awt.Color;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeProperties;
import org.gephi.graph.impl.ColumnStore;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.ElementImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.TextPropertiesImpl;
import org.gephi.graph.impl.TimeIndexStore;
import org.gephi.graph.spi.LayoutData;

public class NodeImpl
extends ElementImpl
implements Node {
    protected int storeId = -1;
    protected EdgeImpl[] headOut = new EdgeImpl[1];
    protected EdgeImpl[] headIn = new EdgeImpl[1];
    protected int inDegree;
    protected int outDegree;
    protected int mutualDegree;
    protected final NodePropertiesImpl properties;

    public NodeImpl(Object id, GraphStore graphStore) {
        super(id, graphStore);
        this.checkIdType(id);
        this.properties = new NodePropertiesImpl();
        this.attributes = new Object[1];
        this.attributes[0] = id;
    }

    public NodeImpl(Object id) {
        this(id, null);
    }

    @Override
    public int getStoreId() {
        return this.storeId;
    }

    public void setStoreId(int id) {
        this.storeId = id;
    }

    public int getDegree() {
        return this.inDegree + this.outDegree;
    }

    public int getInDegree() {
        return this.inDegree;
    }

    public int getOutDegree() {
        return this.outDegree;
    }

    public int getUndirectedDegree() {
        return this.inDegree + this.outDegree - this.mutualDegree;
    }

    @Override
    ColumnStore getColumnStore() {
        if (this.graphStore != null) {
            return this.graphStore.nodeTable.store;
        }
        return null;
    }

    @Override
    TimeIndexStore getTimeIndexStore() {
        if (this.graphStore != null) {
            return this.graphStore.timeStore.nodeIndexStore;
        }
        return null;
    }

    @Override
    boolean isValid() {
        return this.storeId != -1;
    }

    @Override
    public float x() {
        return this.properties.x;
    }

    @Override
    public float y() {
        return this.properties.y;
    }

    @Override
    public float z() {
        return this.properties.z;
    }

    @Override
    public float r() {
        return this.properties.r();
    }

    @Override
    public float g() {
        return this.properties.g();
    }

    @Override
    public float b() {
        return this.properties.b();
    }

    @Override
    public float alpha() {
        return this.properties.alpha();
    }

    @Override
    public int getRGBA() {
        return this.properties.rgba;
    }

    @Override
    public Color getColor() {
        return this.properties.getColor();
    }

    @Override
    public float size() {
        return this.properties.size;
    }

    @Override
    public boolean isFixed() {
        return this.properties.isFixed();
    }

    @Override
    public <T extends LayoutData> T getLayoutData() {
        return this.properties.getLayoutData();
    }

    @Override
    public TextPropertiesImpl getTextProperties() {
        return this.properties.getTextProperties();
    }

    protected void setNodeProperties(NodePropertiesImpl nodeProperties) {
        this.properties.x = nodeProperties.x;
        this.properties.y = nodeProperties.y;
        this.properties.z = nodeProperties.z;
        this.properties.rgba = nodeProperties.rgba;
        this.properties.size = nodeProperties.size;
        this.properties.fixed = nodeProperties.fixed;
        if (this.properties.textProperties != null) {
            this.properties.setTextProperties(nodeProperties.textProperties);
        }
    }

    @Override
    public void setX(float x) {
        this.properties.setX(x);
    }

    @Override
    public void setY(float y) {
        this.properties.setY(y);
    }

    @Override
    public void setZ(float z) {
        this.properties.setZ(z);
    }

    @Override
    public void setPosition(float x, float y) {
        this.properties.setPosition(x, y);
    }

    @Override
    public void setPosition(float x, float y, float z) {
        this.properties.setPosition(x, y, z);
    }

    @Override
    public void setR(float r) {
        this.properties.setR(r);
    }

    @Override
    public void setG(float g) {
        this.properties.setG(g);
    }

    @Override
    public void setB(float b) {
        this.properties.setB(b);
    }

    @Override
    public void setAlpha(float a) {
        this.properties.setAlpha(a);
    }

    @Override
    public void setColor(Color color) {
        this.properties.setColor(color);
    }

    @Override
    public void setSize(float size) {
        this.properties.setSize(size);
    }

    @Override
    public void setFixed(boolean fixed) {
        this.properties.setFixed(fixed);
    }

    @Override
    public void setLayoutData(LayoutData layoutData) {
        this.properties.setLayoutData(layoutData);
    }

    final void checkIdType(Object id) {
        if (this.graphStore != null && !id.getClass().equals(this.graphStore.configuration.getNodeIdType())) {
            throw new IllegalArgumentException("The id class does not match with the expected type (" + this.graphStore.configuration.getNodeIdType().getName() + ")");
        }
    }

    protected static class NodePropertiesImpl
    implements NodeProperties {
        protected final TextPropertiesImpl textProperties = new TextPropertiesImpl();
        protected float x;
        protected float y;
        protected float z;
        protected int rgba = -16777216;
        protected float size;
        protected boolean fixed;
        protected LayoutData layoutData;

        @Override
        public float x() {
            return this.x;
        }

        @Override
        public float y() {
            return this.y;
        }

        @Override
        public float z() {
            return this.z;
        }

        @Override
        public float r() {
            return (float)(this.rgba >> 16 & 0xFF) / 255.0f;
        }

        @Override
        public float g() {
            return (float)(this.rgba >> 8 & 0xFF) / 255.0f;
        }

        @Override
        public float b() {
            return (float)(this.rgba & 0xFF) / 255.0f;
        }

        @Override
        public float alpha() {
            return (float)(this.rgba >> 24 & 0xFF) / 255.0f;
        }

        @Override
        public int getRGBA() {
            return this.rgba;
        }

        @Override
        public Color getColor() {
            return new Color(this.rgba, true);
        }

        @Override
        public float size() {
            return this.size;
        }

        @Override
        public boolean isFixed() {
            return this.fixed;
        }

        @Override
        public <T extends LayoutData> T getLayoutData() {
            return (T)this.layoutData;
        }

        @Override
        public TextPropertiesImpl getTextProperties() {
            return this.textProperties;
        }

        protected void setTextProperties(TextPropertiesImpl textProperties) {
            this.textProperties.rgba = textProperties.rgba;
            this.textProperties.size = textProperties.size;
            this.textProperties.text = textProperties.text;
            this.textProperties.visible = textProperties.visible;
        }

        @Override
        public void setX(float x) {
            this.x = x;
        }

        @Override
        public void setY(float y) {
            this.y = y;
        }

        @Override
        public void setZ(float z) {
            this.z = z;
        }

        @Override
        public void setPosition(float x, float y) {
            this.x = x;
            this.y = y;
        }

        @Override
        public void setPosition(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        @Override
        public void setR(float r) {
            this.rgba = this.rgba & 0xFF00FFFF | (int)(r * 255.0f) << 16;
        }

        @Override
        public void setG(float g) {
            this.rgba = this.rgba & 0xFFFF00FF | (int)(g * 255.0f) << 8;
        }

        @Override
        public void setB(float b) {
            this.rgba = this.rgba & 0xFFFFFF00 | (int)(b * 255.0f);
        }

        @Override
        public void setAlpha(float a) {
            this.rgba = this.rgba & 0xFFFFFF | (int)(a * 255.0f) << 24;
        }

        @Override
        public void setColor(Color color) {
            this.rgba = color.getAlpha() << 24 | color.getRGB();
        }

        @Override
        public void setSize(float size) {
            this.size = size;
        }

        @Override
        public void setFixed(boolean fixed) {
            this.fixed = fixed;
        }

        @Override
        public void setLayoutData(LayoutData layoutData) {
            this.layoutData = layoutData;
        }

        public int deepHashCode() {
            int hash = 3;
            hash = 53 * hash + Float.floatToIntBits(this.x);
            hash = 53 * hash + Float.floatToIntBits(this.y);
            hash = 53 * hash + Float.floatToIntBits(this.z);
            hash = 53 * hash + this.rgba;
            hash = 53 * hash + Float.floatToIntBits(this.size);
            hash = 53 * hash + (this.fixed ? 1 : 0);
            hash = 53 * hash + (this.layoutData != null ? this.layoutData.hashCode() : 0);
            hash = 53 * hash + (this.textProperties != null ? this.textProperties.deepHashCode() : 0);
            return hash;
        }

        public boolean deepEquals(NodePropertiesImpl obj) {
            if (obj == null) {
                return false;
            }
            if (Float.floatToIntBits(this.x) != Float.floatToIntBits(obj.x)) {
                return false;
            }
            if (Float.floatToIntBits(this.y) != Float.floatToIntBits(obj.y)) {
                return false;
            }
            if (Float.floatToIntBits(this.z) != Float.floatToIntBits(obj.z)) {
                return false;
            }
            if (this.rgba != obj.rgba) {
                return false;
            }
            if (Float.floatToIntBits(this.size) != Float.floatToIntBits(obj.size)) {
                return false;
            }
            if (this.fixed != obj.fixed) {
                return false;
            }
            if (!(this.layoutData == obj.layoutData || this.layoutData != null && this.layoutData.equals(obj.layoutData))) {
                return false;
            }
            return this.textProperties == obj.textProperties || this.textProperties != null && this.textProperties.deepEquals(obj.textProperties);
        }
    }
}

