/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.ArrayList;
import java.util.List;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.types.TimeMap;
import org.gephi.graph.api.types.TimeSet;
import org.gephi.graph.impl.ColumnObserverImpl;
import org.gephi.graph.impl.ColumnVersion;
import org.gephi.graph.impl.ElementImpl;
import org.gephi.graph.impl.TableImpl;

public class ColumnImpl
implements Column {
    protected final TableImpl table;
    protected final String id;
    protected final Class typeClass;
    protected final String title;
    protected final Object defaultValue;
    protected final Origin origin;
    protected final ColumnVersion version;
    protected final boolean indexed;
    protected final boolean dynamic;
    protected final boolean readOnly;
    protected Estimator estimator;
    protected final List<ColumnObserverImpl> observers;
    protected int storeId = -1;

    public ColumnImpl(TableImpl table, String id, Class typeClass, String title, Object defaultValue, Origin origin, boolean indexed, boolean readOnly) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("The column ID can't be null or empty");
        }
        if (typeClass == null) {
            throw new NullPointerException("The type class can't be null");
        }
        if (origin == null) {
            throw new NullPointerException("The origin can't be null");
        }
        typeClass = AttributeUtils.getStandardizedType(typeClass);
        this.table = table;
        this.id = id.toLowerCase();
        this.typeClass = typeClass;
        this.title = title;
        this.defaultValue = defaultValue;
        this.version = new ColumnVersion(this);
        this.origin = origin;
        this.indexed = indexed;
        this.readOnly = readOnly;
        this.dynamic = TimeMap.class.isAssignableFrom(typeClass) || TimeSet.class.isAssignableFrom(typeClass);
        this.observers = new ArrayList<ColumnObserverImpl>();
        this.estimator = this.dynamic ? Estimator.FIRST : null;
    }

    public ColumnImpl(String id, Class typeClass, String title, Object defaultValue, Origin origin, boolean indexed, boolean readOnly) {
        this(null, id, typeClass, title, defaultValue, origin, indexed, readOnly);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int getIndex() {
        return this.storeId;
    }

    @Override
    public Class getTypeClass() {
        return this.typeClass;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public Origin getOrigin() {
        return this.origin;
    }

    @Override
    public Table getTable() {
        return this.table;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }

    @Override
    public boolean isArray() {
        return this.typeClass.isArray();
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public boolean isNumber() {
        return AttributeUtils.isNumberType(this.typeClass);
    }

    @Override
    public boolean isProperty() {
        return this.origin.equals((Object)Origin.PROPERTY);
    }

    public int getStoreId() {
        return this.storeId;
    }

    public void setStoreId(int storeId) {
        this.storeId = storeId;
    }

    public String toString() {
        return this.title + " (" + this.typeClass.toString() + ")";
    }

    @Override
    public Estimator getEstimator() {
        return this.estimator;
    }

    @Override
    public void setEstimator(Estimator estimator) {
        if (!this.dynamic) {
            throw new IllegalStateException("The column must have a dynamic type");
        }
        if (TimeMap.class.isAssignableFrom(this.typeClass)) {
            TimeMap vs = null;
            try {
                vs = (TimeMap)this.typeClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new RuntimeException(ex);
            }
            if (!vs.isSupported(estimator)) {
                throw new IllegalArgumentException("The column doesnt't support this estimator");
            }
            this.estimator = estimator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ColumnObserverImpl createColumnObserver(boolean withDiff) {
        if (this.observers != null) {
            ColumnObserverImpl observer = new ColumnObserverImpl(this.table.store.graphStore, this, withDiff);
            List<ColumnObserverImpl> list = this.observers;
            synchronized (list) {
                this.observers.add(observer);
            }
            return observer;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyColumnObserver(ColumnObserverImpl observer) {
        if (this.observers != null) {
            List<ColumnObserverImpl> list = this.observers;
            synchronized (list) {
                this.observers.remove(observer);
            }
            observer.destroyObserver();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void incrementVersion(ElementImpl element) {
        this.version.incrementAndGetVersion();
        if (this.observers != null && !this.observers.isEmpty()) {
            List<ColumnObserverImpl> list = this.observers;
            synchronized (list) {
                for (ColumnObserverImpl observer : this.observers) {
                    observer.setElement(element);
                }
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof Column) {
            ColumnImpl o = (ColumnImpl)obj;
            return this.id.equals(o.id) && o.typeClass == this.typeClass;
        }
        return false;
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 53 * hash + (this.typeClass != null ? this.typeClass.hashCode() : 0);
        return hash;
    }

    public int deepHashCode() {
        int hash = 3;
        hash = 31 * hash + (this.id != null ? this.id.hashCode() : 0);
        hash = 31 * hash + (this.typeClass != null ? this.typeClass.hashCode() : 0);
        hash = 31 * hash + (this.title != null ? this.title.hashCode() : 0);
        hash = 31 * hash + (this.defaultValue != null ? this.defaultValue.hashCode() : 0);
        hash = 31 * hash + (this.origin != null ? this.origin.hashCode() : 0);
        hash = 31 * hash + (this.estimator != null ? this.estimator.hashCode() : 0);
        return hash;
    }

    public boolean deepEquals(ColumnImpl col) {
        if (this == col) {
            return true;
        }
        if (col == null) {
            return false;
        }
        if (this.id == null ? col.id != null : !this.id.equals(col.id)) {
            return false;
        }
        if (this.title == null ? col.title != null : !this.title.equals(col.title)) {
            return false;
        }
        if (!(this.typeClass == col.typeClass || this.typeClass != null && this.typeClass.equals(col.typeClass))) {
            return false;
        }
        if (!(this.defaultValue == col.defaultValue || this.defaultValue != null && this.defaultValue.equals(col.defaultValue))) {
            return false;
        }
        if (this.origin != col.origin) {
            return false;
        }
        return this.estimator == col.estimator;
    }
}

