/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.ElementIterable;
import org.gephi.graph.impl.GraphLock;

public abstract class ElementIterableWrapper<T extends Element>
implements ElementIterable<T> {
    protected final Iterator<T> iterator;
    protected final GraphLock lock;

    public ElementIterableWrapper(Iterator<T> iterator) {
        this(iterator, null);
    }

    public ElementIterableWrapper(Iterator<T> iterator, GraphLock lock) {
        this.iterator = iterator;
        this.lock = lock;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator;
    }

    protected T[] toArray(T[] a) {
        return (Element[])this.toCollection().toArray(a);
    }

    @Override
    public Collection<T> toCollection() {
        ArrayList<Element> list = new ArrayList<Element>();
        while (this.iterator.hasNext()) {
            list.add((Element)this.iterator.next());
        }
        return list;
    }

    @Override
    public void doBreak() {
        if (this.lock != null) {
            this.lock.readUnlock();
        }
    }
}

