/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Rect2D;
import org.gephi.graph.impl.GraphLock;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.SpatialNodeDataImpl;

public class NodesQuadTree {
    protected final GraphLock lock = new GraphLock();
    private final QuadTreeNode quadTreeRoot;
    private final int maxLevels;
    private final int maxObjectsPerNode;

    public NodesQuadTree(Rect2D rect) {
        this(rect, 16, 5000);
    }

    public NodesQuadTree(Rect2D rect, int maxLevels, int maxObjectsPerNode) {
        this.quadTreeRoot = new QuadTreeNode(rect);
        this.maxLevels = maxLevels;
        this.maxObjectsPerNode = maxObjectsPerNode;
    }

    public Rect2D quadRect() {
        return this.quadTreeRoot.quadRect();
    }

    public NodeIterable getNodes(Rect2D searchRect) {
        return this.quadTreeRoot.getNodes(searchRect);
    }

    public void getNodes(Rect2D searchRect, Consumer<Node> callback) {
        this.quadTreeRoot.getNodes(searchRect, callback);
    }

    public NodeIterable getNodes(float minX, float minY, float maxX, float maxY) {
        return this.quadTreeRoot.getNodes(new Rect2D(minX, minY, maxX, maxY));
    }

    public void getNodes(float minX, float minY, float maxX, float maxY, Consumer<Node> callback) {
        this.quadTreeRoot.getNodes(new Rect2D(minX, minY, maxX, maxY), callback);
    }

    public NodeIterable getAllNodes() {
        return this.quadTreeRoot.getAllNodes();
    }

    public void getAllNodes(Consumer<Node> callback) {
        this.quadTreeRoot.getAllNodes(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateNode(NodeImpl item, float minX, float minY, float maxX, float maxY) {
        this.writeLock();
        try {
            SpatialNodeDataImpl obj = item.getSpatialData();
            if (obj != null) {
                obj.updateBoundaries(minX, minY, maxX, maxY);
                this.quadTreeRoot.update(item);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addNode(NodeImpl item) {
        this.writeLock();
        try {
            float x = item.x();
            float y = item.y();
            float size = item.size();
            float minX = x - size;
            float minY = y - size;
            float maxX = x + size;
            float maxY = y + size;
            SpatialNodeDataImpl spatialData = item.getSpatialData();
            if (spatialData == null) {
                spatialData = new SpatialNodeDataImpl(minX, minY, maxX, maxY);
                item.setSpatialDate(spatialData);
                this.quadTreeRoot.insert(item);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.writeLock();
        try {
            for (Node node : this.getAllNodes()) {
                SpatialNodeDataImpl spatialData = ((NodeImpl)node).getSpatialData();
                spatialData.setQuadTreeNode(null);
            }
            this.quadTreeRoot.clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeNode(NodeImpl item) {
        this.writeLock();
        try {
            SpatialNodeDataImpl spatialData = item.getSpatialData();
            if (spatialData != null && spatialData.quadTreeNode != null) {
                this.quadTreeRoot.delete(item, true);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.writeUnlock();
        }
    }

    public int getObjectCount() {
        this.readLock();
        int count = this.quadTreeRoot.objectCount();
        this.readUnlock();
        return count;
    }

    public void readLock() {
        if (this.lock != null) {
            this.lock.readLock();
        }
    }

    public void readUnlock() {
        if (this.lock != null) {
            this.lock.readUnlock();
        }
    }

    public void writeLock() {
        if (this.lock != null) {
            this.lock.writeLock();
        }
    }

    public void writeUnlock() {
        if (this.lock != null) {
            this.lock.writeUnlock();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.quadTreeRoot.toString(sb);
        return sb.toString();
    }

    public int getDepth() {
        this.readLock();
        int depth = this.quadTreeRoot.getDepth();
        this.readUnlock();
        return depth;
    }

    private class QuadTreeNodesIterator
    implements Iterator<Node> {
        private final Rect2D searchRect;
        private final Deque<QuadTreeNode> nodesStack = new ArrayDeque<QuadTreeNode>();
        private final Deque<Boolean> fullyContainedStack = new ArrayDeque<Boolean>();
        private Iterator<NodeImpl> currentIterator;
        private boolean currentFullyContained;
        private boolean finished = false;
        private NodeImpl next;

        public QuadTreeNodesIterator(QuadTreeNode root, Rect2D searchRect) {
            this.searchRect = searchRect;
            NodesQuadTree.this.readLock();
            this.currentFullyContained = searchRect == null;
            this.addChildrenToVisit(root, this.currentFullyContained);
            this.currentIterator = root.objects != null ? root.objects.iterator() : null;
        }

        private void addChildrenToVisit(QuadTreeNode quadTreeNode, boolean fullyContained) {
            if (quadTreeNode.childTL != null) {
                this.nodesStack.push(quadTreeNode.childBR);
                this.nodesStack.push(quadTreeNode.childBL);
                this.nodesStack.push(quadTreeNode.childTR);
                this.nodesStack.push(quadTreeNode.childTL);
                this.fullyContainedStack.push(fullyContained);
                this.fullyContainedStack.push(fullyContained);
                this.fullyContainedStack.push(fullyContained);
                this.fullyContainedStack.push(fullyContained);
            }
        }

        @Override
        public boolean hasNext() {
            if (this.finished) {
                return false;
            }
            if (this.next != null) {
                return true;
            }
            while (this.currentIterator != null || !this.nodesStack.isEmpty()) {
                if (this.currentIterator != null) {
                    while (this.currentIterator.hasNext()) {
                        NodeImpl elem = this.currentIterator.next();
                        SpatialNodeDataImpl spatialData = elem.getSpatialData();
                        if (!this.currentFullyContained && !this.searchRect.intersects(spatialData.minX, spatialData.minY, spatialData.maxX, spatialData.maxY)) continue;
                        this.next = elem;
                        return true;
                    }
                    this.currentIterator = null;
                    continue;
                }
                QuadTreeNode pointer = this.nodesStack.pop();
                boolean bl = this.currentFullyContained = this.fullyContainedStack.pop() != false || this.searchRect.contains(pointer.rect);
                if (this.currentFullyContained || pointer.rect.intersects(this.searchRect)) {
                    this.addChildrenToVisit(pointer, this.currentFullyContained);
                    this.currentIterator = pointer.objects != null ? pointer.objects.iterator() : null;
                    continue;
                }
                this.currentIterator = null;
            }
            NodesQuadTree.this.readUnlock();
            this.finished = true;
            return false;
        }

        @Override
        public NodeImpl next() {
            if (this.next == null) {
                throw new IllegalStateException("No next available!");
            }
            NodeImpl node = this.next;
            this.next = null;
            return node;
        }
    }

    private class QuadTreeNodesIterable
    implements NodeIterable {
        private final Rect2D searchRect;

        public QuadTreeNodesIterable(Rect2D searchRect) {
            this.searchRect = searchRect;
        }

        @Override
        public Iterator<Node> iterator() {
            return new QuadTreeNodesIterator(NodesQuadTree.this.quadTreeRoot, this.searchRect);
        }

        @Override
        public Node[] toArray() {
            Collection<Node> collection = this.toCollection();
            return collection.toArray(new Node[0]);
        }

        @Override
        public Collection<Node> toCollection() {
            ArrayList<Node> list = new ArrayList<Node>();
            for (Node node : this) {
                list.add(node);
            }
            return list;
        }

        @Override
        public void doBreak() {
            NodesQuadTree.this.readUnlock();
        }
    }

    protected class QuadTreeNode {
        private Set<NodeImpl> objects = null;
        private final Rect2D rect;
        private final QuadTreeNode parent;
        private final int level;
        private QuadTreeNode childTL = null;
        private QuadTreeNode childTR = null;
        private QuadTreeNode childBL = null;
        private QuadTreeNode childBR = null;

        public Rect2D quadRect() {
            return this.rect;
        }

        public QuadTreeNode topLeftChild() {
            return this.childTL;
        }

        public QuadTreeNode topRightChild() {
            return this.childTR;
        }

        public QuadTreeNode bottomLeftChild() {
            return this.childBL;
        }

        public QuadTreeNode bottomRightChild() {
            return this.childBR;
        }

        public QuadTreeNode parent() {
            return this.parent;
        }

        public int count() {
            return this.objectCount();
        }

        public boolean isEmptyLeaf() {
            return this.count() == 0 && this.childTL == null;
        }

        public QuadTreeNode(Rect2D rect) {
            this(null, 0, rect);
        }

        private QuadTreeNode(QuadTreeNode parent, int level, Rect2D rect) {
            this.level = level;
            this.rect = rect;
            this.parent = parent;
        }

        private void add(NodeImpl item) {
            if (this.objects == null) {
                this.objects = new LinkedHashSet<NodeImpl>();
            }
            item.getSpatialData().setQuadTreeNode(this);
            this.objects.add(item);
        }

        private void remove(NodeImpl item) {
            if (this.objects != null) {
                this.objects.remove(item);
            }
        }

        private int objectCount() {
            int count = 0;
            if (this.objects != null) {
                count += this.objects.size();
            }
            if (this.childTL != null) {
                count += this.childTL.objectCount();
                count += this.childTR.objectCount();
                count += this.childBL.objectCount();
                count += this.childBR.objectCount();
            }
            return count;
        }

        private void subdivide() {
            float minX = this.rect.minX;
            float halfX = (this.rect.minX + this.rect.maxX) / 2.0f;
            float maxX = this.rect.maxX;
            float minY = this.rect.minY;
            float halfY = (this.rect.minY + this.rect.maxY) / 2.0f;
            float maxY = this.rect.maxY;
            this.childTL = new QuadTreeNode(this, this.level + 1, new Rect2D(minX, minY, halfX, halfY));
            this.childTR = new QuadTreeNode(this, this.level + 1, new Rect2D(halfX, minY, maxX, halfY));
            this.childBL = new QuadTreeNode(this, this.level + 1, new Rect2D(minX, halfY, halfX, maxY));
            this.childBR = new QuadTreeNode(this, this.level + 1, new Rect2D(halfX, halfY, maxX, maxY));
            Iterator<NodeImpl> iterator = this.objects.iterator();
            while (iterator.hasNext()) {
                NodeImpl obj = iterator.next();
                QuadTreeNode destTree = this.getDestinationTree(obj);
                if (destTree == this) continue;
                destTree.insert(obj);
                iterator.remove();
            }
        }

        private QuadTreeNode getDestinationTree(NodeImpl item) {
            SpatialNodeDataImpl spatialData = item.getSpatialData();
            float minX = spatialData.minX;
            float minY = spatialData.minY;
            float maxX = spatialData.maxX;
            float maxY = spatialData.maxY;
            QuadTreeNode destTree = this.childTL.quadRect().contains(minX, minY, maxX, maxY) ? this.childTL : (this.childTR.quadRect().contains(minX, minY, maxX, maxY) ? this.childTR : (this.childBL.quadRect().contains(minX, minY, maxX, maxY) ? this.childBL : (this.childBR.quadRect().contains(minX, minY, maxX, maxY) ? this.childBR : this)));
            return destTree;
        }

        private void relocate(NodeImpl item) {
            SpatialNodeDataImpl spatialData = item.getSpatialData();
            if (this.quadRect().contains(spatialData.minX, spatialData.minY, spatialData.maxX, spatialData.maxY)) {
                QuadTreeNode dest;
                if (this.childTL != null && spatialData.quadTreeNode != (dest = this.getDestinationTree(item))) {
                    QuadTreeNode formerOwner = spatialData.quadTreeNode;
                    this.delete(item, false);
                    dest.insert(item);
                    formerOwner.cleanUpwards();
                }
            } else if (this.parent != null) {
                this.parent.relocate(item);
            }
        }

        private void cleanUpwards() {
            if (this.childTL != null) {
                if (this.childTL.isEmptyLeaf() && this.childTR.isEmptyLeaf() && this.childBL.isEmptyLeaf() && this.childBR.isEmptyLeaf()) {
                    this.childTL = null;
                    this.childTR = null;
                    this.childBL = null;
                    this.childBR = null;
                    if (this.parent != null && this.count() == 0) {
                        this.parent.cleanUpwards();
                    }
                }
            } else if (this.parent != null && this.count() == 0) {
                this.parent.cleanUpwards();
            }
        }

        private void clear() {
            if (this.childTL != null) {
                this.childTL.clear();
                this.childTR.clear();
                this.childBL.clear();
                this.childBR.clear();
            }
            if (this.objects != null) {
                this.objects.clear();
                this.objects = null;
            }
            this.childTL = null;
            this.childTR = null;
            this.childBL = null;
            this.childBR = null;
        }

        private void delete(NodeImpl node, boolean clean) {
            SpatialNodeDataImpl spatialData = node.getSpatialData();
            if (spatialData.quadTreeNode != null) {
                if (spatialData.quadTreeNode == this) {
                    this.remove(node);
                    if (clean) {
                        this.cleanUpwards();
                    }
                } else {
                    spatialData.quadTreeNode.delete(node, clean);
                }
            }
        }

        private void insert(NodeImpl item) {
            SpatialNodeDataImpl spatialData = item.getSpatialData();
            if (!this.rect.contains(spatialData.minX, spatialData.minY, spatialData.maxX, spatialData.maxY)) {
                if (this.parent == null) {
                    this.add(item);
                } else {
                    throw new IllegalStateException("We are not the root, and this object doesn't fit here. How did we get here?");
                }
            }
            if (this.objects == null || this.childTL == null && (this.level >= NodesQuadTree.this.maxLevels || this.objects.size() + 1 <= NodesQuadTree.this.maxObjectsPerNode)) {
                this.add(item);
            } else {
                QuadTreeNode destTree;
                if (this.childTL == null) {
                    this.subdivide();
                }
                if ((destTree = this.getDestinationTree(item)) == this) {
                    this.add(item);
                } else {
                    destTree.insert(item);
                }
            }
        }

        private NodeIterable getNodes(Rect2D searchRect) {
            return new QuadTreeNodesIterable(searchRect);
        }

        private NodeIterable getAllNodes() {
            return new QuadTreeNodesIterable(null);
        }

        private void getNodes(Rect2D searchRect, Consumer<Node> callback) {
            if (searchRect.contains(this.rect)) {
                this.getAllNodes(callback);
            } else if (searchRect.intersects(this.rect)) {
                if (this.objects != null && !this.objects.isEmpty()) {
                    for (NodeImpl obj : this.objects) {
                        SpatialNodeDataImpl spatialData = obj.getSpatialData();
                        if (!searchRect.intersects(spatialData.minX, spatialData.minY, spatialData.maxX, spatialData.maxY)) continue;
                        callback.accept(obj);
                    }
                }
                if (this.childTL != null) {
                    this.childTL.getNodes(searchRect, callback);
                    this.childTR.getNodes(searchRect, callback);
                    this.childBL.getNodes(searchRect, callback);
                    this.childBR.getNodes(searchRect, callback);
                }
            }
        }

        private void getAllNodes(Consumer<Node> callback) {
            if (this.objects != null && !this.objects.isEmpty()) {
                for (NodeImpl obj : this.objects) {
                    callback.accept(obj);
                }
            }
            if (this.childTL != null) {
                this.childTL.getAllNodes(callback);
                this.childTR.getAllNodes(callback);
                this.childBL.getAllNodes(callback);
                this.childBR.getAllNodes(callback);
            }
        }

        private void update(NodeImpl item) {
            SpatialNodeDataImpl spatialData = item.getSpatialData();
            if (spatialData.quadTreeNode != null) {
                spatialData.quadTreeNode.relocate(item);
            } else {
                this.relocate(item);
            }
        }

        private int getDepth() {
            int maxLevel = this.level;
            if (this.childTL != null) {
                maxLevel = Math.max(maxLevel, this.childTL.getDepth());
                maxLevel = Math.max(maxLevel, this.childBR.getDepth());
                maxLevel = Math.max(maxLevel, this.childTR.getDepth());
                maxLevel = Math.max(maxLevel, this.childBL.getDepth());
            }
            return maxLevel;
        }

        public void toString(StringBuilder sb) {
            for (int i = 0; i < this.level; ++i) {
                sb.append("  ");
            }
            sb.append(this.rect.toString()).append('\n');
            if (this.objects != null) {
                for (NodeImpl object : this.objects) {
                    for (int i = 0; i <= this.level; ++i) {
                        sb.append("  ");
                    }
                    sb.append(object.getId()).append('\n');
                }
            }
            if (this.childTL != null) {
                this.childTL.toString(sb);
                this.childTR.toString(sb);
                this.childBL.toString(sb);
                this.childBR.toString(sb);
            }
        }
    }
}

