/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.Iterator;
import java.util.List;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.Origin;
import org.gephi.graph.api.Table;
import org.gephi.graph.api.TableObserver;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ColumnStore;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.TableObserverImpl;

public class TableImpl<T extends Element>
implements Table {
    protected final ColumnStore<T> store;

    public TableImpl(Class<T> elementType, boolean indexed) {
        this(null, elementType, indexed);
    }

    public TableImpl(GraphStore graphStore, Class<T> elementType, boolean indexed) {
        this.store = new ColumnStore<T>(graphStore, elementType, indexed);
    }

    @Override
    public Column addColumn(String id, Class type) {
        return this.addColumn(id, null, type, Origin.DATA, null, true);
    }

    @Override
    public Column addColumn(String id, Class type, Origin origin) {
        return this.addColumn(id, null, type, origin, null, true);
    }

    @Override
    public Column addColumn(String id, String title, Class type, Object defaultValue) {
        return this.addColumn(id, title, type, Origin.DATA, defaultValue, true);
    }

    @Override
    public Column addColumn(String id, String title, Class type, Origin origin, Object defaultValue, boolean indexed) {
        this.checkValidId(id);
        this.checkSupportedTypes(type);
        this.checkDefaultValue(defaultValue, type);
        type = AttributeUtils.getStandardizedType(type);
        if (defaultValue != null) {
            defaultValue = AttributeUtils.standardizeValue(defaultValue);
        }
        if (title == null || title.isEmpty()) {
            title = id;
        }
        id = id.toLowerCase();
        if (indexed && this.store.indexStore == null) {
            indexed = false;
        }
        ColumnImpl column = new ColumnImpl(this, id, type, title, defaultValue, origin, indexed, false);
        this.store.addColumn(column);
        return column;
    }

    @Override
    public int countColumns() {
        return this.store.size();
    }

    @Override
    public Iterator<Column> iterator() {
        return this.store.iterator();
    }

    @Override
    public void doBreak() {
        this.store.doBreak();
    }

    @Override
    public Column[] toArray() {
        return this.store.toArray();
    }

    @Override
    public List<Column> toList() {
        return this.store.toList();
    }

    @Override
    public Column getColumn(int index) {
        return this.store.getColumnByIndex(index);
    }

    @Override
    public Column getColumn(String id) {
        return this.store.getColumn(id.toLowerCase());
    }

    @Override
    public boolean hasColumn(String id) {
        return this.store.hasColumn(id.toLowerCase());
    }

    @Override
    public void removeColumn(Column column) {
        this.store.removeColumn(column);
    }

    @Override
    public void removeColumn(String id) {
        this.store.removeColumn(id.toLowerCase());
    }

    @Override
    public TableObserver createTableObserver(boolean withDiff) {
        return this.store.createTableObserver(this, withDiff);
    }

    @Override
    public Class getElementClass() {
        return this.store.elementType;
    }

    @Override
    public Graph getGraph() {
        return this.store.graphStore;
    }

    @Override
    public boolean isNodeTable() {
        return Node.class.equals(this.store.elementType);
    }

    @Override
    public boolean isEdgeTable() {
        return Edge.class.equals(this.store.elementType);
    }

    public void destroyTableObserver(TableObserver observer) {
        this.checkableTableObserver(observer);
        this.store.destroyTablesObserver((TableObserverImpl)observer);
    }

    public boolean deepEquals(TableImpl<T> obj) {
        if (obj == null) {
            return false;
        }
        return this.store == obj.store || this.store != null && this.store.deepEquals(obj.store);
    }

    public int deepHashCode() {
        int hash = 3;
        hash = 71 * hash + (this.store != null ? this.store.deepHashCode() : 0);
        return hash;
    }

    private void checkValidId(String id) {
        if (id == null) {
            throw new NullPointerException();
        }
        if (id.isEmpty()) {
            throw new IllegalArgumentException("The column id can't be empty.");
        }
        if (this.store.hasColumn(id.toLowerCase())) {
            throw new IllegalArgumentException("The column '" + id + "' already existing in the table");
        }
    }

    private void checkSupportedTypes(Class type) {
        if (!AttributeUtils.isSupported(type)) {
            throw new IllegalArgumentException("Unknown type " + type.getName());
        }
    }

    private void checkDefaultValue(Object defaultValue, Class type) {
        if (defaultValue != null && defaultValue.getClass() != type) {
            throw new IllegalArgumentException("The default value type cannot be cast to the type");
        }
    }

    private void checkableTableObserver(TableObserver observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        if (!(observer instanceof TableObserverImpl)) {
            throw new ClassCastException("The observer should be a TableObserverImpl instance");
        }
        if (((TableObserverImpl)observer).table != this) {
            throw new RuntimeException("The observer doesn't belong to this table");
        }
    }
}

