/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.IntervalMap;

public final class IntervalCharMap
extends IntervalMap<Character> {
    private char[] values;

    public IntervalCharMap() {
        this.values = new char[0];
    }

    public IntervalCharMap(int capacity) {
        super(capacity);
        this.values = new char[capacity];
    }

    public IntervalCharMap(double[] keys, char[] vals) {
        super(keys);
        this.values = new char[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public IntervalCharMap(IntervalCharMap source) {
        this(source.array, source.values);
    }

    public char getCharacter(Interval interval) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.values[index / 2];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public char getCharacter(Interval interval, char defaultValue) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.values[index / 2];
        }
        return defaultValue;
    }

    public char[] toCharacterArray() {
        return (char[])this.toNativeArray();
    }

    @Override
    public Class<Character> getTypeClass() {
        return Character.class;
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.FIRST, Estimator.LAST);
    }

    @Override
    protected Character getValue(int index) {
        return Character.valueOf(this.values[index]);
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (char[])array;
    }
}

