/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.IntervalMap;

public final class IntervalIntegerMap
extends IntervalMap<Integer> {
    private int[] values;

    public IntervalIntegerMap() {
        this.values = new int[0];
    }

    public IntervalIntegerMap(int capacity) {
        super(capacity);
        this.values = new int[capacity];
    }

    public IntervalIntegerMap(double[] keys, int[] vals) {
        super(keys);
        this.values = new int[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public IntervalIntegerMap(IntervalIntegerMap source) {
        this(source.array, source.values);
    }

    public int getInteger(Interval interval) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.values[index / 2];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public int getInteger(Interval interval, int defaultValue) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.values[index / 2];
        }
        return defaultValue;
    }

    public int[] toIntegerArray() {
        return (int[])this.toNativeArray();
    }

    @Override
    public Class<Integer> getTypeClass() {
        return Integer.class;
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.MIN, Estimator.MAX, Estimator.FIRST, Estimator.LAST, Estimator.AVERAGE);
    }

    @Override
    protected Object getMax(Interval interval) {
        Double max = this.getMaxDouble(interval);
        return max != null ? Integer.valueOf(max.intValue()) : null;
    }

    @Override
    protected Object getMin(Interval interval) {
        Double min = this.getMinDouble(interval);
        return min != null ? Integer.valueOf(min.intValue()) : null;
    }

    @Override
    protected Integer getValue(int index) {
        return this.values[index];
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (int[])array;
    }
}

