/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.IntervalMap;

public final class IntervalLongMap
extends IntervalMap<Long> {
    private long[] values;

    public IntervalLongMap() {
        this.values = new long[0];
    }

    public IntervalLongMap(int capacity) {
        super(capacity);
        this.values = new long[capacity];
    }

    public IntervalLongMap(double[] keys, long[] vals) {
        super(keys);
        this.values = new long[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public IntervalLongMap(IntervalLongMap source) {
        this(source.array, source.values);
    }

    public long getLong(Interval interval) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.values[index / 2];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public long getLong(Interval interval, long defaultValue) {
        int index = this.getIndex(interval.getLow(), interval.getHigh());
        if (index >= 0) {
            return this.values[index / 2];
        }
        return defaultValue;
    }

    public long[] toLongArray() {
        return (long[])this.toNativeArray();
    }

    @Override
    public Class<Long> getTypeClass() {
        return Long.class;
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.MIN, Estimator.MAX, Estimator.FIRST, Estimator.LAST, Estimator.AVERAGE);
    }

    @Override
    protected Object getMax(Interval interval) {
        Double max = this.getMaxDouble(interval);
        return max != null ? Long.valueOf(max.longValue()) : null;
    }

    @Override
    protected Object getMin(Interval interval) {
        Double min = this.getMinDouble(interval);
        return min != null ? Long.valueOf(min.longValue()) : null;
    }

    @Override
    protected Long getValue(int index) {
        return this.values[index];
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (long[])array;
    }
}

