/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.TimestampMap;

public final class TimestampByteMap
extends TimestampMap<Byte> {
    private byte[] values;

    public TimestampByteMap() {
        this.values = new byte[0];
    }

    public TimestampByteMap(int capacity) {
        super(capacity);
        this.values = new byte[capacity];
    }

    public TimestampByteMap(double[] keys, byte[] vals) {
        super(keys);
        this.values = new byte[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public TimestampByteMap(TimestampByteMap source) {
        this(source.array, source.values);
    }

    public byte getByte(double timestamp) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public byte getByte(double timestamp, byte defaultValue) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    protected Object getAverage(Interval interval) {
        Double average = this.getAverageDouble(interval);
        return average != null ? average : null;
    }

    @Override
    protected Object getMax(Interval interval) {
        Double max = this.getMaxDouble(interval);
        return max != null ? Byte.valueOf(max.byteValue()) : null;
    }

    @Override
    protected Object getMin(Interval interval) {
        Double min = this.getMinDouble(interval);
        return min != null ? Byte.valueOf(min.byteValue()) : null;
    }

    @Override
    public Class<Byte> getTypeClass() {
        return Byte.class;
    }

    public byte[] toByteArray() {
        return (byte[])this.toPrimitiveArray();
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.MIN, Estimator.MAX, Estimator.FIRST, Estimator.LAST, Estimator.AVERAGE);
    }

    @Override
    protected Byte getValue(int index) {
        return this.values[index];
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (byte[])array;
    }
}

