/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import java.time.ZoneId;
import java.util.Arrays;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.TimeFormat;
import org.gephi.graph.api.types.TimeSet;

public final class TimestampSet
implements TimeSet<Double> {
    private double[] array;
    private int size = 0;

    public TimestampSet() {
        this.array = new double[0];
    }

    public TimestampSet(int capacity) {
        this.array = new double[capacity];
        Arrays.fill(this.array, Double.MAX_VALUE);
    }

    public TimestampSet(double[] arr) {
        this.array = new double[arr.length];
        System.arraycopy(arr, 0, this.array, 0, arr.length);
        this.size = arr.length;
    }

    public TimestampSet(TimestampSet source) {
        this(source.array);
    }

    @Override
    public boolean add(Double timestamp) {
        return this.addInner(timestamp) >= 0;
    }

    @Override
    public boolean remove(Double timestamp) {
        return this.removeInner(timestamp) >= 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public Double getMax() {
        if (this.size > 0) {
            return this.array[this.array.length - 1];
        }
        return null;
    }

    @Override
    public Double getMin() {
        if (this.size > 0) {
            return this.array[0];
        }
        return null;
    }

    @Override
    public Double getMaxDouble() {
        return this.getMax();
    }

    @Override
    public Double getMinDouble() {
        return this.getMin();
    }

    @Override
    public boolean contains(Double timestamp) {
        int index = Arrays.binarySearch(this.array, timestamp);
        return index >= 0 && index < this.size;
    }

    public Double[] toArray() {
        Double[] res = new Double[this.size];
        for (int i = 0; i < this.size; ++i) {
            res[i] = this.array[i];
        }
        return res;
    }

    public double[] toPrimitiveArray() {
        if (this.size < this.array.length) {
            double[] res = new double[this.size];
            System.arraycopy(this.array, 0, res, 0, this.size);
            return res;
        }
        return this.array;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.array = new double[0];
    }

    private int addInner(double timestamp) {
        int index = Arrays.binarySearch(this.array, 0, this.size, timestamp);
        if (index < 0) {
            int insertIndex = -index - 1;
            if (this.size < this.array.length - 1) {
                if (insertIndex < this.size) {
                    System.arraycopy(this.array, insertIndex, this.array, insertIndex + 1, this.size - insertIndex);
                }
                this.array[insertIndex] = timestamp;
            } else {
                double[] newArray = new double[this.array.length + 1];
                System.arraycopy(this.array, 0, newArray, 0, insertIndex);
                System.arraycopy(this.array, insertIndex, newArray, insertIndex + 1, this.array.length - insertIndex);
                newArray[insertIndex] = timestamp;
                this.array = newArray;
            }
            ++this.size;
            return insertIndex;
        }
        return -1;
    }

    private int removeInner(double timestamp) {
        int index = Arrays.binarySearch(this.array, 0, this.size, timestamp);
        if (index >= 0) {
            int removeIndex = index;
            if (removeIndex == this.size - 1) {
                --this.size;
            } else {
                System.arraycopy(this.array, removeIndex + 1, this.array, removeIndex, this.size - removeIndex - 1);
                --this.size;
            }
            return removeIndex;
        }
        return -1;
    }

    public int hashCode() {
        int hash = 7;
        hash = 37 * hash + this.size;
        for (int i = 0; i < this.size; ++i) {
            double t = this.array[i];
            hash = 37 * hash + (int)(Double.doubleToLongBits(t) ^ Double.doubleToLongBits(t) >>> 32);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimestampSet other = (TimestampSet)obj;
        if (this.size != other.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            double i1 = this.array[i];
            double i2 = other.array[i];
            if (i1 == i2) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString(TimeFormat timeFormat, ZoneId timeZone) {
        if (this.size == 0) {
            return "<empty>";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<[");
        for (int i = 0; i < this.size; ++i) {
            sb.append(AttributeUtils.printTimestampInFormat(this.array[i], timeFormat, timeZone));
            if (i >= this.size - 1) continue;
            sb.append(", ");
        }
        sb.append("]>");
        return sb.toString();
    }

    @Override
    public String toString(TimeFormat timeFormat) {
        return this.toString(timeFormat, null);
    }

    public String toString() {
        return this.toString(TimeFormat.DOUBLE, null);
    }
}

