/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.ArrayList;
import java.util.Map;
import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.GraphBridge;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.TextProperties;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ConfigurationImpl;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.EdgeTypeStore;
import org.gephi.graph.impl.ElementImpl;
import org.gephi.graph.impl.GraphFactoryImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.TableImpl;

public class GraphBridgeImpl
implements GraphBridge {
    private final GraphStore store;

    public GraphBridgeImpl(GraphStore store) {
        this.store = store;
    }

    @Override
    public void copyNodes(Node[] nodes) {
        if (nodes.length == 0) {
            return;
        }
        GraphStore sourceStore = null;
        IntOpenHashSet nodeIds = new IntOpenHashSet();
        for (Node node : nodes) {
            NodeImpl nodeImpl = this.verifyNode(node);
            sourceStore = nodeImpl.graphStore;
            nodeIds.add(nodeImpl.storeId);
        }
        this.verifyCompatibility(sourceStore);
        IntOpenHashSet edgeTypeIds = new IntOpenHashSet();
        ArrayList<EdgeImpl> edges = new ArrayList<EdgeImpl>();
        for (Node node : nodes) {
            for (Edge edge : sourceStore.getEdges(node)) {
                EdgeImpl edgeImpl;
                Node oppositeNode = sourceStore.getOpposite(node, edge);
                if (this.store.getNode(oppositeNode.getId()) == null && !nodeIds.contains(oppositeNode.getStoreId()) || !(edgeImpl = this.verifyEdge(edge)).isSelfLoop() && oppositeNode.getStoreId() <= node.getStoreId()) continue;
                edges.add(edgeImpl);
                if (edgeImpl.getType() == 0) continue;
                edgeTypeIds.add(edgeImpl.getType());
            }
        }
        EdgeTypeStore sourceEdgeTypeStore = sourceStore.edgeTypeStore;
        for (Integer edgeId : edgeTypeIds) {
            Object label = sourceEdgeTypeStore.getLabel(edgeId);
            this.store.edgeTypeStore.addType(label, edgeId);
        }
        TableImpl<Node> nodeTable = this.store.nodeTable;
        this.copyColumns(sourceStore.nodeTable, nodeTable);
        TableImpl<Edge> edgeTable = this.store.edgeTable;
        this.copyColumns(sourceStore.edgeTable, edgeTable);
        GraphFactoryImpl factory = this.store.factory;
        for (Node node : nodes) {
            if (this.store.getNode(node.getId()) != null) continue;
            Node nodeCopy = factory.newNode(node.getId());
            this.copyLabel(node, nodeCopy);
            this.copyTimeSet(node, nodeCopy);
            if (this.store.configuration.isEnableNodeProperties()) {
                this.copyNodeProperties(node, nodeCopy);
                this.copyTextProperties(node.getTextProperties(), nodeCopy.getTextProperties());
            }
            this.copyAttributes(sourceStore.nodeTable, nodeTable, node, nodeCopy);
            this.store.addNode(nodeCopy);
        }
        for (EdgeImpl edge : edges) {
            if (this.store.getEdge(edge.getId()) != null) continue;
            NodeImpl source = this.store.getNode(edge.getSource().getId());
            NodeImpl target = this.store.getNode(edge.getTarget().getId());
            Edge edgeCopy = factory.newEdge(edge.getId(), source, target, edge.getType(), 0.0, edge.isDirected());
            this.copyLabel(edge, edgeCopy);
            this.copyTimeSet(edge, edgeCopy);
            this.copyEdgeWeight(edge, edgeCopy);
            if (this.store.configuration.isEnableEdgeProperties()) {
                this.copyEdgeProperties(edge, edgeCopy);
                this.copyTextProperties(edge.getTextProperties(), edgeCopy.getTextProperties());
            }
            this.copyAttributes(sourceStore.edgeTable, edgeTable, edge, edgeCopy);
            this.store.addEdge(edgeCopy);
        }
    }

    private void copyEdgeWeight(EdgeImpl edge, Edge edgeCopy) {
        if (edge.hasDynamicWeight()) {
            TimeRepresentation tr = edge.graphStore.configuration.getTimeRepresentation();
            if (tr.equals((Object)TimeRepresentation.INTERVAL)) {
                for (Map.Entry entry : edge.getWeights()) {
                    edgeCopy.setWeight((double)((Double)entry.getValue()), (Interval)entry.getKey());
                }
            } else if (tr.equals((Object)TimeRepresentation.TIMESTAMP)) {
                for (Map.Entry entry : edge.getWeights()) {
                    edgeCopy.setWeight((double)((Double)entry.getValue()), (Double)entry.getKey());
                }
            }
        } else {
            edgeCopy.setWeight(edge.getWeight());
        }
    }

    private void copyNodeProperties(Node node, Node nodeCopy) {
        nodeCopy.setPosition(node.x(), node.y(), node.z());
        nodeCopy.setColor(node.getColor());
        nodeCopy.setFixed(node.isFixed());
        nodeCopy.setSize(node.size());
    }

    private void copyLabel(Element element, Element elementCopy) {
        elementCopy.setLabel(element.getLabel());
    }

    private void copyEdgeProperties(Edge edge, Edge edgeCopy) {
        edgeCopy.setColor(edge.getColor());
    }

    private void copyTextProperties(TextProperties text, TextProperties textCopy) {
        textCopy.setColor(text.getColor());
        textCopy.setSize(text.getSize());
        textCopy.setVisible(text.isVisible());
        textCopy.setText(text.getText());
        textCopy.setDimensions(text.getWidth(), text.getHeight());
    }

    private void copyTimeSet(Element element, Element elementCopy) {
        Column sourceColumn = element.getTable().getColumn(2);
        Column destColumn = elementCopy.getTable().getColumn(2);
        elementCopy.setAttribute(destColumn, AttributeUtils.copy(element.getAttribute(sourceColumn)));
    }

    private void copyColumns(TableImpl sourceTable, TableImpl destTable) {
        for (Column col : sourceTable.toArray()) {
            if (col.isProperty() || destTable.hasColumn(col.getId())) continue;
            destTable.addColumn(col.getId(), col.getTitle(), col.getTypeClass(), col.getOrigin(), col.getDefaultValue(), col.isIndexed());
        }
    }

    private void copyAttributes(TableImpl sourceTable, TableImpl destTable, Element element, Element elementCopy) {
        for (Column col : sourceTable.toArray()) {
            if (col.isProperty()) continue;
            ColumnImpl colCopy = destTable.getColumn(col.getId());
            elementCopy.setAttribute(colCopy, AttributeUtils.copy(element.getAttribute(col)));
        }
    }

    private NodeImpl verifyNode(Node node) {
        NodeImpl nodeImpl = (NodeImpl)node;
        this.verifyElement(nodeImpl);
        return nodeImpl;
    }

    private EdgeImpl verifyEdge(Edge edge) {
        EdgeImpl edgeImpl = (EdgeImpl)edge;
        this.verifyElement(edgeImpl);
        EdgeImpl existingEdge = this.store.getEdge(edge.getId());
        if (!(existingEdge == null || existingEdge.getSource().getId().equals(edge.getSource().getId()) && existingEdge.getTarget().getId().equals(edge.getTarget().getId()))) {
            throw new RuntimeException("An edge with a similar id '" + edge.getId() + "' already exists");
        }
        return edgeImpl;
    }

    private void verifyElement(ElementImpl elementImpl) {
        if (elementImpl.getStoreId() < 0) {
            throw new RuntimeException("The element '" + elementImpl.getId() + "' doesn't belong to any store");
        }
    }

    private void verifyCompatibility(GraphStore sourceStore) {
        ConfigurationImpl destConfig = this.store.configuration;
        ConfigurationImpl sourceConfig = sourceStore.configuration;
        if (!destConfig.getTimeRepresentation().equals((Object)sourceConfig.getTimeRepresentation())) {
            throw new RuntimeException("The time representations doesn't match, source: " + sourceConfig.getTimeRepresentation() + ", destination: " + destConfig.getTimeRepresentation());
        }
        if (!destConfig.getNodeIdType().equals(sourceConfig.getNodeIdType())) {
            throw new RuntimeException("The node id type doesn't match, source: " + sourceConfig.getNodeIdType() + ", destination: " + destConfig.getNodeIdType());
        }
        if (!destConfig.getEdgeIdType().equals(sourceConfig.getEdgeIdType())) {
            throw new RuntimeException("The edge id type doesn't match, source: " + sourceConfig.getEdgeIdType() + ", destination: " + destConfig.getEdgeIdType());
        }
        if (!destConfig.getEdgeWeightType().equals(sourceConfig.getEdgeWeightType())) {
            throw new RuntimeException("The edge weight type doesn't match, source: " + sourceConfig.getEdgeWeightType() + ", destination: " + destConfig.getEdgeWeightType());
        }
        if (!destConfig.getEdgeLabelType().equals(sourceConfig.getEdgeLabelType())) {
            throw new RuntimeException("The edge label type doesn't match, source: " + sourceConfig.getEdgeLabelType() + ", destination: " + destConfig.getEdgeLabelType());
        }
        if (destConfig.isEnableParallelEdgesSameType() != sourceConfig.isEnableParallelEdgesSameType()) {
            throw new RuntimeException("The parallel edges of same type configuration doesn't match, source: " + sourceConfig.isEnableParallelEdgesSameType() + ", destination: " + destConfig.isEnableParallelEdgesSameType());
        }
        TableImpl<Node> destNodeTable = this.store.nodeTable;
        for (Column sourceCol : sourceStore.nodeTable) {
            ColumnImpl destColumn;
            if (sourceCol.isProperty() || (destColumn = destNodeTable.getColumn(sourceCol.getId())) == null || destColumn.getTypeClass().equals(sourceCol.getTypeClass())) continue;
            throw new RuntimeException("A node column '" + destColumn.getId() + "' already exists with a different type");
        }
        TableImpl<Edge> destEdgeTable = this.store.edgeTable;
        for (Column sourceCol : sourceStore.edgeTable) {
            ColumnImpl destColumn;
            if (sourceCol.isProperty() || (destColumn = destEdgeTable.getColumn(sourceCol.getId())) == null || destColumn.getTypeClass().equals(sourceCol.getTypeClass())) continue;
            throw new RuntimeException("An edge column '" + destColumn.getId() + "' already exists with a different type");
        }
    }
}

