/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api;

import org.gephi.graph.api.AttributeUtils;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.api.types.IntervalDoubleMap;
import org.gephi.graph.api.types.TimestampDoubleMap;
import org.gephi.graph.impl.ConfigurationImpl;

public class Configuration {
    private ConfigurationImpl delegate;

    @Deprecated
    public Configuration() {
        this.delegate = new ConfigurationImpl();
    }

    protected Configuration(ConfigurationImpl delegate) {
        this.delegate = delegate;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Class getNodeIdType() {
        return this.delegate.getNodeIdType();
    }

    @Deprecated
    public void setNodeIdType(Class nodeIdType) {
        this.delegate = new Builder((ConfigurationImpl)this.delegate).nodeIdType((Class)nodeIdType).configuration;
    }

    public Class getEdgeIdType() {
        return this.delegate.getEdgeIdType();
    }

    @Deprecated
    public void setEdgeIdType(Class edgeIdType) {
        this.delegate = new Builder((ConfigurationImpl)this.delegate).edgeIdType((Class)edgeIdType).configuration;
    }

    public Class getEdgeLabelType() {
        return this.delegate.getEdgeLabelType();
    }

    @Deprecated
    public void setEdgeLabelType(Class edgeLabelType) {
        this.delegate = new Builder((ConfigurationImpl)this.delegate).edgeLabelType((Class)edgeLabelType).configuration;
    }

    public Class getEdgeWeightType() {
        return this.delegate.getEdgeWeightType();
    }

    @Deprecated
    public void setEdgeWeightType(Class edgeWeightType) {
        this.delegate = new Builder((ConfigurationImpl)this.delegate).edgeWeightType((Class)edgeWeightType).configuration;
    }

    public TimeRepresentation getTimeRepresentation() {
        return this.delegate.getTimeRepresentation();
    }

    @Deprecated
    public void setTimeRepresentation(TimeRepresentation timeRepresentation) {
        this.delegate = new Builder((ConfigurationImpl)this.delegate).timeRepresentation((TimeRepresentation)timeRepresentation).configuration;
    }

    public Boolean getEdgeWeightColumn() {
        return this.delegate.isEdgeWeightColumn();
    }

    @Deprecated
    public void setEdgeWeightColumn(Boolean edgeWeightColumn) {
        this.delegate = new Builder((ConfigurationImpl)this.delegate).edgeWeightColumn((boolean)edgeWeightColumn.booleanValue()).configuration;
    }

    public boolean isEnableAutoLocking() {
        return this.delegate.isEnableAutoLocking();
    }

    public boolean isEnableAutoEdgeTypeRegistration() {
        return this.delegate.isEnableAutoEdgeTypeRegistration();
    }

    public boolean isEnableIndexNodes() {
        return this.delegate.isEnableIndexNodes();
    }

    public boolean isEnableIndexEdges() {
        return this.delegate.isEnableIndexEdges();
    }

    public boolean isEnableIndexTime() {
        return this.delegate.isEnableIndexTime();
    }

    public boolean isEnableObservers() {
        return this.delegate.isEnableObservers();
    }

    public boolean isEnableNodeProperties() {
        return this.delegate.isEnableNodeProperties();
    }

    public boolean isEnableEdgeProperties() {
        return this.delegate.isEnableEdgeProperties();
    }

    public boolean isEnableSpatialIndex() {
        return this.delegate.isEnableSpatialIndex();
    }

    public boolean isEnableParallelEdgesSameType() {
        return this.delegate.isEnableParallelEdgesSameType();
    }

    public Configuration copy() {
        return new Configuration(this.delegate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Configuration)) {
            return false;
        }
        Configuration that = (Configuration)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String diffAsString(Configuration other) {
        return this.delegate.diffAsString(other.delegate);
    }

    public static class Builder {
        private ConfigurationImpl configuration;

        private Builder() {
            this.configuration = new ConfigurationImpl();
        }

        private Builder(ConfigurationImpl configuration) {
            this.configuration = configuration;
        }

        public Configuration build() {
            if (!this.configuration.isEnableNodeProperties() && this.configuration.isEnableSpatialIndex()) {
                throw new IllegalStateException("Spatial index can't be enabled if node properties are disabled");
            }
            return new Configuration(this.configuration);
        }

        public Builder nodeIdType(final Class nodeIdType) {
            Builder.checkSimpleType(nodeIdType);
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public Class getNodeIdType() {
                    return nodeIdType;
                }
            });
            return this;
        }

        public Builder edgeIdType(final Class edgeIdType) {
            Builder.checkSimpleType(edgeIdType);
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public Class getEdgeIdType() {
                    return edgeIdType;
                }
            });
            return this;
        }

        public Builder edgeLabelType(final Class edgeLabelType) {
            Builder.checkSimpleType(edgeLabelType);
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public Class getEdgeLabelType() {
                    return edgeLabelType;
                }
            });
            return this;
        }

        public Builder edgeWeightType(final Class edgeWeightType) {
            if (!(Double.class.equals((Object)edgeWeightType) || TimestampDoubleMap.class.equals((Object)edgeWeightType) || IntervalDoubleMap.class.equals((Object)edgeWeightType))) {
                throw new IllegalArgumentException("Unsupported type " + edgeWeightType.getCanonicalName() + ", should be Double, IntervalDoubleMap or TimestampDoubleMap");
            }
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public Class getEdgeWeightType() {
                    return edgeWeightType;
                }
            });
            return this;
        }

        public Builder timeRepresentation(final TimeRepresentation timeRepresentation) {
            if (timeRepresentation == null) {
                throw new IllegalArgumentException("timeRepresentation cannot be null");
            }
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public TimeRepresentation getTimeRepresentation() {
                    return timeRepresentation;
                }
            });
            return this;
        }

        public Builder edgeWeightColumn(final boolean edgeWeightColumn) {
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public Boolean getEdgeWeightColumn() {
                    return edgeWeightColumn;
                }
            });
            return this;
        }

        public Builder enableObservers(final boolean enableObservers) {
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public boolean isEnableObservers() {
                    return enableObservers;
                }
            });
            return this;
        }

        public Builder enableAutoEdgeTypeRegistration(final boolean enableAutoEdgeTypeRegistration) {
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public boolean isEnableAutoEdgeTypeRegistration() {
                    return enableAutoEdgeTypeRegistration;
                }
            });
            return this;
        }

        public Builder enableNodeProperties(final boolean enableNodeProperties) {
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public boolean isEnableNodeProperties() {
                    return enableNodeProperties;
                }
            });
            return this;
        }

        public Builder enableEdgeProperties(final boolean enableEdgeProperties) {
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public boolean isEnableEdgeProperties() {
                    return enableEdgeProperties;
                }
            });
            return this;
        }

        public Builder enableSpatialIndex(final boolean enableSpatialIndex) {
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public boolean isEnableSpatialIndex() {
                    return enableSpatialIndex;
                }
            });
            return this;
        }

        public Builder enableIndexNodes(final boolean enableIndexNodes) {
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public boolean isEnableIndexNodes() {
                    return enableIndexNodes;
                }
            });
            return this;
        }

        public Builder enableIndexEdges(final boolean enableIndexEdges) {
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public boolean isEnableIndexEdges() {
                    return enableIndexEdges;
                }
            });
            return this;
        }

        public Builder enableIndexTime(final boolean enableIndexTime) {
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public boolean isEnableIndexTime() {
                    return enableIndexTime;
                }
            });
            return this;
        }

        public Builder enableParallelEdgesSameType(final boolean enableParallelEdgesSameType) {
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public boolean isEnableParallelEdgesSameType() {
                    return enableParallelEdgesSameType;
                }
            });
            return this;
        }

        public Builder enableAutoLocking(final boolean enableAutoLocking) {
            this.configuration = new ConfigurationImpl(new Configuration(this.configuration){

                @Override
                public boolean isEnableAutoLocking() {
                    return enableAutoLocking;
                }
            });
            return this;
        }

        private static void checkSimpleType(Class type) {
            if (!AttributeUtils.isSimpleType(type)) {
                throw new IllegalArgumentException("Unsupported type " + type.getCanonicalName());
            }
        }
    }
}

