/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.api.types;

import org.gephi.graph.api.Estimator;
import org.gephi.graph.api.types.TimestampMap;

public final class TimestampDoubleMap
extends TimestampMap<Double> {
    private double[] values;

    public TimestampDoubleMap() {
        this.values = new double[0];
    }

    public TimestampDoubleMap(int capacity) {
        super(capacity);
        this.values = new double[capacity];
    }

    public TimestampDoubleMap(double[] keys, double[] vals) {
        super(keys);
        this.values = new double[vals.length];
        System.arraycopy(vals, 0, this.values, 0, vals.length);
    }

    public TimestampDoubleMap(TimestampDoubleMap source) {
        this(source.array, source.values);
    }

    public double getDouble(double timestamp) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        throw new IllegalArgumentException("The element doesn't exist");
    }

    public double getDouble(double timestamp, double defaultValue) {
        int index = this.getIndex(timestamp);
        if (index >= 0) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public Class<Double> getTypeClass() {
        return Double.class;
    }

    public double[] toDoubleArray() {
        return (double[])this.toPrimitiveArray();
    }

    @Override
    public boolean isSupported(Estimator estimator) {
        return estimator.is(Estimator.MIN, Estimator.MAX, Estimator.FIRST, Estimator.LAST, Estimator.AVERAGE);
    }

    @Override
    protected Double getValue(int index) {
        return this.values[index];
    }

    @Override
    protected Object getValuesArray() {
        return this.values;
    }

    @Override
    protected void setValuesArray(Object array) {
        this.values = (double[])array;
    }
}

