/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.awt.Color;
import java.util.Map;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeProperties;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Table;
import org.gephi.graph.impl.ColumnImpl;
import org.gephi.graph.impl.ColumnStore;
import org.gephi.graph.impl.DefaultColumnsImpl;
import org.gephi.graph.impl.EdgeStore;
import org.gephi.graph.impl.ElementImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.GraphStoreConfiguration;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.TextPropertiesImpl;
import org.gephi.graph.impl.TimeIndexStore;

public class EdgeImpl
extends ElementImpl
implements Edge {
    protected static final byte DIRECTED_BYTE = 1;
    protected static final byte MUTUAL_BYTE = 2;
    protected final NodeImpl source;
    protected final NodeImpl target;
    protected int type;
    protected int storeId = -1;
    protected int nextOutEdge = -1;
    protected int nextInEdge = -1;
    protected int previousOutEdge = -1;
    protected int previousInEdge = -1;
    protected byte flags;
    protected final EdgePropertiesImpl properties;

    public EdgeImpl(Object id, GraphStore graphStore, NodeImpl source, NodeImpl target, int type, double weight, boolean directed) {
        super(id, graphStore);
        this.checkIdType(id);
        this.source = source;
        this.target = target;
        this.flags = (byte)(directed ? 1 : 0);
        this.type = type;
        EdgePropertiesImpl edgePropertiesImpl = this.properties = graphStore == null || graphStore.configuration.isEnableEdgeProperties() ? new EdgePropertiesImpl() : null;
        if (graphStore == null || graphStore.configuration.getEdgeWeightType().equals(Double.class)) {
            this.attributes.setAttribute(3, (Object)weight);
        }
    }

    public EdgeImpl(Object id, NodeImpl source, NodeImpl target, int type, double weight, boolean directed) {
        this(id, null, source, target, type, weight, directed);
    }

    @Override
    public NodeImpl getSource() {
        return this.source;
    }

    @Override
    public NodeImpl getTarget() {
        return this.target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getWeight() {
        EdgeImpl edgeImpl = this;
        synchronized (edgeImpl) {
            Object weightObject = this.attributes.getAttribute(3);
            if (weightObject instanceof Double) {
                return (Double)weightObject;
            }
            return this.getWeight(this.graphStore.getView());
        }
    }

    @Override
    public boolean hasDynamicWeight() {
        return !Double.class.equals((Object)this.graphStore.configuration.getEdgeWeightType());
    }

    @Override
    public void setWeight(double weight, double timestamp) {
        this.checkWeightDynamicType();
        this.setAttribute(this.graphStore.defaultColumns.edgeWeight(), (Object)weight, timestamp);
    }

    @Override
    public void setWeight(double weight, Interval interval) {
        this.checkWeightDynamicType();
        this.setAttribute(this.graphStore.defaultColumns.edgeWeight(), (Object)weight, interval);
    }

    @Override
    public double getWeight(double timestamp) {
        ColumnImpl column = this.getColumnStore().getColumnByIndex(3);
        this.checkStaticWeight(column);
        Double doubleVal = (Double)this.attributes.getAttribute(column, timestamp, null);
        return doubleVal != null ? doubleVal : GraphStoreConfiguration.DEFAULT_DYNAMIC_EDGE_WEIGHT_WHEN_MISSING;
    }

    @Override
    public double getWeight(Interval interval) {
        ColumnImpl column = this.getColumnStore().getColumnByIndex(3);
        this.checkStaticWeight(column);
        Double doubleVal = (Double)this.attributes.getAttribute(column, interval, this.getEstimator(column));
        return doubleVal != null ? doubleVal : GraphStoreConfiguration.DEFAULT_DYNAMIC_EDGE_WEIGHT_WHEN_MISSING;
    }

    @Override
    public double getWeight(GraphView view) {
        this.checkViewExist(view);
        ColumnImpl column = this.getColumnStore().getColumnByIndex(3);
        if (column.isDynamicAttribute()) {
            return this.getWeight(view.getTimeInterval());
        }
        return (Double)this.attributes.getAttribute(column);
    }

    @Override
    public Iterable<Map.Entry> getWeights() {
        ColumnImpl column = this.getColumnStore().getColumnByIndex(3);
        this.checkStaticWeight(column);
        return this.attributes.getAttributes(column);
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setType(int type) {
        this.graphStore.autoWriteLock();
        try {
            this.graphStore.edgeStore.setEdgeType(this, type);
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public Object getTypeLabel() {
        this.graphStore.autoReadLock();
        try {
            Object object = this.graphStore.edgeTypeStore.getLabel(this.type);
            return object;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    @Override
    public void setWeight(double weight) {
        this.checkWeightStaticType();
        ColumnImpl column = this.getColumnStore().getColumnByIndex(3);
        this.setAttribute(column, (Object)weight);
    }

    public int getNextOutEdge() {
        return this.nextOutEdge;
    }

    public int getNextInEdge() {
        return this.nextInEdge;
    }

    public int getPreviousOutEdge() {
        return this.previousOutEdge;
    }

    public int getPreviousInEdge() {
        return this.previousInEdge;
    }

    @Override
    public int getStoreId() {
        return this.storeId;
    }

    public void setStoreId(int id) {
        this.storeId = id;
    }

    public long getLongId() {
        return EdgeStore.getLongId(this.source, this.target, this.isDirected());
    }

    @Override
    public boolean isDirected() {
        return (this.flags & 1) == 1;
    }

    protected void setMutual(boolean mutual) {
        if (this.isDirected()) {
            this.flags = mutual ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
        }
    }

    protected boolean isMutual() {
        return (this.flags & 2) == 2;
    }

    @Override
    public boolean isSelfLoop() {
        return this.source == this.target;
    }

    @Override
    public Table getTable() {
        if (this.graphStore != null) {
            return this.graphStore.edgeTable;
        }
        return null;
    }

    @Override
    ColumnStore getColumnStore() {
        if (this.graphStore != null) {
            return this.graphStore.edgeTable.store;
        }
        return null;
    }

    @Override
    DefaultColumnsImpl.TableDefaultColumns getDefaultColumns() {
        if (this.graphStore != null) {
            return this.graphStore.defaultColumns.edgeDefaultColumns;
        }
        return null;
    }

    @Override
    TimeIndexStore getTimeIndexStore() {
        if (this.graphStore != null) {
            return this.graphStore.timeStore.edgeIndexStore;
        }
        return null;
    }

    @Override
    boolean isValid() {
        return this.storeId != -1;
    }

    @Override
    public float r() {
        return this.properties.r();
    }

    @Override
    public float g() {
        return this.properties.g();
    }

    @Override
    public float b() {
        return this.properties.b();
    }

    @Override
    public float alpha() {
        return this.properties.alpha();
    }

    @Override
    public TextPropertiesImpl getTextProperties() {
        return this.properties.getTextProperties();
    }

    protected void setEdgeProperties(EdgePropertiesImpl edgeProperties) {
        this.properties.rgba = edgeProperties.rgba;
        if (this.properties.textProperties != null) {
            this.properties.setTextProperties(edgeProperties.textProperties);
        }
    }

    @Override
    public int getRGBA() {
        return this.properties.rgba;
    }

    @Override
    public Color getColor() {
        return this.properties.getColor();
    }

    @Override
    public void setR(float r) {
        this.properties.setR(r);
    }

    @Override
    public void setG(float g) {
        this.properties.setG(g);
    }

    @Override
    public void setB(float b) {
        this.properties.setB(b);
    }

    @Override
    public void setAlpha(float a) {
        this.properties.setAlpha(a);
    }

    @Override
    public void setColor(Color color) {
        this.properties.setColor(color);
    }

    final void checkIdType(Object id) {
        if (this.graphStore != null && !id.getClass().equals(this.graphStore.configuration.getEdgeIdType())) {
            throw new IllegalArgumentException("The id class does not match with the expected type (" + this.graphStore.configuration.getEdgeIdType().getName() + ")");
        }
    }

    final void checkWeightStaticType() {
        if (this.graphStore != null && !Double.class.equals((Object)this.graphStore.configuration.getEdgeWeightType())) {
            throw new IllegalArgumentException("The weight class does not match with the expected type (" + this.graphStore.configuration.getEdgeWeightType().getName() + ")");
        }
    }

    final void checkWeightDynamicType() {
        if (this.graphStore != null && Double.class.equals((Object)this.graphStore.configuration.getEdgeWeightType())) {
            throw new IllegalArgumentException("The weight class does not match with the expected type (" + this.graphStore.configuration.getEdgeWeightType().getName() + ")");
        }
    }

    final void checkStaticWeight(Column column) {
        if (!column.isDynamicAttribute()) {
            throw new IllegalStateException("The weight is static, call getWeight() instead");
        }
    }

    protected static class EdgePropertiesImpl
    implements EdgeProperties {
        protected final TextPropertiesImpl textProperties = new TextPropertiesImpl();
        protected int rgba = -16777216;

        @Override
        public float r() {
            return (float)(this.rgba >> 16 & 0xFF) / 255.0f;
        }

        @Override
        public float g() {
            return (float)(this.rgba >> 8 & 0xFF) / 255.0f;
        }

        @Override
        public float b() {
            return (float)(this.rgba & 0xFF) / 255.0f;
        }

        @Override
        public float alpha() {
            return (float)(this.rgba >> 24 & 0xFF) / 255.0f;
        }

        @Override
        public int getRGBA() {
            return this.rgba;
        }

        @Override
        public TextPropertiesImpl getTextProperties() {
            return this.textProperties;
        }

        protected void setTextProperties(TextPropertiesImpl textProperties) {
            this.textProperties.rgba = textProperties.rgba;
            this.textProperties.size = textProperties.size;
            this.textProperties.text = textProperties.text;
            this.textProperties.visible = textProperties.visible;
        }

        @Override
        public Color getColor() {
            return new Color(this.rgba, true);
        }

        @Override
        public void setR(float r) {
            this.rgba = this.rgba & 0xFF00FFFF | (int)(r * 255.0f) << 16;
        }

        @Override
        public void setG(float g) {
            this.rgba = this.rgba & 0xFFFF00FF | (int)(g * 255.0f) << 8;
        }

        @Override
        public void setB(float b) {
            this.rgba = this.rgba & 0xFFFFFF00 | (int)(b * 255.0f);
        }

        @Override
        public void setAlpha(float a) {
            this.rgba = this.rgba & 0xFFFFFF | (int)(a * 255.0f) << 24;
        }

        @Override
        public void setColor(Color color) {
            this.rgba = color.getAlpha() << 24 | color.getRGB();
        }

        public int deepHashCode() {
            int hash = 3;
            hash = 29 * hash + this.rgba;
            hash = 29 * hash + (this.textProperties != null ? this.textProperties.deepHashCode() : 0);
            return hash;
        }

        public boolean deepEquals(EdgePropertiesImpl obj) {
            if (obj == null) {
                return false;
            }
            if (this.rgba != obj.rgba) {
                return false;
            }
            return this.textProperties == obj.textProperties || this.textProperties != null && this.textProperties.deepEquals(obj.textProperties);
        }
    }
}

