/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenCustomHashMap;
import it.unimi.dsi.fastutil.longs.LongHash;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Node;
import org.gephi.graph.impl.ConfigurationImpl;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.EdgeTypeStore;
import org.gephi.graph.impl.GraphLockImpl;
import org.gephi.graph.impl.GraphVersion;
import org.gephi.graph.impl.GraphViewStore;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.SpatialIndexImpl;

public class EdgeStore
implements Collection<Edge>,
EdgeIterable {
    protected static final int NULL_ID = -1;
    protected static final int NODE_BITS = 31;
    protected static final Iterator<Edge> EMPTY_EDGE_ITERATOR = Collections.emptyIterator();
    protected final GraphLockImpl lock;
    protected final GraphVersion version;
    protected final EdgeTypeStore edgeTypeStore;
    protected final GraphViewStore viewStore;
    protected final SpatialIndexImpl spatialIndex;
    protected final ConfigurationImpl configuration;
    protected int size;
    protected int garbageSize;
    protected int blocksCount;
    protected int currentBlockIndex;
    protected EdgeBlock[] blocks;
    protected EdgeBlock currentBlock;
    protected Object2IntOpenHashMap dictionary;
    protected Long2ObjectOpenCustomHashMap<int[]>[] longDictionary;
    protected int[] typeSize;
    protected int undirectedSize;
    protected int mutualEdgesSize;
    protected int[] mutualEdgesTypeSize;

    public EdgeStore() {
        this.initStore();
        this.lock = null;
        this.edgeTypeStore = null;
        this.viewStore = null;
        this.version = null;
        this.spatialIndex = null;
        this.configuration = new ConfigurationImpl();
    }

    public EdgeStore(EdgeTypeStore edgeTypeStore, SpatialIndexImpl spatialIndex, ConfigurationImpl configuration, GraphLockImpl lock, GraphViewStore viewStore, GraphVersion graphVersion) {
        this.initStore();
        this.lock = lock;
        this.edgeTypeStore = edgeTypeStore;
        this.viewStore = viewStore;
        this.version = graphVersion;
        this.spatialIndex = spatialIndex;
        this.configuration = configuration == null ? new ConfigurationImpl() : configuration;
    }

    protected static long getLongId(NodeImpl source, NodeImpl target, boolean directed) {
        if (directed) {
            long edgeId = (long)source.storeId << 31;
            return edgeId |= (long)target.storeId;
        }
        long edgeId = (long)(source.storeId > target.storeId ? source.storeId : target.storeId) << 31;
        return edgeId |= (long)(source.storeId > target.storeId ? target.storeId : source.storeId);
    }

    private void initStore() {
        this.size = 0;
        this.garbageSize = 0;
        this.blocksCount = 1;
        this.currentBlockIndex = 0;
        this.blocks = new EdgeBlock[10];
        this.blocks[0] = new EdgeBlock(0);
        this.currentBlock = this.blocks[this.currentBlockIndex];
        this.dictionary = new Object2IntOpenHashMap(8192);
        this.dictionary.defaultReturnValue(-1);
        this.longDictionary = new Long2ObjectOpenCustomHashMap[1];
        this.longDictionary[0] = new Long2ObjectOpenCustomHashMap(1000, 0.7f, (LongHash.Strategy)new DictionaryHashStrategy());
        this.mutualEdgesTypeSize = new int[1];
        this.typeSize = new int[1];
    }

    private void ensureCapacity(int capacity) {
        assert (capacity > 0);
        int blockCapacity = this.currentBlock.getCapacity();
        while (capacity > blockCapacity) {
            if (this.currentBlockIndex == this.blocksCount - 1) {
                int blocksNeeded = (int)Math.ceil((double)(capacity - blockCapacity) / 8192.0);
                for (int i = 0; i < blocksNeeded; ++i) {
                    EdgeBlock block;
                    if (this.blocksCount == this.blocks.length) {
                        EdgeBlock[] newBlocks = new EdgeBlock[this.blocksCount + 1];
                        System.arraycopy(this.blocks, 0, newBlocks, 0, this.blocks.length);
                        this.blocks = newBlocks;
                    }
                    if ((block = this.blocks[this.blocksCount]) == null) {
                        this.blocks[this.blocksCount] = block = new EdgeBlock(this.blocksCount);
                    }
                    if (blockCapacity == 0 && i == 0) {
                        this.currentBlockIndex = this.blocksCount;
                        this.currentBlock = block;
                    }
                    ++this.blocksCount;
                }
                break;
            }
            ++this.currentBlockIndex;
            this.currentBlock = this.blocks[this.currentBlockIndex];
            blockCapacity = this.currentBlock.getCapacity();
        }
    }

    private void trimDictionary() {
        this.dictionary.trim(Math.max(8192, this.size * 2));
    }

    private void ensureHeadOutCapacity(NodeImpl node, int type) {
        EdgeImpl[] out = node.headOut;
        int outLength = out.length;
        if (type >= outLength) {
            EdgeImpl[] newArray = new EdgeImpl[type + 1];
            System.arraycopy(out, 0, newArray, 0, outLength);
            node.headOut = newArray;
        }
    }

    private void ensureHeadInCapacity(NodeImpl node, int type) {
        EdgeImpl[] in = node.headIn;
        int inLength = in.length;
        if (type >= inLength) {
            EdgeImpl[] newArray = new EdgeImpl[type + 1];
            System.arraycopy(in, 0, newArray, 0, inLength);
            node.headIn = newArray;
        }
    }

    private void trimHeadOutCapacity(NodeImpl node, int length) {
        EdgeImpl[] out = node.headOut;
        int outLength = out.length;
        if (length < outLength) {
            EdgeImpl[] newArray = new EdgeImpl[length];
            System.arraycopy(out, 0, newArray, 0, length);
            node.headOut = newArray;
        }
    }

    private void trimHeadInCapacity(NodeImpl node, int length) {
        EdgeImpl[] in = node.headIn;
        int inLength = in.length;
        if (length < inLength) {
            EdgeImpl[] newArray = new EdgeImpl[length];
            System.arraycopy(in, 0, newArray, 0, length);
            node.headIn = newArray;
        }
    }

    private void ensureLongDictionaryCapacity(int type) {
        int length = this.longDictionary.length;
        if (type >= length) {
            Long2ObjectOpenCustomHashMap[] newArray = new Long2ObjectOpenCustomHashMap[type + 1];
            System.arraycopy(this.longDictionary, 0, newArray, 0, length);
            this.longDictionary = newArray;
            for (int i = length; i <= type; ++i) {
                Long2ObjectOpenCustomHashMap newMap;
                this.longDictionary[i] = newMap = new Long2ObjectOpenCustomHashMap(1000, 0.7f, (LongHash.Strategy)new DictionaryHashStrategy());
            }
            int[] newSizeArray = new int[type + 1];
            System.arraycopy(this.mutualEdgesTypeSize, 0, newSizeArray, 0, length);
            this.mutualEdgesTypeSize = newSizeArray;
            newSizeArray = new int[type + 1];
            System.arraycopy(this.typeSize, 0, newSizeArray, 0, length);
            this.typeSize = newSizeArray;
        }
    }

    private void insertOutEdge(EdgeImpl edge) {
        NodeImpl source = edge.source;
        int type = edge.type;
        this.ensureHeadOutCapacity(source, type);
        int edgeId = edge.getStoreId();
        EdgeImpl[] headOutArray = source.headOut;
        EdgeImpl headOutEdge = headOutArray[type];
        if (headOutEdge != null) {
            headOutEdge.previousOutEdge = edgeId;
            edge.nextOutEdge = headOutEdge.storeId;
        }
        headOutArray[type] = edge;
    }

    private void insertInEdge(EdgeImpl edge) {
        NodeImpl target = edge.target;
        int type = edge.type;
        this.ensureHeadInCapacity(target, type);
        int edgeId = edge.getStoreId();
        EdgeImpl[] headInArray = target.headIn;
        EdgeImpl headInEdge = headInArray[type];
        if (headInEdge != null) {
            headInEdge.previousInEdge = edgeId;
            edge.nextInEdge = headInEdge.storeId;
        }
        headInArray[type] = edge;
    }

    private void removeOutEdge(EdgeImpl edge) {
        int previousOutEdgeId = edge.previousOutEdge;
        int nextOutEdgeId = edge.nextOutEdge;
        int type = edge.type;
        EdgeImpl nextOutEdge = null;
        if (nextOutEdgeId != -1) {
            nextOutEdge = this.get(nextOutEdgeId);
            nextOutEdge.previousOutEdge = previousOutEdgeId;
        }
        if (previousOutEdgeId == -1) {
            NodeImpl source = edge.source;
            EdgeImpl[] headOutArray = source.headOut;
            headOutArray[type] = nextOutEdge;
            if (nextOutEdge == null && type > 0 && type == headOutArray.length - 1) {
                this.trimHeadOutCapacity(source, headOutArray.length - 1);
            }
        } else {
            EdgeImpl previousOutEdge = this.get(previousOutEdgeId);
            previousOutEdge.nextOutEdge = nextOutEdgeId;
        }
        edge.nextOutEdge = -1;
        edge.previousOutEdge = -1;
    }

    private void removeInEdge(EdgeImpl edge) {
        int previousInEdgeId = edge.previousInEdge;
        int nextInEdgeId = edge.nextInEdge;
        int type = edge.type;
        EdgeImpl nextInEdge = null;
        if (nextInEdgeId != -1) {
            nextInEdge = this.get(nextInEdgeId);
            nextInEdge.previousInEdge = previousInEdgeId;
        }
        if (previousInEdgeId == -1) {
            NodeImpl target = edge.target;
            EdgeImpl[] headInArray = target.headIn;
            headInArray[type] = nextInEdge;
            if (nextInEdge == null && type > 0 && type == headInArray.length - 1) {
                this.trimHeadInCapacity(target, headInArray.length - 1);
            }
        } else {
            EdgeImpl previousInEdge = this.get(previousInEdgeId);
            previousInEdge.nextInEdge = nextInEdgeId;
        }
        edge.nextInEdge = -1;
        edge.previousInEdge = -1;
    }

    @Override
    public void clear() {
        if (!this.isEmpty()) {
            this.incrementVersion();
        }
        EdgeStoreIterator itr = new EdgeStoreIterator();
        while (itr.hasNext()) {
            EdgeImpl edge = itr.next();
            edge.setStoreId(-1);
        }
        this.initStore();
    }

    @Override
    public int size() {
        return this.size;
    }

    public int undirectedSize() {
        return this.size - this.mutualEdgesSize;
    }

    public int size(int type) {
        if (type < this.longDictionary.length) {
            return this.typeSize[type];
        }
        return 0;
    }

    public int undirectedSize(int type) {
        if (type < this.longDictionary.length) {
            return this.typeSize[type] - this.mutualEdgesTypeSize[type];
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    public EdgeStoreIterator iterator() {
        return new EdgeStoreIterator();
    }

    public EdgeStoreIterator iteratorUndirected() {
        return new UndirectedEdgeStoreIterator();
    }

    public SelfLoopIterator iteratorSelfLoop() {
        return new SelfLoopIterator();
    }

    public EdgeTypeIterator iteratorType(int type, boolean undirected) {
        return new EdgeTypeIterator(type, undirected);
    }

    public EdgeOutIterator edgeOutIterator(Node node) {
        this.checkValidNodeObject(node);
        return new EdgeOutIterator((NodeImpl)node);
    }

    public EdgeInIterator edgeInIterator(Node node) {
        this.checkValidNodeObject(node);
        return new EdgeInIterator((NodeImpl)node);
    }

    public EdgeInOutIterator edgeIterator(Node node) {
        this.checkValidNodeObject(node);
        return new EdgeInOutIterator((NodeImpl)node);
    }

    public Iterator<Edge> edgeUndirectedIterator(Node node) {
        this.checkValidNodeObject(node);
        return this.undirectedIterator(new EdgeInOutIterator((NodeImpl)node));
    }

    public EdgeTypeOutIterator edgeOutIterator(Node node, int type) {
        this.checkValidNodeObject(node);
        return new EdgeTypeOutIterator((NodeImpl)node, type);
    }

    public Iterator<Edge> edgeUndirectedIterator(Node node, int type) {
        this.checkValidNodeObject(node);
        return this.undirectedIterator(new EdgeTypeInOutIterator((NodeImpl)node, type));
    }

    public EdgeTypeInIterator edgeInIterator(Node node, int type) {
        this.checkValidNodeObject(node);
        return new EdgeTypeInIterator((NodeImpl)node, type);
    }

    public EdgeTypeInOutIterator edgeIterator(Node node, int type) {
        this.checkValidNodeObject(node);
        return new EdgeTypeInOutIterator((NodeImpl)node, type);
    }

    public NeighborsIterator neighborOutIterator(Node node) {
        this.checkValidNodeObject(node);
        return new NeighborsIterator((NodeImpl)node, new EdgeOutIterator((NodeImpl)node));
    }

    public NeighborsIterator neighborOutIterator(Node node, int type) {
        this.checkValidNodeObject(node);
        return new NeighborsIterator((NodeImpl)node, new EdgeTypeOutIterator((NodeImpl)node, type));
    }

    public NeighborsIterator neighborInIterator(Node node) {
        this.checkValidNodeObject(node);
        return new NeighborsIterator((NodeImpl)node, new EdgeInIterator((NodeImpl)node));
    }

    public NeighborsIterator neighborInIterator(Node node, int type) {
        this.checkValidNodeObject(node);
        return new NeighborsIterator((NodeImpl)node, new EdgeTypeInIterator((NodeImpl)node, type));
    }

    public NeighborsIterator neighborIterator(Node node) {
        this.checkValidNodeObject(node);
        return new NeighborsUndirectedIterator((NodeImpl)node, new EdgeInOutIterator((NodeImpl)node));
    }

    public NeighborsIterator neighborIterator(Node node, int type) {
        this.checkValidNodeObject(node);
        return new NeighborsUndirectedIterator((NodeImpl)node, new EdgeTypeInOutIterator((NodeImpl)node, type));
    }

    public Iterator<Edge> edgesUndirectedIterator(Node node1, Node node2) {
        this.checkValidNodeObject(node1);
        this.checkValidNodeObject(node2);
        return this.undirectedIterator(this.getAll(node1, node2, true));
    }

    public Iterator<Edge> edgesUndirectedIterator(Node node1, Node node2, int type) {
        this.checkValidNodeObject(node1);
        this.checkValidNodeObject(node2);
        return this.undirectedIterator(this.getAll(node1, node2, type, true));
    }

    public EdgeImpl get(int id) {
        this.checkValidId(id);
        return this.blocks[id / 8192].get(id);
    }

    public EdgeImpl getForGetByStoreId(int id) {
        if (id < 0 || !this.isValidIndex(id)) {
            return null;
        }
        return this.blocks[id / 8192].get(id);
    }

    public EdgeImpl get(Object id) {
        this.checkNonNullObject(id);
        int index = this.dictionary.getInt(id);
        if (index != -1) {
            return this.get(index);
        }
        return null;
    }

    public EdgeImpl get(Node source, Node target, boolean undirectedDecorator) {
        return this.get(source, target, 0, undirectedDecorator);
    }

    public Iterator<Edge> getAll(Node source, Node target, boolean undirectedDecorator) {
        return this.getAll(source, target, 0, undirectedDecorator);
    }

    public EdgeImpl get(Node source, Node target, int type, boolean undirectedDecorator) {
        this.checkNonNullObject(source);
        this.checkNonNullObject(target);
        NodeImpl sourceImpl = (NodeImpl)source;
        NodeImpl targetImpl = (NodeImpl)target;
        if (type < this.longDictionary.length) {
            if (this.isUndirectedGraph()) {
                int[] index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(sourceImpl, targetImpl, false));
                if (index != null) {
                    return this.get(index[0]);
                }
            } else if (this.isMixedGraph()) {
                int[] index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(sourceImpl, targetImpl, true));
                if (index != null) {
                    return this.get(index[0]);
                }
                if (targetImpl.storeId > sourceImpl.storeId) {
                    EdgeImpl e;
                    index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(sourceImpl, targetImpl, false));
                    if (index != null && (!(e = this.get(index[0])).isDirected() || undirectedDecorator)) {
                        return e;
                    }
                } else if (undirectedDecorator && (index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(targetImpl, sourceImpl, true))) != null) {
                    return this.get(index[0]);
                }
            } else {
                int[] index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(sourceImpl, targetImpl, true));
                if (index != null) {
                    return this.get(index[0]);
                }
                if (undirectedDecorator && (index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(targetImpl, sourceImpl, true))) != null) {
                    return this.get(index[0]);
                }
            }
        }
        return null;
    }

    public Iterator<Edge> getAll(Node source, Node target, int type, boolean undirectedDecorator) {
        this.checkNonNullObject(source);
        this.checkNonNullObject(target);
        NodeImpl sourceImpl = (NodeImpl)source;
        NodeImpl targetImpl = (NodeImpl)target;
        if (type < this.longDictionary.length) {
            if (this.isUndirectedGraph()) {
                int[] index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(sourceImpl, targetImpl, false));
                if (index != null) {
                    return new EdgesIterator(index);
                }
            } else if (this.isMixedGraph() && !undirectedDecorator) {
                int[] index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(sourceImpl, targetImpl, true));
                if (index != null) {
                    return new EdgesIterator(index);
                }
                if (targetImpl.storeId > sourceImpl.storeId && (index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(sourceImpl, targetImpl, false))) != null) {
                    return new EdgesIteratorOnlyUndirected(index);
                }
            } else {
                int[] reverseIndex;
                int[] index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(sourceImpl, targetImpl, true));
                if (undirectedDecorator && (reverseIndex = (int[])this.longDictionary[type].get(EdgeStore.getLongId(targetImpl, sourceImpl, true))) != null) {
                    if (index != null) {
                        index = Arrays.copyOf(index, index.length + reverseIndex.length);
                        System.arraycopy(reverseIndex, 0, index, index.length - reverseIndex.length, reverseIndex.length);
                    } else {
                        index = reverseIndex;
                    }
                }
                if (index != null) {
                    return new EdgesIterator(index);
                }
            }
        }
        return EMPTY_EDGE_ITERATOR;
    }

    public EdgeImpl getMutualEdge(Edge e) {
        this.checkNonNullEdgeObject(e);
        EdgeImpl edge = (EdgeImpl)e;
        this.checkEdgeExists(edge);
        return this.getMutual(edge);
    }

    private EdgeImpl getMutual(EdgeImpl edge) {
        return this.get(edge.target, edge.source, edge.type, false);
    }

    public boolean setEdgeType(Edge e, int type) {
        this.checkNonNullEdgeObject(e);
        if (e.getType() == type) {
            return false;
        }
        int oldType = e.getType();
        EdgeImpl edge = (EdgeImpl)e;
        if (edge.storeId != -1) {
            this.ensureLongDictionaryCapacity(type);
            Long2ObjectOpenCustomHashMap<int[]> newDico = this.longDictionary[type];
            long longId = EdgeStore.getLongId(edge.source, edge.target, edge.isDirected());
            int[] newDicoValue = (int[])newDico.get(longId);
            if (newDicoValue != null && !this.configuration.isEnableParallelEdgesSameType()) {
                return false;
            }
            this.edgeTypeStore.registerEdgeType(type);
            boolean wasMutual = edge.isMutual();
            this.removeFromDico(edge, edge.storeId);
            int n = oldType;
            this.typeSize[n] = this.typeSize[n] - 1;
            this.removeOutEdge(edge);
            this.removeInEdge(edge);
            edge.type = type;
            this.insertOutEdge(edge);
            this.insertInEdge(edge);
            this.addToDico(newDico, newDicoValue, edge, longId);
            int n2 = type;
            this.typeSize[n2] = this.typeSize[n2] + 1;
            if (this.viewStore != null) {
                this.viewStore.setEdgeType(edge, oldType, wasMutual);
            }
            this.incrementVersion();
        } else {
            edge.type = type;
        }
        return true;
    }

    private void removeFromDico(EdgeImpl edge, int id) {
        int[] index;
        int type = edge.type;
        Long2ObjectOpenCustomHashMap<int[]> dico = this.longDictionary[type];
        NodeImpl source = edge.source;
        NodeImpl target = edge.target;
        boolean directed = edge.isDirected();
        long longId = EdgeStore.getLongId(source, target, directed);
        int[] dicoValue = (int[])dico.get(longId);
        if (dicoValue.length == 1) {
            dico.remove(longId);
        } else {
            int[] newDicoValue = new int[dicoValue.length - 1];
            int j = 0;
            for (int i = 0; i < dicoValue.length; ++i) {
                int v = dicoValue[i];
                if (v == id) continue;
                newDicoValue[j++] = v;
            }
            dico.put(longId, (Object)newDicoValue);
        }
        if (directed && !edge.isSelfLoop() && (index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(edge.target, edge.source, true))) != null) {
            for (int i = 0; i < index.length; ++i) {
                EdgeImpl mutual = this.get(index[i]);
                if (!mutual.isMutual()) continue;
                edge.setMutual(false);
                mutual.setMutual(false);
                --source.mutualDegree;
                --target.mutualDegree;
                --this.mutualEdgesSize;
                int n = type;
                this.mutualEdgesTypeSize[n] = this.mutualEdgesTypeSize[n] - 1;
                break;
            }
        }
    }

    private void addToDico(Long2ObjectOpenCustomHashMap<int[]> dico, int[] dicoValue, EdgeImpl edge, long longId) {
        int type;
        int[] index;
        if (dicoValue == null) {
            dicoValue = new int[]{edge.storeId};
        } else {
            dicoValue = Arrays.copyOf(dicoValue, dicoValue.length + 1);
            dicoValue[dicoValue.length - 1] = edge.storeId;
        }
        dico.put(longId, (Object)dicoValue);
        if (edge.isDirected() && !edge.isSelfLoop() && (index = (int[])this.longDictionary[type = edge.type].get(EdgeStore.getLongId(edge.target, edge.source, true))) != null) {
            for (int i = 0; i < index.length; ++i) {
                EdgeImpl mutual = this.get(index[i]);
                if (mutual.isMutual()) continue;
                mutual.setMutual(true);
                edge.setMutual(true);
                ++edge.source.mutualDegree;
                ++edge.target.mutualDegree;
                ++this.mutualEdgesSize;
                int n = type;
                this.mutualEdgesTypeSize[n] = this.mutualEdgesTypeSize[n] + 1;
                break;
            }
        }
    }

    @Override
    public boolean add(Edge e) {
        this.checkNonNullEdgeObject(e);
        EdgeImpl edge = (EdgeImpl)e;
        if (edge.storeId == -1) {
            this.checkIdDoesntExist(e.getId());
            this.checkSourceTargets(edge);
            this.checkUndirectedNotExist(edge);
            int type = edge.type;
            boolean directed = edge.isDirected();
            NodeImpl source = edge.source;
            NodeImpl target = edge.target;
            this.ensureLongDictionaryCapacity(type);
            Long2ObjectOpenCustomHashMap<int[]> dico = this.longDictionary[type];
            long longId = EdgeStore.getLongId(source, target, directed);
            int[] dicoValue = (int[])dico.get(longId);
            if (dicoValue != null && !this.configuration.isEnableParallelEdgesSameType()) {
                return false;
            }
            if (this.edgeTypeStore != null) {
                this.edgeTypeStore.registerEdgeType(type);
            }
            this.incrementVersion();
            if (this.garbageSize > 0) {
                for (int i = 0; i < this.blocksCount; ++i) {
                    EdgeBlock edgeBlock = this.blocks[i];
                    if (!edgeBlock.hasGarbage()) continue;
                    edgeBlock.set(edge);
                    --this.garbageSize;
                    this.dictionary.put(edge.getId(), edge.storeId);
                    break;
                }
            } else {
                this.ensureCapacity(1);
                this.currentBlock.add(edge);
                this.dictionary.put(edge.getId(), edge.storeId);
            }
            this.insertOutEdge(edge);
            this.insertInEdge(edge);
            ++source.outDegree;
            ++target.inDegree;
            this.addToDico(dico, dicoValue, edge, longId);
            if (this.viewStore != null) {
                this.viewStore.addEdge(edge);
            }
            edge.indexAttributes();
            if (!directed) {
                ++this.undirectedSize;
            }
            ++this.size;
            int n = type;
            this.typeSize[n] = this.typeSize[n] + 1;
            return true;
        }
        if (this.isValidIndex(edge.storeId) && this.get(edge.storeId) == edge) {
            return false;
        }
        throw new IllegalArgumentException("The edge already belongs to another store");
    }

    @Override
    public boolean remove(Object o) {
        this.checkNonNullEdgeObject(o);
        EdgeImpl edge = (EdgeImpl)o;
        int id = edge.storeId;
        if (id != -1) {
            this.checkEdgeExists(edge);
            this.incrementVersion();
            if (this.viewStore != null) {
                this.viewStore.removeEdge(edge);
            }
            edge.destroyAttributes();
            int storeIndex = id / 8192;
            EdgeBlock block = this.blocks[storeIndex];
            block.remove(edge);
            this.removeOutEdge(edge);
            this.removeInEdge(edge);
            boolean directed = edge.isDirected();
            NodeImpl source = edge.source;
            NodeImpl target = edge.target;
            --source.outDegree;
            --target.inDegree;
            --this.size;
            int n = edge.type;
            this.typeSize[n] = this.typeSize[n] - 1;
            ++this.garbageSize;
            this.dictionary.remove(edge.getId());
            this.trimDictionary();
            int i = storeIndex;
            while (i == this.blocksCount - 1 && block.garbageLength == block.nodeLength && i >= 0) {
                if (i != 0) {
                    this.blocks[i] = null;
                    --this.blocksCount;
                    this.garbageSize -= block.nodeLength;
                    this.currentBlock = block = this.blocks[--i];
                    --this.currentBlockIndex;
                    continue;
                }
                this.currentBlock.clear();
                this.garbageSize = 0;
                break;
            }
            this.removeFromDico(edge, id);
            if (!directed) {
                --this.undirectedSize;
            }
            if (this.edgeTypeStore != null) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        this.checkNonNullEdgeObject(o);
        EdgeImpl edge = (EdgeImpl)o;
        int id = edge.getStoreId();
        return id != -1 && this.get(id) == edge;
    }

    public boolean containsId(Object id) {
        return this.dictionary.containsKey(id);
    }

    public boolean containsAnyType(NodeImpl source, NodeImpl target) {
        int typeLength = this.longDictionary.length;
        for (int i = 0; i < typeLength; ++i) {
            if (!this.contains(source, target, i)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(NodeImpl source, NodeImpl target, int type) {
        this.checkNonNullObject(source);
        this.checkNonNullObject(target);
        if (type < this.longDictionary.length) {
            if (this.isUndirectedGraph()) {
                return this.longDictionary[type].containsKey(EdgeStore.getLongId(source, target, false));
            }
            if (this.isMixedGraph()) {
                int[] index;
                if (this.longDictionary[type].containsKey(EdgeStore.getLongId(source, target, true))) {
                    return true;
                }
                if (target.storeId > source.storeId && (index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(source, target, false))) != null) {
                    for (int i = 0; i < index.length; ++i) {
                        EdgeImpl mutual = this.get(index[i]);
                        if (mutual.isDirected()) continue;
                        return true;
                    }
                }
            } else {
                return this.longDictionary[type].containsKey(EdgeStore.getLongId(source, target, true));
            }
        }
        return false;
    }

    public EdgeImpl[] toArray() {
        this.readLock();
        EdgeImpl[] array = new EdgeImpl[this.size];
        if (this.garbageSize == 0) {
            for (int i = 0; i < this.blocksCount; ++i) {
                EdgeBlock block = this.blocks[i];
                System.arraycopy(block.backingArray, 0, array, block.offset, block.nodeLength);
            }
        } else {
            EdgeStoreIterator itr = this.iterator();
            int offset = 0;
            while (itr.hasNext()) {
                EdgeImpl n = itr.next();
                array[offset++] = n;
            }
        }
        this.readUnlock();
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        this.checkNonNullObject(array);
        this.readLock();
        if (array.length < this.size()) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), this.size());
        }
        if (this.garbageSize == 0) {
            for (int i = 0; i < this.blocksCount; ++i) {
                EdgeBlock block = this.blocks[i];
                System.arraycopy(block.backingArray, 0, array, block.offset, block.nodeLength);
            }
        } else {
            EdgeStoreIterator itr = this.iterator();
            int offset = 0;
            while (itr.hasNext()) {
                EdgeImpl n = itr.next();
                array[offset++] = n;
            }
        }
        this.readUnlock();
        return array;
    }

    @Override
    public Collection<Edge> toCollection() {
        this.readLock();
        ArrayList<Edge> list = new ArrayList<Edge>(this.size);
        for (EdgeImpl n : this) {
            list.add(n);
        }
        this.readUnlock();
        return list;
    }

    @Override
    public Set<Edge> toSet() {
        this.readLock();
        HashSet<Edge> set = new HashSet<Edge>(this.size);
        for (EdgeImpl n : this) {
            set.add(n);
        }
        this.readUnlock();
        return set;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        this.checkCollection(c);
        if (!c.isEmpty()) {
            int found = 0;
            for (Object o : c) {
                if (!this.contains((EdgeImpl)o)) continue;
                ++found;
            }
            return found == c.size();
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends Edge> c) {
        this.checkCollection(c);
        if (!c.isEmpty()) {
            int capacityNeeded = c.size() - this.garbageSize;
            if (capacityNeeded > 0) {
                this.ensureCapacity(capacityNeeded);
            }
            boolean changed = false;
            for (Edge edge : c) {
                if (!this.add(edge)) continue;
                changed = true;
            }
            return changed;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        this.checkCollection(c);
        if (!c.isEmpty()) {
            boolean changed = false;
            for (Object o : c) {
                if (!this.remove(o)) continue;
                changed = true;
            }
            return changed;
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        this.checkCollection(c);
        if (!c.isEmpty()) {
            ObjectOpenHashSet set = new ObjectOpenHashSet(c.size());
            for (Object o : c) {
                this.checkNonNullObject(o);
                this.checkEdgeExists((EdgeImpl)o);
                set.add((Object)((EdgeImpl)o));
            }
            boolean changed = false;
            EdgeStoreIterator itr = this.iterator();
            while (itr.hasNext()) {
                EdgeImpl e = itr.next();
                if (set.contains((Object)e)) continue;
                itr.remove();
                changed = true;
            }
            return changed;
        }
        if (this.size > 0) {
            this.clear();
            return true;
        }
        return false;
    }

    public int deepHashCode() {
        int hash = 7;
        hash = 67 * hash + this.size;
        EdgeStoreIterator itr = this.iterator();
        while (itr.hasNext()) {
            hash = 67 * hash + itr.next().hashCode();
        }
        return hash;
    }

    public boolean deepEquals(EdgeStore obj) {
        if (obj == null || this.size != obj.size) {
            return false;
        }
        EdgeStoreIterator itr1 = this.iterator();
        EdgeStoreIterator itr2 = obj.iterator();
        while (itr1.hasNext()) {
            if (!itr2.hasNext()) {
                return false;
            }
            if (itr1.next().equals(itr2.next())) continue;
            return false;
        }
        return true;
    }

    public boolean isAdjacent(Node node1, Node node2, int type) {
        this.checkValidNodeObject(node1);
        this.checkValidNodeObject(node2);
        return this.contains((NodeImpl)node1, (NodeImpl)node2, type);
    }

    public boolean isAdjacent(Node node1, Node node2) {
        this.checkValidNodeObject(node1);
        this.checkValidNodeObject(node2);
        int typeLength = this.longDictionary.length;
        for (int i = 0; i < typeLength; ++i) {
            if (!this.contains((NodeImpl)node1, (NodeImpl)node2, i)) continue;
            return true;
        }
        return false;
    }

    public boolean isIncident(EdgeImpl edge1, EdgeImpl edge2) {
        return edge1.source == edge2.source || edge1.target == edge2.target || edge1.source == edge2.target || edge1.target == edge2.source;
    }

    public boolean isIncident(NodeImpl node, EdgeImpl edge) {
        return edge.source == node || edge.target == node;
    }

    protected Iterator<Edge> undirectedIterator(Iterator<Edge> edgeIterator) {
        return new UndirectedIterator(edgeIterator);
    }

    @Override
    public void doBreak() {
        this.readUnlock();
    }

    void checkUndirectedNotExist(EdgeImpl edge) {
        int type = edge.type;
        if (type < this.longDictionary.length) {
            if (edge.isDirected() && !this.isDirectedGraph()) {
                int[] index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(edge.source, edge.target, false));
                if (index != null && !this.get(index[0]).isDirected()) {
                    throw new IllegalArgumentException("An undirected edge already exists");
                }
            } else if (!edge.isDirected() && !this.isUndirectedGraph()) {
                int[] index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(edge.source, edge.target, true));
                if (index != null && this.get(index[0]).isDirected()) {
                    throw new IllegalArgumentException("An directed edge already exists");
                }
                index = (int[])this.longDictionary[type].get(EdgeStore.getLongId(edge.target, edge.source, true));
                if (index != null && this.get(index[0]).isDirected()) {
                    throw new IllegalArgumentException("An directed edge already exists");
                }
            }
        }
    }

    void checkIdDoesntExist(Object id) {
        if (this.dictionary.containsKey(id)) {
            throw new IllegalArgumentException("The edge id already exist");
        }
    }

    boolean isMixedGraph() {
        return this.undirectedSize > 0 && this.undirectedSize != this.size;
    }

    boolean isUndirectedGraph() {
        return this.size > 0 && this.undirectedSize == this.size;
    }

    boolean isDirectedGraph() {
        return this.undirectedSize == 0;
    }

    protected boolean isValidIndex(int id) {
        return id >= 0 && id < this.currentBlock.offset + this.currentBlock.nodeLength;
    }

    void checkCollection(Collection<?> collection) {
        if (collection == this) {
            throw new IllegalArgumentException("Can't pass itself");
        }
    }

    void checkNonNullObject(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    void checkValidNodeObject(Node n) {
        if (n == null) {
            throw new NullPointerException();
        }
        if (!(n instanceof NodeImpl)) {
            throw new ClassCastException("Object must be a NodeImpl object");
        }
        if (((NodeImpl)n).storeId == -1) {
            throw new IllegalArgumentException("Node should belong to a store");
        }
    }

    void checkNonNullEdgeObject(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (!(o instanceof EdgeImpl)) {
            throw new ClassCastException("Object must be a EdgeImpl object");
        }
    }

    void checkSourceTargets(EdgeImpl e) {
        if (e.source == null || e.target == null) {
            throw new NullPointerException();
        }
        if (e.source.storeId == -1 || e.target.storeId == -1) {
            throw new RuntimeException("Source and target nodes should be valid and belong to a store");
        }
    }

    void checkEdgeExists(EdgeImpl edge) {
        if (this.get(edge.storeId) != edge) {
            throw new IllegalArgumentException("The edge is invalid");
        }
    }

    void checkValidId(int id) {
        if (id < 0 || !this.isValidIndex(id)) {
            throw new IllegalArgumentException("Edge id=" + id + " is invalid");
        }
    }

    void readLock() {
        if (this.lock != null) {
            this.lock.readLock();
        }
    }

    void readUnlock() {
        if (this.lock != null) {
            this.lock.readUnlock();
        }
    }

    void checkWriteLock() {
        if (this.lock != null) {
            this.lock.checkHoldWriteLock();
        }
    }

    private void incrementVersion() {
        if (this.version != null) {
            this.version.incrementAndGetEdgeVersion();
        }
    }

    boolean isUndirectedToIgnore(EdgeImpl edge) {
        return edge.isMutual() && edge.source.storeId < edge.target.storeId;
    }

    int maxStoreId() {
        return this.currentBlock.offset + this.currentBlock.nodeLength;
    }

    protected final class UndirectedIterator
    implements Iterator<Edge> {
        protected final Iterator<Edge> itr;
        protected EdgeImpl pointer;

        public UndirectedIterator(Iterator<Edge> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            this.pointer = null;
            while (this.pointer == null || EdgeStore.this.isUndirectedToIgnore(this.pointer)) {
                if (!this.itr.hasNext()) {
                    return false;
                }
                this.pointer = (EdgeImpl)this.itr.next();
            }
            return true;
        }

        @Override
        public EdgeImpl next() {
            return this.pointer;
        }

        @Override
        public void remove() {
            if (this.pointer.isMutual()) {
                throw new UnsupportedOperationException("Removing directed edges from undirected iterator is not supported");
            }
            EdgeStore.this.remove(this.pointer);
        }
    }

    protected final class NeighborsUndirectedIterator
    extends NeighborsIterator {
        protected EdgeImpl pointer;

        public NeighborsUndirectedIterator(NodeImpl node, Iterator<Edge> itr) {
            super(node, itr);
        }

        @Override
        public boolean hasNext() {
            this.pointer = null;
            while (this.pointer == null || EdgeStore.this.isUndirectedToIgnore(this.pointer)) {
                if (!this.itr.hasNext()) {
                    return false;
                }
                this.pointer = (EdgeImpl)this.itr.next();
            }
            return true;
        }

        @Override
        public Node next() {
            return this.pointer.getSource() == this.node ? this.pointer.getTarget() : this.pointer.getSource();
        }
    }

    protected class NeighborsIterator
    implements Iterator<Node> {
        protected final NodeImpl node;
        protected final Iterator<Edge> itr;

        public NeighborsIterator(NodeImpl node, Iterator<Edge> itr) {
            this.node = node;
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Node next() {
            Edge e = this.itr.next();
            return e.getSource() == this.node ? e.getTarget() : e.getSource();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported for this iterator");
        }
    }

    protected final class EdgeTypeInIterator
    implements Iterator<Edge> {
        protected final int type;
        protected EdgeImpl lastEdge;
        protected EdgeImpl pointer;

        public EdgeTypeInIterator(NodeImpl node, int type) {
            this.type = type;
            EdgeStore.this.readLock();
            EdgeImpl[] inArray = node.headIn;
            this.pointer = type < inArray.length ? inArray[type] : null;
        }

        @Override
        public boolean hasNext() {
            if (this.pointer == null) {
                EdgeStore.this.readUnlock();
                return false;
            }
            return true;
        }

        @Override
        public EdgeImpl next() {
            this.lastEdge = this.pointer;
            int id = this.lastEdge.nextInEdge;
            this.pointer = id != -1 ? EdgeStore.this.get(id) : null;
            return this.lastEdge;
        }

        public void reset(NodeImpl node) {
            EdgeImpl[] inArray = node.headIn;
            this.pointer = this.type < inArray.length ? inArray[this.type] : null;
        }

        @Override
        public void remove() {
            EdgeStore.this.checkWriteLock();
            EdgeStore.this.remove(this.lastEdge);
        }
    }

    protected final class EdgesIteratorOnlyUndirected
    extends EdgesIterator {
        protected EdgeImpl pointer;

        public EdgesIteratorOnlyUndirected(int[] indices) {
            super(indices);
        }

        @Override
        public boolean hasNext() {
            this.pointer = null;
            while (this.index < this.indices.length && this.pointer == null) {
                this.pointer = EdgeStore.this.get(this.indices[this.index++]);
                if (!this.pointer.isDirected()) continue;
                this.pointer = null;
            }
            if (this.pointer == null) {
                EdgeStore.this.readUnlock();
                return false;
            }
            return true;
        }

        @Override
        public Edge next() {
            return this.pointer;
        }

        @Override
        public void remove() {
            EdgeStore.this.checkWriteLock();
            EdgeStore.this.remove(this.pointer);
        }
    }

    protected class EdgesIterator
    implements Iterator<Edge> {
        protected final int[] indices;
        protected int index;

        public EdgesIterator(int[] indices) {
            this.indices = indices;
            EdgeStore.this.readLock();
        }

        @Override
        public boolean hasNext() {
            boolean res;
            boolean bl = res = this.index < this.indices.length;
            if (!res) {
                EdgeStore.this.readUnlock();
            }
            return res;
        }

        @Override
        public Edge next() {
            return EdgeStore.this.get(this.indices[this.index++]);
        }

        @Override
        public void remove() {
            EdgeStore.this.checkWriteLock();
            EdgeStore.this.remove(EdgeStore.this.get(this.indices[this.index - 1]));
        }
    }

    protected final class EdgeTypeOutIterator
    implements Iterator<Edge> {
        protected final int type;
        protected EdgeImpl lastEdge;
        protected EdgeImpl pointer;

        public EdgeTypeOutIterator(NodeImpl node, int type) {
            this.type = type;
            EdgeStore.this.readLock();
            EdgeImpl[] outArray = node.headOut;
            this.pointer = type < outArray.length ? outArray[type] : null;
        }

        @Override
        public boolean hasNext() {
            if (this.pointer == null) {
                EdgeStore.this.readUnlock();
                return false;
            }
            return true;
        }

        @Override
        public EdgeImpl next() {
            this.lastEdge = this.pointer;
            int id = this.lastEdge.nextOutEdge;
            this.pointer = id != -1 ? EdgeStore.this.get(id) : null;
            return this.lastEdge;
        }

        public void reset(NodeImpl node) {
            EdgeImpl[] outArray = node.headOut;
            this.pointer = this.type < outArray.length ? outArray[this.type] : null;
        }

        @Override
        public void remove() {
            EdgeStore.this.checkWriteLock();
            EdgeStore.this.remove(this.lastEdge);
        }
    }

    protected final class EdgeTypeInOutIterator
    implements Iterator<Edge> {
        protected final int type;
        protected EdgeImpl lastEdge;
        protected EdgeImpl outPointer;
        protected EdgeImpl inPointer;
        protected boolean out = true;

        public EdgeTypeInOutIterator(NodeImpl node, int type) {
            this.type = type;
            EdgeStore.this.readLock();
            EdgeImpl[] outArray = node.headOut;
            EdgeImpl[] inArray = node.headIn;
            this.outPointer = type < outArray.length ? outArray[type] : null;
            this.inPointer = type < inArray.length ? inArray[type] : null;
        }

        @Override
        public boolean hasNext() {
            if (this.outPointer == null) {
                if (this.out) {
                    this.out = false;
                    while (this.inPointer != null && this.inPointer.isSelfLoop()) {
                        int id = this.inPointer.nextInEdge;
                        if (id != -1) {
                            this.inPointer = EdgeStore.this.get(id);
                            continue;
                        }
                        this.inPointer = null;
                    }
                }
                if (this.inPointer == null) {
                    EdgeStore.this.readUnlock();
                    return false;
                }
            }
            return true;
        }

        @Override
        public EdgeImpl next() {
            if (this.out) {
                this.lastEdge = this.outPointer;
                int id = this.lastEdge.nextOutEdge;
                this.outPointer = id != -1 ? EdgeStore.this.get(id) : null;
            } else {
                this.lastEdge = this.inPointer;
                int id = -1;
                while (id == -1) {
                    id = this.inPointer.nextInEdge;
                    if (id != -1) {
                        this.inPointer = EdgeStore.this.get(id);
                        if (!this.inPointer.isSelfLoop()) continue;
                        id = -1;
                        continue;
                    }
                    this.inPointer = null;
                    break;
                }
            }
            return this.lastEdge;
        }

        public void reset(NodeImpl node) {
            EdgeImpl[] outArray = node.headOut;
            EdgeImpl[] inArray = node.headIn;
            this.outPointer = this.type < outArray.length ? outArray[this.type] : null;
            this.inPointer = this.type < inArray.length ? inArray[this.type] : null;
        }

        @Override
        public void remove() {
            EdgeStore.this.checkWriteLock();
            EdgeStore.this.remove(this.lastEdge);
        }
    }

    protected final class EdgeInIterator
    implements Iterator<Edge> {
        protected final int typeLength;
        protected EdgeImpl[] inArray;
        protected int typeIndex = 0;
        protected EdgeImpl pointer;
        protected EdgeImpl lastEdge;

        public EdgeInIterator(NodeImpl node) {
            EdgeStore.this.readLock();
            this.inArray = node.headIn;
            this.typeLength = this.inArray.length;
        }

        @Override
        public boolean hasNext() {
            if (this.pointer == null) {
                while (this.pointer == null && this.typeIndex < this.typeLength) {
                    this.pointer = this.inArray[this.typeIndex++];
                }
                if (this.pointer == null) {
                    EdgeStore.this.readUnlock();
                    return false;
                }
            }
            return true;
        }

        @Override
        public EdgeImpl next() {
            this.lastEdge = this.pointer;
            int id = this.lastEdge.nextInEdge;
            this.pointer = id != -1 ? EdgeStore.this.get(id) : null;
            return this.lastEdge;
        }

        @Override
        public void remove() {
            EdgeStore.this.checkWriteLock();
            EdgeStore.this.remove(this.lastEdge);
        }
    }

    protected final class EdgeOutIterator
    implements Iterator<Edge> {
        protected final int typeLength;
        protected EdgeImpl[] outArray;
        protected int typeIndex = 0;
        protected EdgeImpl pointer;
        protected EdgeImpl lastEdge;

        public EdgeOutIterator(NodeImpl node) {
            EdgeStore.this.readLock();
            this.outArray = node.headOut;
            this.typeLength = this.outArray.length;
        }

        @Override
        public boolean hasNext() {
            if (this.pointer == null) {
                while (this.pointer == null && this.typeIndex < this.typeLength) {
                    this.pointer = this.outArray[this.typeIndex++];
                }
                if (this.pointer == null) {
                    EdgeStore.this.readUnlock();
                    return false;
                }
            }
            return true;
        }

        @Override
        public EdgeImpl next() {
            this.lastEdge = this.pointer;
            int id = this.lastEdge.nextOutEdge;
            this.pointer = id != -1 ? EdgeStore.this.get(id) : null;
            return this.lastEdge;
        }

        @Override
        public void remove() {
            EdgeStore.this.checkWriteLock();
            EdgeStore.this.remove(this.lastEdge);
        }
    }

    protected final class EdgeInOutIterator
    implements Iterator<Edge> {
        protected final int outTypeLength;
        protected final int inTypeLength;
        protected EdgeImpl[] outArray;
        protected EdgeImpl[] inArray;
        protected int typeIndex = 0;
        protected EdgeImpl pointer;
        protected EdgeImpl lastEdge;
        protected boolean out = true;

        public EdgeInOutIterator(NodeImpl node) {
            EdgeStore.this.readLock();
            this.outArray = node.headOut;
            this.outTypeLength = this.outArray.length;
            this.inArray = node.headIn;
            this.inTypeLength = this.inArray.length;
        }

        @Override
        public boolean hasNext() {
            if (this.pointer == null) {
                if (this.out) {
                    while (this.pointer == null && this.typeIndex < this.outTypeLength) {
                        this.pointer = this.outArray[this.typeIndex++];
                    }
                    if (this.pointer == null) {
                        this.out = false;
                        this.typeIndex = 0;
                    }
                }
                if (!this.out) {
                    while (this.pointer == null && this.typeIndex < this.inTypeLength) {
                        this.pointer = this.inArray[this.typeIndex++];
                        while (this.pointer != null && this.pointer.isSelfLoop()) {
                            int id = this.pointer.nextInEdge;
                            if (id != -1) {
                                this.pointer = EdgeStore.this.get(id);
                                continue;
                            }
                            this.pointer = null;
                        }
                    }
                }
                if (this.pointer == null) {
                    EdgeStore.this.readUnlock();
                    return false;
                }
            }
            return true;
        }

        @Override
        public EdgeImpl next() {
            this.lastEdge = this.pointer;
            if (this.out) {
                int id = this.lastEdge.nextOutEdge;
                this.pointer = id != -1 ? EdgeStore.this.get(id) : null;
            } else {
                int id = -1;
                while (id == -1) {
                    id = this.pointer.nextInEdge;
                    if (id != -1) {
                        this.pointer = EdgeStore.this.get(id);
                        if (!this.pointer.isSelfLoop()) continue;
                        id = -1;
                        continue;
                    }
                    this.pointer = null;
                    break;
                }
            }
            return this.lastEdge;
        }

        @Override
        public void remove() {
            EdgeStore.this.checkWriteLock();
            EdgeStore.this.remove(this.lastEdge);
        }
    }

    protected final class SelfLoopIterator
    extends EdgeStoreIterator {
        @Override
        public boolean hasNext() {
            this.pointer = null;
            while (this.pointer == null) {
                if (!super.hasNext()) {
                    return false;
                }
                if (this.pointer.isSelfLoop()) continue;
                this.pointer = null;
            }
            return true;
        }
    }

    protected final class EdgeTypeIterator
    extends EdgeStoreIterator {
        private final int type;
        private final boolean undirected;

        public EdgeTypeIterator(int type, boolean undirected) {
            this.type = type;
            this.undirected = undirected;
        }

        @Override
        public boolean hasNext() {
            this.pointer = null;
            while (this.pointer == null) {
                if (!super.hasNext()) {
                    return false;
                }
                if (this.pointer.getType() == this.type && (!this.undirected || !EdgeStore.this.isUndirectedToIgnore(this.pointer))) continue;
                this.pointer = null;
            }
            return true;
        }

        @Override
        public void remove() {
            EdgeStore.this.remove(this.pointer);
        }
    }

    protected final class UndirectedEdgeStoreIterator
    extends EdgeStoreIterator {
        @Override
        public boolean hasNext() {
            this.pointer = null;
            while (this.pointer == null) {
                if (!super.hasNext()) {
                    return false;
                }
                if (!EdgeStore.this.isUndirectedToIgnore(this.pointer)) continue;
                this.pointer = null;
            }
            return true;
        }

        @Override
        public void remove() {
            if (this.pointer.isMutual()) {
                throw new UnsupportedOperationException("Removing directed edges from undirected iterator is not supported");
            }
            EdgeStore.this.remove(this.pointer);
        }
    }

    protected class EdgeStoreIterator
    implements Iterator<Edge> {
        protected int blockIndex;
        protected EdgeImpl[] backingArray;
        protected int blockLength;
        protected int cursor;
        protected EdgeImpl pointer;

        public EdgeStoreIterator() {
            EdgeStore.this.readLock();
            this.backingArray = EdgeStore.this.blocks[this.blockIndex].backingArray;
            this.blockLength = EdgeStore.this.blocks[this.blockIndex].nodeLength;
        }

        @Override
        public boolean hasNext() {
            this.pointer = null;
            while (this.cursor == this.blockLength || (this.pointer = this.backingArray[this.cursor++]) == null) {
                if (this.cursor != this.blockLength) continue;
                if (++this.blockIndex >= EdgeStore.this.blocksCount) break;
                this.backingArray = EdgeStore.this.blocks[this.blockIndex].backingArray;
                this.blockLength = EdgeStore.this.blocks[this.blockIndex].nodeLength;
                this.cursor = 0;
            }
            if (this.pointer == null) {
                EdgeStore.this.readUnlock();
                return false;
            }
            return true;
        }

        @Override
        public EdgeImpl next() {
            return this.pointer;
        }

        @Override
        public void remove() {
            EdgeStore.this.checkWriteLock();
            EdgeStore.this.remove(this.pointer);
        }
    }

    private static class DictionaryHashStrategy
    implements LongHash.Strategy {
        private DictionaryHashStrategy() {
        }

        public int hashCode(long l) {
            return (int)(l ^ l >>> 32);
        }

        public boolean equals(long l1, long l2) {
            return l1 == l2;
        }
    }

    protected static class EdgeBlock {
        protected final int offset;
        protected final short[] garbageArray;
        protected final EdgeImpl[] backingArray;
        protected int nodeLength;
        protected int garbageLength;

        public EdgeBlock(int index) {
            this.offset = index * 8192;
            this.garbageArray = new short[8192];
            this.backingArray = new EdgeImpl[8192];
        }

        public boolean hasGarbage() {
            return this.garbageLength > 0;
        }

        public int getCapacity() {
            return 8192 - this.nodeLength - this.garbageLength;
        }

        public void add(EdgeImpl k) {
            int i = this.nodeLength++;
            this.backingArray[i] = k;
            k.setStoreId(i + this.offset);
        }

        public void set(EdgeImpl k) {
            int i = this.garbageArray[--this.garbageLength] - Short.MIN_VALUE;
            this.backingArray[i] = k;
            k.setStoreId(i + this.offset);
        }

        public EdgeImpl get(int id) {
            return this.backingArray[id - this.offset];
        }

        public void remove(EdgeImpl k) {
            int i = k.getStoreId() - this.offset;
            this.backingArray[i] = null;
            this.garbageArray[this.garbageLength++] = (short)(i + Short.MIN_VALUE);
            k.setStoreId(-1);
        }

        public void clear() {
            this.nodeLength = 0;
            this.garbageLength = 0;
        }
    }
}

