/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.gephi.graph.api.DirectedSubgraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Rect2D;
import org.gephi.graph.api.SpatialIndex;
import org.gephi.graph.api.Subgraph;
import org.gephi.graph.api.UndirectedSubgraph;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.EdgeIterableWrapper;
import org.gephi.graph.impl.EdgeStore;
import org.gephi.graph.impl.GraphLockImpl;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.GraphViewImpl;
import org.gephi.graph.impl.NodeImpl;
import org.gephi.graph.impl.NodeIterableWrapper;

public class GraphViewDecorator
implements DirectedSubgraph,
UndirectedSubgraph,
SpatialIndex {
    protected final boolean undirected;
    protected final GraphViewImpl view;
    protected final GraphStore graphStore;

    public GraphViewDecorator(GraphStore graphStore, GraphViewImpl view, boolean undirected) {
        this.graphStore = graphStore;
        this.view = view;
        this.undirected = undirected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Edge getEdge(Node node1, Node node2) {
        this.graphStore.autoReadLock();
        try {
            EdgeImpl edge = this.graphStore.edgeStore.get(node1, node2, this.undirected);
            if (edge != null && this.view.containsEdge(edge)) {
                EdgeImpl edgeImpl = edge;
                return edgeImpl;
            }
            Edge edge2 = null;
            return edge2;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    @Override
    public EdgeIterable getEdges(Node node1, Node node2) {
        return this.graphStore.getEdgeIterableWrapper(new EdgeViewIterator(this.graphStore.edgeStore.getAll(node1, node2, this.undirected)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Edge getEdge(Node node1, Node node2, int type) {
        this.graphStore.autoReadLock();
        try {
            EdgeImpl edge = this.graphStore.edgeStore.get(node1, node2, type, this.undirected);
            if (edge != null && this.view.containsEdge(edge)) {
                EdgeImpl edgeImpl = edge;
                return edgeImpl;
            }
            Edge edge2 = null;
            return edge2;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    @Override
    public EdgeIterable getEdges(Node node1, Node node2, int type) {
        return this.graphStore.getEdgeIterableWrapper(new EdgeViewIterator(this.graphStore.edgeStore.getAll(node1, node2, type, this.undirected)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Edge getMutualEdge(Edge e) {
        this.graphStore.autoReadLock();
        try {
            EdgeImpl edge = this.graphStore.edgeStore.getMutualEdge(e);
            if (edge != null && this.view.containsEdge(edge)) {
                EdgeImpl edgeImpl = edge;
                return edgeImpl;
            }
            Edge edge2 = null;
            return edge2;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    @Override
    public NodeIterable getPredecessors(Node node) {
        this.checkValidInViewNodeObject(node);
        return this.graphStore.getNodeIterableWrapper(new NeighborsIterator((NodeImpl)node, new EdgeViewIterator(this.graphStore.edgeStore.edgeInIterator(node))));
    }

    @Override
    public NodeIterable getPredecessors(Node node, int type) {
        this.checkValidInViewNodeObject(node);
        return this.graphStore.getNodeIterableWrapper(new NeighborsIterator((NodeImpl)node, new EdgeViewIterator(this.graphStore.edgeStore.edgeInIterator(node, type))));
    }

    @Override
    public NodeIterable getSuccessors(Node node) {
        this.checkValidInViewNodeObject(node);
        return this.graphStore.getNodeIterableWrapper(new NeighborsIterator((NodeImpl)node, new EdgeViewIterator(this.graphStore.edgeStore.edgeOutIterator(node))));
    }

    @Override
    public NodeIterable getSuccessors(Node node, int type) {
        this.checkValidInViewNodeObject(node);
        return this.graphStore.getNodeIterableWrapper(new NeighborsIterator((NodeImpl)node, new EdgeViewIterator(this.graphStore.edgeStore.edgeOutIterator(node, type))));
    }

    @Override
    public EdgeIterable getInEdges(Node node) {
        this.checkValidInViewNodeObject(node);
        return this.graphStore.getEdgeIterableWrapper(new EdgeViewIterator(this.graphStore.edgeStore.edgeInIterator(node)));
    }

    @Override
    public EdgeIterable getInEdges(Node node, int type) {
        this.checkValidInViewNodeObject(node);
        return this.graphStore.getEdgeIterableWrapper(new EdgeViewIterator(this.graphStore.edgeStore.edgeInIterator(node, type)));
    }

    @Override
    public EdgeIterable getOutEdges(Node node) {
        this.checkValidInViewNodeObject(node);
        return this.graphStore.getEdgeIterableWrapper(new EdgeViewIterator(this.graphStore.edgeStore.edgeOutIterator(node)));
    }

    @Override
    public EdgeIterable getOutEdges(Node node, int type) {
        this.checkValidInViewNodeObject(node);
        return this.graphStore.getEdgeIterableWrapper(new EdgeViewIterator(this.graphStore.edgeStore.edgeOutIterator(node, type)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdjacent(Node source, Node target) {
        this.checkValidInViewNodeObject(source);
        this.checkValidInViewNodeObject(target);
        this.graphStore.autoReadLock();
        try {
            EdgeImpl edge = this.graphStore.edgeStore.get(source, target, this.undirected);
            boolean bl = edge != null && this.view.containsEdge(edge);
            return bl;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAdjacent(Node source, Node target, int type) {
        this.checkValidInViewNodeObject(source);
        this.checkValidInViewNodeObject(target);
        this.graphStore.autoReadLock();
        try {
            EdgeImpl edge = this.graphStore.edgeStore.get(source, target, type, this.undirected);
            boolean bl = edge != null && this.view.containsEdge(edge);
            return bl;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    @Override
    public boolean addEdge(Edge edge) {
        this.checkValidEdgeObject(edge);
        this.graphStore.autoWriteLock();
        try {
            boolean bl = this.view.addEdge(edge);
            return bl;
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public boolean addNode(Node node) {
        this.checkValidNodeObject(node);
        this.graphStore.autoWriteLock();
        try {
            boolean bl = this.view.addNode(node);
            return bl;
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public boolean addAllEdges(Collection<? extends Edge> edges) {
        this.graphStore.autoWriteLock();
        try {
            boolean bl = this.view.addAllEdges(edges);
            return bl;
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public boolean addAllNodes(Collection<? extends Node> nodes) {
        this.graphStore.autoWriteLock();
        try {
            boolean bl = this.view.addAllNodes(nodes);
            return bl;
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public boolean removeEdge(Edge edge) {
        this.checkValidEdgeObject(edge);
        this.graphStore.autoWriteLock();
        try {
            boolean bl = this.view.removeEdge(edge);
            return bl;
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public boolean removeNode(Node node) {
        this.checkValidNodeObject(node);
        this.graphStore.autoWriteLock();
        try {
            boolean bl = this.view.removeNode(node);
            return bl;
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public boolean removeAllEdges(Collection<? extends Edge> edges) {
        this.graphStore.autoWriteLock();
        try {
            boolean bl = this.view.removeEdgeAll(edges);
            return bl;
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public boolean removeAllNodes(Collection<? extends Node> nodes) {
        this.graphStore.autoWriteLock();
        try {
            boolean bl = this.view.removeNodeAll(nodes);
            return bl;
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public boolean retainNodes(Collection<? extends Node> nodes) {
        this.graphStore.autoWriteLock();
        try {
            boolean bl = this.view.retainNodes(nodes);
            return bl;
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public boolean retainEdges(Collection<? extends Edge> edges) {
        this.graphStore.autoWriteLock();
        try {
            boolean bl = this.view.retainEdges(edges);
            return bl;
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public boolean contains(Node node) {
        this.checkValidNodeObject(node);
        this.graphStore.autoReadLock();
        try {
            boolean bl = this.view.containsNode((NodeImpl)node);
            return bl;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    @Override
    public boolean contains(Edge edge) {
        this.checkValidEdgeObject(edge);
        this.graphStore.autoReadLock();
        try {
            boolean bl = this.view.containsEdge((EdgeImpl)edge);
            return bl;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getNode(Object id) {
        this.graphStore.autoReadLock();
        try {
            NodeImpl node = this.graphStore.getNode(id);
            if (node != null && this.view.containsNode(node)) {
                NodeImpl nodeImpl = node;
                return nodeImpl;
            }
            Node node2 = null;
            return node2;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Node getNodeByStoreId(int id) {
        this.graphStore.autoReadLock();
        try {
            NodeImpl node = this.graphStore.getNodeByStoreId(id);
            if (node != null && this.view.containsNode(node)) {
                NodeImpl nodeImpl = node;
                return nodeImpl;
            }
            Node node2 = null;
            return node2;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    @Override
    public boolean hasNode(Object id) {
        return this.getNode(id) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Edge getEdge(Object id) {
        this.graphStore.autoReadLock();
        try {
            EdgeImpl edge = this.graphStore.getEdge(id);
            if (edge != null && this.view.containsEdge(edge)) {
                EdgeImpl edgeImpl = edge;
                return edgeImpl;
            }
            Edge edge2 = null;
            return edge2;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Edge getEdgeByStoreId(int id) {
        this.graphStore.autoReadLock();
        try {
            EdgeImpl edge = this.graphStore.getEdgeByStoreId(id);
            if (edge != null && this.view.containsEdge(edge)) {
                EdgeImpl edgeImpl = edge;
                return edgeImpl;
            }
            Edge edge2 = null;
            return edge2;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    @Override
    public boolean hasEdge(Object id) {
        return this.getEdge(id) != null;
    }

    @Override
    public NodeIterable getNodes() {
        return this.graphStore.getNodeIterableWrapper(new NodeViewIterator(this.graphStore.nodeStore.iterator()));
    }

    @Override
    public EdgeIterable getEdges() {
        if (this.undirected) {
            return this.graphStore.getEdgeIterableWrapper(new UndirectedEdgeViewIterator(this.graphStore.edgeStore.iterator()));
        }
        return this.graphStore.getEdgeIterableWrapper(new EdgeViewIterator(this.graphStore.edgeStore.iterator()));
    }

    @Override
    public EdgeIterable getEdges(int type) {
        return this.graphStore.getEdgeIterableWrapper(new UndirectedEdgeViewIterator(this.graphStore.edgeStore.iteratorType(type, this.undirected)));
    }

    @Override
    public EdgeIterable getSelfLoops() {
        return this.graphStore.getEdgeIterableWrapper(new EdgeViewIterator(this.graphStore.edgeStore.iteratorSelfLoop()));
    }

    @Override
    public NodeIterable getNeighbors(Node node) {
        this.checkValidInViewNodeObject(node);
        return this.graphStore.getNodeIterableWrapper(new NeighborsIterator((NodeImpl)node, new UndirectedEdgeViewIterator(this.graphStore.edgeStore.edgeIterator(node))));
    }

    @Override
    public NodeIterable getNeighbors(Node node, int type) {
        this.checkValidInViewNodeObject(node);
        return this.graphStore.getNodeIterableWrapper(new NeighborsIterator((NodeImpl)node, new UndirectedEdgeViewIterator(this.graphStore.edgeStore.edgeIterator(node, type))));
    }

    @Override
    public EdgeIterable getEdges(Node node) {
        this.checkValidInViewNodeObject(node);
        if (this.undirected) {
            return this.graphStore.getEdgeIterableWrapper(new UndirectedEdgeViewIterator(this.graphStore.edgeStore.edgeIterator(node)));
        }
        return this.graphStore.getEdgeIterableWrapper(new EdgeViewIterator(this.graphStore.edgeStore.edgeIterator(node)));
    }

    @Override
    public EdgeIterable getEdges(Node node, int type) {
        this.checkValidInViewNodeObject(node);
        if (this.undirected) {
            return this.graphStore.getEdgeIterableWrapper(new UndirectedEdgeViewIterator(this.graphStore.edgeStore.edgeIterator(node, type)));
        }
        return this.graphStore.getEdgeIterableWrapper(new EdgeViewIterator(this.graphStore.edgeStore.edgeIterator(node, type)));
    }

    @Override
    public int getNodeCount() {
        return this.view.getNodeCount();
    }

    @Override
    public int getEdgeCount() {
        if (this.undirected) {
            return this.view.getUndirectedEdgeCount();
        }
        return this.view.getEdgeCount();
    }

    @Override
    public int getEdgeCount(int type) {
        if (this.undirected) {
            return this.view.getUndirectedEdgeCount(type);
        }
        return this.view.getEdgeCount(type);
    }

    @Override
    public Node getOpposite(Node node, Edge edge) {
        this.checkValidInViewNodeObject(node);
        this.checkValidInViewEdgeObject(edge);
        return this.graphStore.getOpposite(node, edge);
    }

    @Override
    public int getDegree(Node node) {
        if (this.undirected) {
            int count = 0;
            EdgeStore.EdgeInOutIterator itr = this.graphStore.edgeStore.edgeIterator(node);
            while (itr.hasNext()) {
                EdgeImpl edge = itr.next();
                if (!this.view.containsEdge(edge) || this.isUndirectedToIgnore(edge)) continue;
                ++count;
                if (!edge.isSelfLoop()) continue;
                ++count;
            }
            return count;
        }
        int count = 0;
        EdgeStore.EdgeInOutIterator itr = this.graphStore.edgeStore.edgeIterator(node);
        while (itr.hasNext()) {
            EdgeImpl edge = itr.next();
            if (!this.view.containsEdge(edge)) continue;
            ++count;
            if (!edge.isSelfLoop()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getInDegree(Node node) {
        int count = 0;
        EdgeStore.EdgeInIterator itr = this.graphStore.edgeStore.edgeInIterator(node);
        while (itr.hasNext()) {
            if (!this.view.containsEdge(itr.next())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getOutDegree(Node node) {
        int count = 0;
        EdgeStore.EdgeOutIterator itr = this.graphStore.edgeStore.edgeOutIterator(node);
        while (itr.hasNext()) {
            if (!this.view.containsEdge(itr.next())) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isSelfLoop(Edge edge) {
        return edge.isSelfLoop();
    }

    @Override
    public boolean isDirected(Edge edge) {
        return edge.isDirected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIncident(Edge edge1, Edge edge2) {
        this.graphStore.autoReadLock();
        try {
            this.checkValidInViewEdgeObject(edge1);
            this.checkValidInViewEdgeObject(edge2);
            boolean bl = this.graphStore.edgeStore.isIncident((EdgeImpl)edge1, (EdgeImpl)edge2);
            return bl;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIncident(Node node, Edge edge) {
        this.graphStore.autoReadLock();
        try {
            this.checkValidInViewNodeObject(node);
            this.checkValidInViewEdgeObject(edge);
            boolean bl = this.graphStore.edgeStore.isIncident((NodeImpl)node, (EdgeImpl)edge);
            return bl;
        }
        finally {
            this.graphStore.autoReadUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearEdges(Node node) {
        this.graphStore.autoWriteLock();
        try {
            EdgeStore.EdgeInOutIterator itr = this.graphStore.edgeStore.edgeIterator(node);
            while (itr.hasNext()) {
                EdgeImpl edge = itr.next();
                this.view.removeEdge((Edge)edge);
            }
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearEdges(Node node, int type) {
        this.graphStore.autoWriteLock();
        try {
            EdgeStore.EdgeTypeInOutIterator itr = this.graphStore.edgeStore.edgeIterator(node, type);
            while (itr.hasNext()) {
                EdgeImpl edge = itr.next();
                this.view.removeEdge((Edge)edge);
            }
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public void clear() {
        this.view.clear();
    }

    @Override
    public void clearEdges() {
        this.view.clearEdges();
    }

    @Override
    public Object getAttribute(String key) {
        return this.view.attributes.getValue(key);
    }

    @Override
    public Object getAttribute(String key, double timestamp) {
        return this.view.attributes.getValue(key, timestamp);
    }

    @Override
    public Object getAttribute(String key, Interval interval) {
        return this.view.attributes.getValue(key, interval);
    }

    @Override
    public Set<String> getAttributeKeys() {
        return this.view.attributes.getKeys();
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.view.attributes.setValue(key, value);
    }

    @Override
    public void setAttribute(String key, Object value, double timestamp) {
        this.view.attributes.setValue(key, value, timestamp);
    }

    @Override
    public void setAttribute(String key, Object value, Interval interval) {
        this.view.attributes.setValue(key, value, interval);
    }

    @Override
    public void removeAttribute(String key) {
        this.view.attributes.removeValue(key);
    }

    @Override
    public void removeAttribute(String key, double timestamp) {
        this.view.attributes.removeValue(key, timestamp);
    }

    @Override
    public void removeAttribute(String key, Interval interval) {
        this.view.attributes.removeValue(key, interval);
    }

    @Override
    public GraphModel getModel() {
        return this.graphStore.graphModel;
    }

    @Override
    public int getVersion() {
        return this.view.getVersion();
    }

    @Override
    public boolean isDirected() {
        return this.graphStore.isDirected();
    }

    @Override
    public boolean isUndirected() {
        return this.graphStore.isUndirected();
    }

    @Override
    public boolean isMixed() {
        return this.graphStore.isMixed();
    }

    @Override
    public void readLock() {
        this.graphStore.lock.readLock();
    }

    @Override
    public void readUnlock() {
        this.graphStore.lock.readUnlock();
    }

    @Override
    public void readUnlockAll() {
        this.graphStore.lock.readUnlockAll();
    }

    @Override
    public void writeLock() {
        this.graphStore.lock.writeLock();
    }

    @Override
    public GraphLockImpl getLock() {
        return this.graphStore.lock;
    }

    @Override
    public void writeUnlock() {
        this.graphStore.lock.writeUnlock();
    }

    @Override
    public GraphView getView() {
        return this.view;
    }

    @Override
    public void fill() {
        this.graphStore.autoWriteLock();
        try {
            this.view.fill();
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public void union(Subgraph subGraph) {
        this.checkValidViewObject(subGraph.getView());
        this.graphStore.autoWriteLock();
        try {
            this.view.union((GraphViewImpl)subGraph.getView());
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public void intersection(Subgraph subGraph) {
        this.checkValidViewObject(subGraph.getView());
        this.graphStore.autoWriteLock();
        try {
            this.view.intersection((GraphViewImpl)subGraph.getView());
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public void not() {
        this.graphStore.autoWriteLock();
        try {
            this.view.not();
        }
        finally {
            this.graphStore.autoWriteUnlock();
        }
    }

    @Override
    public Graph getRootGraph() {
        return this.graphStore;
    }

    void checkWriteLock() {
        if (this.graphStore.lock != null) {
            this.graphStore.lock.checkHoldWriteLock();
        }
    }

    void checkValidNodeObject(Node n) {
        if (n == null) {
            throw new NullPointerException();
        }
        if (!(n instanceof NodeImpl)) {
            throw new ClassCastException("Object must be a NodeImpl object");
        }
        if (((NodeImpl)n).storeId == -1) {
            throw new IllegalArgumentException("Node should belong to a store");
        }
    }

    void checkValidInViewNodeObject(Node n) {
        this.checkValidNodeObject(n);
        if (!this.view.containsNode((NodeImpl)n)) {
            throw new RuntimeException("Node doesn't belong to this view");
        }
    }

    void checkValidEdgeObject(Edge n) {
        if (n == null) {
            throw new NullPointerException();
        }
        if (!(n instanceof EdgeImpl)) {
            throw new ClassCastException("Object must be a EdgeImpl object");
        }
        if (((EdgeImpl)n).storeId == -1) {
            throw new IllegalArgumentException("Edge should belong to a store");
        }
    }

    void checkValidInViewEdgeObject(Edge e) {
        this.checkValidEdgeObject(e);
        if (!this.view.containsEdge((EdgeImpl)e)) {
            throw new RuntimeException("Edge doesn't belong to this view");
        }
    }

    void checkValidViewObject(GraphView view) {
        if (view == null) {
            throw new NullPointerException();
        }
        if (!(view instanceof GraphViewImpl)) {
            throw new ClassCastException("Object must be a GraphViewImpl object");
        }
        if (((GraphViewImpl)view).graphStore != this.graphStore) {
            throw new RuntimeException("The view doesn't belong to this store");
        }
    }

    boolean isUndirectedToIgnore(EdgeImpl edge) {
        return edge.isMutual() && edge.source.storeId < edge.target.storeId && this.view.containsEdge(this.graphStore.edgeStore.get(edge.target, edge.source, edge.type, false));
    }

    @Override
    public NodeIterable getNodesInArea(Rect2D rect) {
        Iterator<Node> iterator = this.graphStore.spatialIndex.getNodesInArea(rect).iterator();
        return new NodeIterableWrapper(new NodeViewIterator(iterator), this.graphStore.spatialIndex.nodesTree.lock);
    }

    @Override
    public EdgeIterable getEdgesInArea(Rect2D rect) {
        Iterator<Edge> iterator = this.graphStore.spatialIndex.getEdgesInArea(rect).iterator();
        return new EdgeIterableWrapper(new EdgeViewIterator(iterator), this.graphStore.spatialIndex.nodesTree.lock);
    }

    protected class NeighborsIterator
    implements Iterator<Node> {
        protected final NodeImpl node;
        protected final Iterator<Edge> itr;

        public NeighborsIterator(NodeImpl node, Iterator<Edge> itr) {
            this.node = node;
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext();
        }

        @Override
        public Node next() {
            Edge e = this.itr.next();
            return e.getSource() == this.node ? e.getTarget() : e.getSource();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported for this iterator");
        }
    }

    protected final class UndirectedEdgeViewIterator
    implements Iterator<Edge> {
        protected final Iterator<Edge> itr;
        protected EdgeImpl pointer;

        public UndirectedEdgeViewIterator(Iterator<Edge> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            this.pointer = null;
            while (this.pointer == null || !GraphViewDecorator.this.view.containsEdge(this.pointer) || GraphViewDecorator.this.isUndirectedToIgnore(this.pointer)) {
                if (!this.itr.hasNext()) {
                    return false;
                }
                this.pointer = (EdgeImpl)this.itr.next();
            }
            return true;
        }

        @Override
        public EdgeImpl next() {
            return this.pointer;
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    protected final class EdgeViewIterator
    implements Iterator<Edge> {
        private final Iterator<Edge> edgeIterator;
        private EdgeImpl pointer;

        public EdgeViewIterator(Iterator<Edge> edgeIterator) {
            this.edgeIterator = edgeIterator;
        }

        @Override
        public boolean hasNext() {
            this.pointer = null;
            while (this.pointer == null) {
                if (!this.edgeIterator.hasNext()) {
                    return false;
                }
                this.pointer = (EdgeImpl)this.edgeIterator.next();
                if (GraphViewDecorator.this.view.containsEdge(this.pointer)) continue;
                this.pointer = null;
            }
            return true;
        }

        @Override
        public Edge next() {
            return this.pointer;
        }

        @Override
        public void remove() {
            GraphViewDecorator.this.checkWriteLock();
            GraphViewDecorator.this.removeEdge(this.pointer);
        }
    }

    protected final class NodeViewIterator
    implements Iterator<Node> {
        private final Iterator<Node> nodeIterator;
        private NodeImpl pointer;

        public NodeViewIterator(Iterator<Node> nodeIterator) {
            this.nodeIterator = nodeIterator;
        }

        @Override
        public boolean hasNext() {
            this.pointer = null;
            while (this.pointer == null) {
                if (!this.nodeIterator.hasNext()) {
                    return false;
                }
                this.pointer = (NodeImpl)this.nodeIterator.next();
                if (GraphViewDecorator.this.view.containsNode(this.pointer)) continue;
                this.pointer = null;
            }
            return true;
        }

        @Override
        public Node next() {
            return this.pointer;
        }

        @Override
        public void remove() {
            GraphViewDecorator.this.checkWriteLock();
            GraphViewDecorator.this.removeNode(this.pointer);
        }
    }
}

