/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.Interval;

public final class Interval2IntTreeMap
implements Map<Interval, Integer> {
    private static final boolean EXCLUDE_INFINITE = true;
    private Node nil;
    private Node root;
    private int size = 0;
    private static final Color RED = Color.RED;
    private static final Color BLACK = Color.BLACK;

    public Interval2IntTreeMap() {
        this.nil.right = this.nil.p = (this.nil = new Node());
        this.nil.left = this.nil.p;
        this.root = this.nil;
    }

    private boolean compareLow(Interval a, Interval b) {
        return a.getLow() == b.getLow() ? a.getHigh() <= b.getHigh() : a.getLow() < b.getLow();
    }

    @Override
    public Integer put(Interval interval, Integer value) {
        if (interval == null) {
            throw new NullPointerException("Interval cannot be null.");
        }
        if (value == null) {
            throw new NullPointerException("Value cannot be null.");
        }
        Node n = this.findNode(this.root.left, interval);
        if (n != null) {
            this.remove(interval);
            this.insert(new Node(interval, value));
            return n.v;
        }
        this.insert(new Node(interval, value));
        return null;
    }

    private void insert(Node z) {
        z.left = z.right = this.nil;
        Node y = this.root;
        Node x = this.root.left;
        while (x != this.nil) {
            y = x;
            x = this.compareLow(z.i, y.i) ? x.left : x.right;
            y.max = Math.max(z.max, y.max);
            if (y.p != this.root) continue;
            this.root.max = y.max;
        }
        z.p = y;
        if (y == this.root) {
            this.root.max = z.max;
        }
        if (y == this.root || this.compareLow(z.i, y.i)) {
            y.left = z;
        } else {
            y.right = z;
        }
        this.insertFixup(z);
        ++this.size;
    }

    private void insertFixup(Node z) {
        z.color = RED;
        while (z.p.color == RED) {
            Node y;
            if (z.p == z.p.p.left) {
                y = z.p.p.right;
                if (y.color == RED) {
                    z.p.color = BLACK;
                    y.color = BLACK;
                    z.p.p.color = RED;
                    z = z.p.p;
                    continue;
                }
                if (z == z.p.right) {
                    z = z.p;
                    this.leftRotate(z);
                }
                z.p.color = BLACK;
                z.p.p.color = RED;
                this.rightRotate(z.p.p);
                continue;
            }
            y = z.p.p.left;
            if (y.color == RED) {
                z.p.color = BLACK;
                y.color = BLACK;
                z.p.p.color = RED;
                z = z.p.p;
                continue;
            }
            if (z == z.p.left) {
                z = z.p;
                this.rightRotate(z);
            }
            z.p.color = BLACK;
            z.p.p.color = RED;
            this.leftRotate(z.p.p);
        }
        this.root.left.color = BLACK;
    }

    @Override
    public Integer remove(Object interval) {
        Node n = this.findNode(this.root.left, (Interval)interval);
        if (n != null) {
            this.delete(n);
            return n.v;
        }
        return null;
    }

    @Override
    public Integer get(Object interval) {
        Node n = this.findNode(this.root.left, (Interval)interval);
        return n != null ? Integer.valueOf(n.v) : null;
    }

    @Override
    public boolean containsKey(Object interval) {
        return this.findNode(this.root.left, (Interval)interval) != null;
    }

    private Node findNode(Node z, Interval i) {
        if (z != null) {
            Node r;
            if (z.i != null && z.i.equals(i)) {
                return z;
            }
            if (z.i == null) {
                return null;
            }
            boolean cmp = this.compareLow(i, z.i);
            if (z.left != null && cmp && i.getHigh() <= z.left.max && (r = this.findNode(z.left, i)) != null) {
                return r;
            }
            if (z.right != null && !cmp && i.getHigh() <= z.right.max && (r = this.findNode(z.right, i)) != null) {
                return r;
            }
        }
        return null;
    }

    private void delete(Node z) {
        z.max = Double.NEGATIVE_INFINITY;
        Node y = z.left == this.nil || z.right == this.nil ? z : this.succesor(z);
        Node x = y.left == this.nil ? y.right : y.left;
        x.p = y.p;
        if (this.root == x.p) {
            this.root.left = x;
        } else if (y == y.p.left) {
            y.p.left = x;
        } else {
            y.p.right = x;
        }
        if (y != z) {
            if (y.color == BLACK) {
                this.deleteFixup(x);
            }
            y.left = z.left;
            y.right = z.right;
            y.p = z.p;
            y.color = z.color;
            z.left.p = z.right.p = y;
            if (z == z.p.left) {
                z.p.left = y;
            } else {
                z.p.right = y;
            }
        } else if (y.color == BLACK) {
            this.deleteFixup(x);
        }
        this.computeMax(y);
        Node i = y.p;
        while (i != this.root) {
            this.computeMax(i);
            if (i.p == this.root) {
                this.root.max = i.max;
            }
            i = i.p;
        }
        --this.size;
    }

    private void deleteFixup(Node x) {
        while (x != this.root.left && x.color == BLACK) {
            Node w;
            if (x == x.p.left) {
                w = x.p.right;
                if (w.color == RED) {
                    w.color = BLACK;
                    x.p.color = RED;
                    this.leftRotate(x.p);
                    w = x.p.right;
                }
                if (w.left.color == BLACK && w.right.color == BLACK) {
                    w.color = RED;
                    x = x.p;
                    continue;
                }
                if (w.right.color == BLACK) {
                    w.left.color = BLACK;
                    w.color = RED;
                    this.rightRotate(w);
                    w = x.p.right;
                }
                w.color = x.p.color;
                x.p.color = BLACK;
                w.right.color = BLACK;
                this.leftRotate(x.p);
                x = this.root.left;
                continue;
            }
            w = x.p.left;
            if (w.color == RED) {
                w.color = BLACK;
                x.p.color = RED;
                this.rightRotate(x.p);
                w = x.p.left;
            }
            if (w.right.color == BLACK && w.left.color == BLACK) {
                w.color = RED;
                x = x.p;
                continue;
            }
            if (w.left.color == BLACK) {
                w.right.color = BLACK;
                w.color = RED;
                this.leftRotate(w);
                w = x.p.left;
            }
            w.color = x.p.color;
            x.p.color = BLACK;
            w.left.color = BLACK;
            this.rightRotate(x.p);
            x = this.root.left;
        }
        x.color = BLACK;
    }

    private void leftRotate(Node x) {
        Node y = x.right;
        x.right = y.left;
        if (y.left != this.nil) {
            y.left.p = x;
        }
        y.p = x.p;
        if (x == x.p.left) {
            x.p.left = y;
        } else {
            x.p.right = y;
        }
        y.left = x;
        x.p = y;
        if (y.p == this.root) {
            this.root.max = x.max;
        }
        y.max = x.max;
        this.computeMax(x);
    }

    private void rightRotate(Node x) {
        Node y = x.left;
        x.left = y.right;
        if (y.right != this.nil) {
            y.right.p = x;
        }
        y.p = x.p;
        if (x == x.p.left) {
            x.p.left = y;
        } else {
            x.p.right = y;
        }
        y.right = x;
        x.p = y;
        if (y.p == this.root) {
            this.root.max = x.max;
        }
        y.max = x.max;
        this.computeMax(x);
    }

    private void computeMax(Node x) {
        x.max = x.left == this.nil && x.right == this.nil ? x.i.getHigh() : (x.left == this.nil ? Math.max(x.i.getHigh(), x.right.max) : (x.right == this.nil ? Math.max(x.i.getHigh(), x.left.max) : Math.max(x.i.getHigh(), Math.max(x.left.max, x.right.max))));
    }

    private Node succesor(Node x) {
        Node y = x.right;
        if (y != this.nil) {
            while (y.left != this.nil) {
                y = y.left;
            }
            return y;
        }
        y = x.p;
        while (x == y.right) {
            x = y;
            y = y.p;
        }
        if (y == this.root) {
            return this.nil;
        }
        return y;
    }

    public Interval minimum() {
        if (this.root.left == this.nil) {
            return null;
        }
        return this.treeMinimum(this.root.left);
    }

    private Interval treeMinimum(Node x) {
        while (x.left != this.nil) {
            x = x.left;
        }
        if (Double.isInfinite(x.i.getLow())) {
            List<Interval> ints = this.getIntervals();
            for (Interval i : ints) {
                if (Double.isInfinite(i.getLow())) continue;
                return i;
            }
            return ints.get(0);
        }
        return x.i;
    }

    public Interval maximum() {
        if (this.root.left == this.nil) {
            return null;
        }
        return this.treeMaximum((Node)this.root.left).i;
    }

    private Node treeMaximum(Node x) {
        if (x.right != this.nil && x.right.max == x.max) {
            return this.treeMaximum(x.right);
        }
        if (x.left != this.nil && x.left.max == x.max) {
            return this.treeMaximum(x.left);
        }
        return x;
    }

    public double getLow() {
        if (this.isEmpty()) {
            return Double.NEGATIVE_INFINITY;
        }
        Interval min = this.minimum();
        if (Double.isInfinite(min.getLow()) && !Double.isInfinite(min.getHigh())) {
            return min.getHigh();
        }
        return min.getLow();
    }

    public double getHigh() {
        if (this.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        double max = this.root.left.max;
        if (Double.isInfinite(max)) {
            max = Double.NEGATIVE_INFINITY;
            for (Interval i : this.getIntervals()) {
                if (!Double.isInfinite(i.getLow())) {
                    max = Math.max(max, i.getLow());
                }
                if (Double.isInfinite(i.getHigh())) continue;
                max = Math.max(max, i.getHigh());
            }
            if (max == Double.NEGATIVE_INFINITY) {
                return Double.POSITIVE_INFINITY;
            }
        }
        return max;
    }

    @Override
    public boolean isEmpty() {
        return this.root.left == this.nil;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
        this.root = this.nil;
        this.nil.right = this.nil.p = this.nil;
        this.nil.left = this.nil.p;
    }

    public List<Interval> getIntervals() {
        ArrayList<Interval> list = new ArrayList<Interval>();
        this.inorderTreeWalk(this.root.left, list);
        return list;
    }

    @Override
    public Set<Map.Entry<Interval, Integer>> entrySet() {
        return this.entrySet(Interval.INFINITY_INTERVAL);
    }

    public Set<Map.Entry<Interval, Integer>> entrySet(double point) {
        return new EntryIterable(this.searchNodes(point));
    }

    public Set<Map.Entry<Interval, Integer>> entrySet(Interval interval) {
        if (interval == null) {
            throw new NullPointerException("Interval cannot be null.");
        }
        return new EntryIterable(this.searchNodes(interval));
    }

    @Override
    public Collection<Integer> values() {
        return this.values(Interval.INFINITY_INTERVAL);
    }

    public Collection<Integer> values(Interval interval) {
        if (interval == null) {
            throw new NullPointerException("Interval cannot be null.");
        }
        return new ValueIterable(this.searchNodes(interval));
    }

    public Iterable<Integer> values(double point) {
        return new ValueIterable(this.searchNodes(point));
    }

    private List<Node> searchNodes(Interval interval) {
        ArrayList<Node> result = new ArrayList<Node>();
        this.searchNodes(this.root.left, interval, result);
        return result;
    }

    private List<Node> searchNodes(double point) {
        ArrayList<Node> result = new ArrayList<Node>();
        this.searchNodes(this.root.left, point, result);
        return result;
    }

    private void searchNodes(Node n, Interval interval, List<Node> result) {
        if (n == this.nil) {
            return;
        }
        if (interval.getLow() > n.max) {
            return;
        }
        if (n.left != this.nil) {
            this.searchNodes(n.left, interval, result);
        }
        if (n.i.compareTo(interval) == 0) {
            result.add(n);
        }
        if (interval.compareTo(n.i) < 0) {
            return;
        }
        if (n.right != this.nil) {
            this.searchNodes(n.right, interval, result);
        }
    }

    private void searchNodes(Node n, double point, List<Node> result) {
        if (n == this.nil) {
            return;
        }
        if (point > n.max) {
            return;
        }
        if (n.left != this.nil) {
            this.searchNodes(n.left, point, result);
        }
        if (n.i.compareTo(point) == 0) {
            result.add(n);
        }
        if (point < n.i.getLow()) {
            return;
        }
        if (n.right != this.nil) {
            this.searchNodes(n.right, point, result);
        }
    }

    private void inorderTreeWalk(Node x, List<Interval> list) {
        if (x != this.nil) {
            this.inorderTreeWalk(x.left, list);
            list.add(x.i);
            this.inorderTreeWalk(x.right, list);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            Interval2IntTreeMap other = (Interval2IntTreeMap)obj;
            if (other.size != this.size) {
                return false;
            }
            Iterator<Map.Entry<Interval, Integer>> thisIntervals = this.entrySet(Interval.INFINITY_INTERVAL).iterator();
            Iterator<Map.Entry<Interval, Integer>> otherIntervals = other.entrySet(Interval.INFINITY_INTERVAL).iterator();
            while (thisIntervals.hasNext()) {
                Map.Entry<Interval, Integer> otherEntry;
                Map.Entry<Interval, Integer> thisEntry = thisIntervals.next();
                if (thisEntry.equals(otherEntry = otherIntervals.next())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        Iterator<Map.Entry<Interval, Integer>> thisIntervals = this.entrySet(Interval.INFINITY_INTERVAL).iterator();
        while (thisIntervals.hasNext()) {
            hash = 97 * hash + thisIntervals.next().hashCode();
        }
        return hash;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public void putAll(Map<? extends Interval, ? extends Integer> m) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public Set<Interval> keySet() {
        throw new UnsupportedOperationException("Not supported.");
    }

    private static class ValueIterator
    implements Iterator<Integer> {
        private final Iterator<Node> nodes;

        public ValueIterator(Iterator<Node> nodes) {
            this.nodes = nodes;
        }

        @Override
        public boolean hasNext() {
            return this.nodes.hasNext();
        }

        @Override
        public Integer next() {
            Node n = this.nodes.next();
            return n.v;
        }
    }

    private static class ValueIterable
    implements Collection<Integer> {
        public final List<Node> nodes;

        public ValueIterable(List<Node> nodes) {
            this.nodes = nodes;
        }

        @Override
        public Iterator<Integer> iterator() {
            return new ValueIterator(this.nodes.iterator());
        }

        @Override
        public int size() {
            return this.nodes.size();
        }

        @Override
        public boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean add(Integer e) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean addAll(Collection<? extends Integer> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private static class Entry
    implements Map.Entry<Interval, Integer> {
        private Interval key;
        private int value;

        private Entry() {
        }

        public int getIntValue() {
            return this.value;
        }

        @Override
        public Interval getKey() {
            return this.key;
        }

        @Override
        public Integer getValue() {
            return this.value;
        }

        @Override
        public Integer setValue(Integer value) {
            throw new UnsupportedOperationException("Not supported.");
        }

        private void set(Interval key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + (this.key != null ? this.key.hashCode() : 0);
            hash = 89 * hash + this.value;
            return hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Entry other = (Entry)obj;
            if (this.value != other.value) {
                return false;
            }
            return this.key == other.key || this.key != null && this.key.equals(other.key);
        }
    }

    private static class EntryIterator
    implements Iterator<Map.Entry<Interval, Integer>> {
        private final Iterator<Node> nodes;
        private final Entry entry = new Entry();

        public EntryIterator(Iterator<Node> nodes) {
            this.nodes = nodes;
        }

        @Override
        public boolean hasNext() {
            return this.nodes.hasNext();
        }

        @Override
        public Map.Entry<Interval, Integer> next() {
            Node n = this.nodes.next();
            this.entry.set(n.i, n.v);
            return this.entry;
        }
    }

    private static class EntryIterable
    implements Set<Map.Entry<Interval, Integer>> {
        public final List<Node> nodes;

        public EntryIterable(List<Node> nodes) {
            this.nodes = nodes;
        }

        @Override
        public Iterator<Map.Entry<Interval, Integer>> iterator() {
            return new EntryIterator(this.nodes.iterator());
        }

        @Override
        public int size() {
            return this.nodes.size();
        }

        @Override
        public boolean isEmpty() {
            return this.nodes.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public <T> T[] toArray(T[] a) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean add(Map.Entry<Interval, Integer> e) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean addAll(Collection<? extends Map.Entry<Interval, Integer>> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("Not supported.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Not supported.");
        }
    }

    private static enum Color {
        RED,
        BLACK;

    }

    private static class Node {
        private final Interval i;
        private final int v;
        private double max;
        private Color color = BLACK;
        private Node left;
        private Node right;
        private Node p;

        public Node() {
            this.i = null;
            this.v = 0;
        }

        public Node(Interval key, int value) {
            this.i = key;
            this.v = value;
            this.max = this.i.getHigh();
        }
    }
}

