/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.TimeRepresentation;
import org.gephi.graph.impl.GraphStore;
import org.gephi.graph.impl.GraphStoreConfiguration;
import org.gephi.graph.impl.IntervalIndexStore;
import org.gephi.graph.impl.TableLockImpl;
import org.gephi.graph.impl.TimeIndexStore;
import org.gephi.graph.impl.TimestampIndexStore;

public class TimeStore {
    protected final GraphStore graphStore;
    protected final TableLockImpl lock;
    protected final TimeIndexStore nodeIndexStore;
    protected final TimeIndexStore edgeIndexStore;

    public TimeStore(GraphStore store, boolean indexed) {
        this.graphStore = store;
        this.lock = store != null && store.configuration.isEnableAutoLocking() ? new TableLockImpl() : null;
        TimeRepresentation timeRepresentation = GraphStoreConfiguration.DEFAULT_TIME_REPRESENTATION;
        if (store != null) {
            timeRepresentation = store.configuration.getTimeRepresentation();
        }
        if (timeRepresentation.equals((Object)TimeRepresentation.INTERVAL)) {
            this.nodeIndexStore = new IntervalIndexStore<Node>(Node.class, this.lock, indexed);
            this.edgeIndexStore = new IntervalIndexStore<Edge>(Edge.class, this.lock, indexed);
        } else {
            this.nodeIndexStore = new TimestampIndexStore<Node>(Node.class, this.lock, indexed);
            this.edgeIndexStore = new TimestampIndexStore<Edge>(Edge.class, this.lock, indexed);
        }
    }

    public double getMin(Graph graph) {
        if (this.nodeIndexStore == null || this.edgeIndexStore == null) {
            return Double.NEGATIVE_INFINITY;
        }
        double nodeMin = this.nodeIndexStore.getIndex(graph).getMinTimestamp();
        double edgeMin = this.edgeIndexStore.getIndex(graph).getMinTimestamp();
        if (Double.isInfinite(nodeMin)) {
            return edgeMin;
        }
        if (Double.isInfinite(edgeMin)) {
            return nodeMin;
        }
        return Math.min(nodeMin, edgeMin);
    }

    public double getMax(Graph graph) {
        if (this.nodeIndexStore == null || this.edgeIndexStore == null) {
            return Double.POSITIVE_INFINITY;
        }
        double nodeMax = this.nodeIndexStore.getIndex(graph).getMaxTimestamp();
        double edgeMax = this.edgeIndexStore.getIndex(graph).getMaxTimestamp();
        if (Double.isInfinite(nodeMax)) {
            return edgeMax;
        }
        if (Double.isInfinite(edgeMax)) {
            return nodeMax;
        }
        return Math.max(nodeMax, edgeMax);
    }

    public boolean isEmpty() {
        return this.nodeIndexStore.size() == 0 && this.edgeIndexStore.size() == 0;
    }

    public void clear() {
        this.nodeIndexStore.clear();
        this.edgeIndexStore.clear();
    }

    public void clearEdges() {
        this.edgeIndexStore.clear();
    }

    public int deepHashCode() {
        int hash = 3;
        hash = 79 * hash + (this.nodeIndexStore != null ? this.nodeIndexStore.deepHashCode() : 0);
        hash = 79 * hash + (this.edgeIndexStore != null ? this.edgeIndexStore.deepHashCode() : 0);
        return hash;
    }

    public boolean deepEquals(TimeStore obj) {
        if (obj == null) {
            return false;
        }
        if (!(this.nodeIndexStore == obj.nodeIndexStore || this.nodeIndexStore != null && this.nodeIndexStore.deepEquals(obj.nodeIndexStore))) {
            return false;
        }
        return this.edgeIndexStore == obj.edgeIndexStore || this.edgeIndexStore != null && this.edgeIndexStore.deepEquals(obj.edgeIndexStore);
    }
}

