/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import it.unimi.dsi.fastutil.doubles.Double2IntMap;
import it.unimi.dsi.fastutil.doubles.Double2IntSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import org.gephi.graph.api.Element;
import org.gephi.graph.api.ElementIterable;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.types.TimestampMap;
import org.gephi.graph.api.types.TimestampSet;
import org.gephi.graph.impl.TimeIndexImpl;
import org.gephi.graph.impl.TimeIndexStore;

public class TimestampIndexImpl<T extends Element>
extends TimeIndexImpl<T, Double, TimestampSet, TimestampMap<?>> {
    public TimestampIndexImpl(TimeIndexStore<T, Double, TimestampSet, TimestampMap<?>> store, boolean main) {
        super(store, main);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMinTimestamp() {
        this.lock();
        try {
            Double2IntSortedMap sortedMap = (Double2IntSortedMap)this.timestampIndexStore.timeSortedMap;
            if (this.mainIndex) {
                if (!sortedMap.isEmpty()) {
                    double d = sortedMap.firstDoubleKey();
                    return d;
                }
            } else if (!sortedMap.isEmpty()) {
                for (Double2IntMap.Entry entry : sortedMap.double2IntEntrySet()) {
                    TimeIndexImpl.TimeIndexEntry timestampEntry;
                    double timestamp = entry.getDoubleKey();
                    int index = entry.getIntValue();
                    if (index >= this.timestamps.length || (timestampEntry = this.timestamps[index]) == null) continue;
                    double d = timestamp;
                    return d;
                }
            }
            double d = Double.NEGATIVE_INFINITY;
            return d;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getMaxTimestamp() {
        this.lock();
        try {
            Double2IntSortedMap sortedMap = (Double2IntSortedMap)this.timestampIndexStore.timeSortedMap;
            if (this.mainIndex) {
                if (!sortedMap.isEmpty()) {
                    double d = sortedMap.lastDoubleKey();
                    return d;
                }
            } else if (!sortedMap.isEmpty()) {
                ObjectBidirectionalIterator bi = sortedMap.double2IntEntrySet().iterator((Object)((Double2IntMap.Entry)sortedMap.double2IntEntrySet().last()));
                while (bi.hasPrevious()) {
                    TimeIndexImpl.TimeIndexEntry timestampEntry;
                    Double2IntMap.Entry entry = (Double2IntMap.Entry)bi.previous();
                    double timestamp = entry.getDoubleKey();
                    int index = entry.getIntValue();
                    if (index >= this.timestamps.length || (timestampEntry = this.timestamps[index]) == null) continue;
                    double d = timestamp;
                    return d;
                }
            }
            double d = Double.POSITIVE_INFINITY;
            return d;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementIterable<T> get(double timestamp) {
        this.checkDouble(timestamp);
        this.lock();
        try {
            TimeIndexImpl.TimeIndexEntry ts;
            Integer index = this.timestampIndexStore.timeSortedMap.get(timestamp);
            if (index != null && index < this.timestamps.length && (ts = this.timestamps[index]) != null) {
                TimeIndexImpl.ElementSetWrapperIterable elementSetWrapperIterable = new TimeIndexImpl.ElementSetWrapperIterable(this, (Set<Element>)new ObjectOpenHashSet(ts.elementSet));
                return elementSetWrapperIterable;
            }
            ElementIterable elementIterable = ElementIterable.EMPTY;
            return elementIterable;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ElementIterable<T> get(Interval interval) {
        this.checkDouble(interval.getLow());
        this.checkDouble(interval.getHigh());
        this.lock();
        try {
            ElementIterable elementIterable;
            ObjectOpenHashSet elements = new ObjectOpenHashSet();
            Double2IntSortedMap sortedMap = (Double2IntSortedMap)this.timestampIndexStore.timeSortedMap;
            if (!sortedMap.isEmpty()) {
                for (Double2IntMap.Entry entry : sortedMap.tailMap(interval.getLow()).double2IntEntrySet()) {
                    TimeIndexImpl.TimeIndexEntry ts;
                    double timestamp = entry.getDoubleKey();
                    int index = entry.getIntValue();
                    if (!(timestamp <= interval.getHigh())) break;
                    if (index >= this.timestamps.length || (ts = this.timestamps[index]) == null) continue;
                    elements.addAll(ts.elementSet);
                }
            }
            if (!elements.isEmpty()) {
                elementIterable = new TimeIndexImpl.ElementSetWrapperIterable(this, (Set<Element>)elements);
                return elementIterable;
            }
            elementIterable = ElementIterable.EMPTY;
            return elementIterable;
        }
        finally {
            this.unlock();
        }
    }
}

