/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.util.Collection;
import java.util.Set;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.GraphView;
import org.gephi.graph.api.Interval;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Subgraph;
import org.gephi.graph.api.UndirectedGraph;
import org.gephi.graph.api.UndirectedSubgraph;
import org.gephi.graph.impl.EdgeImpl;
import org.gephi.graph.impl.GraphLockImpl;
import org.gephi.graph.impl.GraphStore;

public class UndirectedDecorator
implements UndirectedGraph,
UndirectedSubgraph {
    protected final GraphStore store;

    public UndirectedDecorator(GraphStore store) {
        this.store = store;
    }

    @Override
    public boolean addEdge(Edge edge) {
        if (edge.isDirected()) {
            throw new IllegalArgumentException("Can't add a directed edge to an undirected graph");
        }
        return this.store.addEdge(edge);
    }

    @Override
    public boolean addNode(Node node) {
        return this.store.addNode(node);
    }

    @Override
    public boolean addAllEdges(Collection<? extends Edge> edges) {
        for (Edge edge : edges) {
            if (!edge.isDirected()) continue;
            throw new IllegalArgumentException("Can't add a directed edge to an undirected graph");
        }
        return this.store.addAllEdges(edges);
    }

    @Override
    public boolean addAllNodes(Collection<? extends Node> nodes) {
        return this.store.addAllNodes(nodes);
    }

    @Override
    public boolean removeEdge(Edge edge) {
        return this.store.removeEdge(edge);
    }

    @Override
    public boolean removeNode(Node node) {
        return this.store.removeNode(node);
    }

    @Override
    public boolean removeAllEdges(Collection<? extends Edge> edges) {
        return this.store.removeAllEdges(edges);
    }

    @Override
    public boolean removeAllNodes(Collection<? extends Node> nodes) {
        return this.store.removeAllNodes(nodes);
    }

    @Override
    public boolean retainNodes(Collection<? extends Node> nodes) {
        return this.store.retainNodes(nodes);
    }

    @Override
    public boolean retainEdges(Collection<? extends Edge> edges) {
        return this.store.retainEdges(edges);
    }

    @Override
    public boolean contains(Node node) {
        return this.store.contains(node);
    }

    @Override
    public boolean contains(Edge edge) {
        return this.store.contains(edge);
    }

    @Override
    public Node getNode(Object id) {
        return this.store.getNode(id);
    }

    @Override
    public Node getNodeByStoreId(int id) {
        return this.store.getNodeByStoreId(id);
    }

    @Override
    public boolean hasNode(Object id) {
        return this.store.hasNode(id);
    }

    @Override
    public Edge getEdge(Object id) {
        return this.store.getEdge(id);
    }

    @Override
    public Edge getEdgeByStoreId(int storeId) {
        return this.store.getEdgeByStoreId(storeId);
    }

    @Override
    public boolean hasEdge(Object id) {
        return this.store.hasEdge(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Edge getEdge(Node node1, Node node2) {
        this.readLock();
        try {
            EdgeImpl edgeImpl = this.store.edgeStore.get(node1, node2, true);
            return edgeImpl;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public EdgeIterable getEdges(Node node1, Node node2) {
        return this.store.getEdgeIterableWrapper(this.store.edgeStore.edgesUndirectedIterator(node1, node2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Edge getEdge(Node node1, Node node2, int type) {
        this.readLock();
        try {
            EdgeImpl edgeImpl = this.store.edgeStore.get(node1, node2, type, true);
            return edgeImpl;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public EdgeIterable getEdges(Node node1, Node node2, int type) {
        return this.store.getEdgeIterableWrapper(this.store.edgeStore.edgesUndirectedIterator(node1, node2, type));
    }

    @Override
    public NodeIterable getNodes() {
        return this.store.getNodes();
    }

    @Override
    public EdgeIterable getEdges() {
        return this.store.getEdgeIterableWrapper(this.store.edgeStore.iteratorUndirected());
    }

    @Override
    public EdgeIterable getEdges(int type) {
        return this.store.getEdgeIterableWrapper(this.store.edgeStore.iteratorType(type, true));
    }

    @Override
    public EdgeIterable getSelfLoops() {
        return this.store.getEdgeIterableWrapper(this.store.edgeStore.iteratorSelfLoop());
    }

    @Override
    public NodeIterable getNeighbors(Node node) {
        return this.store.getNodeIterableWrapper(this.store.edgeStore.neighborIterator(node));
    }

    @Override
    public NodeIterable getNeighbors(Node node, int type) {
        return this.store.getNodeIterableWrapper(this.store.edgeStore.neighborIterator(node, type));
    }

    @Override
    public EdgeIterable getEdges(Node node) {
        return this.store.getEdgeIterableWrapper(this.store.edgeStore.edgeUndirectedIterator(node));
    }

    @Override
    public EdgeIterable getEdges(Node node, int type) {
        return this.store.getEdgeIterableWrapper(this.store.edgeStore.edgeUndirectedIterator(node, type));
    }

    @Override
    public int getNodeCount() {
        return this.store.getNodeCount();
    }

    @Override
    public int getEdgeCount() {
        return this.store.edgeStore.undirectedSize();
    }

    @Override
    public int getEdgeCount(int type) {
        this.store.autoReadLock();
        try {
            if (this.store.edgeTypeStore.contains(type)) {
                int n = this.store.edgeStore.undirectedSize(type);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.store.autoReadUnlock();
        }
    }

    @Override
    public Node getOpposite(Node node, Edge edge) {
        return this.store.getOpposite(node, edge);
    }

    @Override
    public int getDegree(Node node) {
        return this.store.getUndirectedDegree(node);
    }

    @Override
    public boolean isSelfLoop(Edge edge) {
        return this.store.isSelfLoop(edge);
    }

    @Override
    public boolean isDirected(Edge edge) {
        return false;
    }

    @Override
    public boolean isAdjacent(Node node1, Node node2) {
        return this.store.isAdjacent(node1, node2);
    }

    @Override
    public boolean isAdjacent(Node node1, Node node2, int type) {
        return this.store.isAdjacent(node1, node2, type);
    }

    @Override
    public boolean isIncident(Edge edge1, Edge edge2) {
        return this.store.isIncident(edge1, edge2);
    }

    @Override
    public boolean isIncident(Node node, Edge edge) {
        return this.store.isIncident(node, edge);
    }

    @Override
    public void clearEdges(Node node) {
        this.store.clearEdges(node);
    }

    @Override
    public void clearEdges(Node node, int type) {
        this.store.clearEdges(node, type);
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public void clearEdges() {
        this.store.clearEdges();
    }

    @Override
    public Object getAttribute(String key) {
        return this.store.attributes.getValue(key);
    }

    @Override
    public Object getAttribute(String key, double timestamp) {
        return this.store.attributes.getValue(key, timestamp);
    }

    @Override
    public Object getAttribute(String key, Interval interval) {
        return this.store.attributes.getValue(key, interval);
    }

    @Override
    public Set<String> getAttributeKeys() {
        return this.store.attributes.getKeys();
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.store.attributes.setValue(key, value);
    }

    @Override
    public void setAttribute(String key, Object value, double timestamp) {
        this.store.attributes.setValue(key, value, timestamp);
    }

    @Override
    public void setAttribute(String key, Object value, Interval interval) {
        this.store.attributes.setValue(key, value, interval);
    }

    @Override
    public void removeAttribute(String key) {
        this.store.attributes.removeValue(key);
    }

    @Override
    public void removeAttribute(String key, Interval interval) {
        this.store.attributes.removeValue(key, interval);
    }

    @Override
    public void removeAttribute(String key, double timestamp) {
        this.store.attributes.removeValue(key, timestamp);
    }

    @Override
    public GraphView getView() {
        return this.store.mainGraphView;
    }

    @Override
    public void readLock() {
        this.store.autoReadLock();
    }

    @Override
    public void readUnlock() {
        this.store.autoReadUnlock();
    }

    @Override
    public void readUnlockAll() {
        this.store.autoReadUnlockAll();
    }

    @Override
    public void writeLock() {
        this.store.autoWriteLock();
    }

    @Override
    public void writeUnlock() {
        this.store.autoWriteUnlock();
    }

    @Override
    public GraphLockImpl getLock() {
        return this.store.getLock();
    }

    @Override
    public GraphModel getModel() {
        return this.store.graphModel;
    }

    @Override
    public int getVersion() {
        return this.store.getVersion();
    }

    @Override
    public boolean isDirected() {
        return false;
    }

    @Override
    public boolean isMixed() {
        return false;
    }

    @Override
    public boolean isUndirected() {
        return true;
    }

    @Override
    public void union(Subgraph subGraph) {
        throw new UnsupportedOperationException("Not supported yet for the main view.");
    }

    @Override
    public void intersection(Subgraph subGraph) {
        throw new UnsupportedOperationException("Not supported yet for the main view.");
    }

    @Override
    public void fill() {
        throw new UnsupportedOperationException("Not supported yet for the main view.");
    }

    @Override
    public void not() {
        throw new UnsupportedOperationException("Not supported yet for the main view.");
    }

    @Override
    public Graph getRootGraph() {
        return this;
    }
}

