/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.types.editors;

import java.awt.Color;
import java.beans.PropertyEditorSupport;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gephi.preview.types.DependantOriginalColor;

public class BasicDependantOriginalColorPropertyEditor
extends PropertyEditorSupport {
    @Override
    public String getAsText() {
        DependantOriginalColor c = (DependantOriginalColor)this.getValue();
        if (c.getMode().equals((Object)DependantOriginalColor.Mode.CUSTOM)) {
            Color color = c.getCustomColor() == null ? Color.BLACK : c.getCustomColor();
            return String.format("%s [%d,%d,%d]", c.getMode().name().toLowerCase(), color.getRed(), color.getGreen(), color.getBlue());
        }
        return c.getMode().name().toLowerCase();
    }

    @Override
    public void setAsText(String s) {
        if (this.matchColorMode(s, DependantOriginalColor.Mode.CUSTOM.name().toLowerCase())) {
            Pattern p = Pattern.compile("\\w+\\s*\\[\\s*(\\d+)\\s*,\\s*(\\d+)\\s*,\\s*(\\d+)\\s*\\]");
            Matcher m = p.matcher(s);
            if (m.lookingAt()) {
                int r = Integer.valueOf(m.group(1));
                int g = Integer.valueOf(m.group(2));
                int b = Integer.valueOf(m.group(3));
                this.setValue(new DependantOriginalColor(new Color(r, g, b)));
            }
        } else if (this.matchColorMode(s, DependantOriginalColor.Mode.ORIGINAL.name().toLowerCase())) {
            this.setValue(new DependantOriginalColor(DependantOriginalColor.Mode.ORIGINAL));
        } else if (this.matchColorMode(s, DependantOriginalColor.Mode.PARENT.name().toLowerCase())) {
            this.setValue(new DependantOriginalColor(DependantOriginalColor.Mode.PARENT));
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    private boolean matchColorMode(String s, String identifier) {
        String regexp = String.format("\\s*%s\\s*", identifier);
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(s);
        return m.lookingAt();
    }
}

