/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.preview.plugin.renderers;

import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfGState;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import org.gephi.graph.api.Node;
import org.gephi.preview.api.CanvasSize;
import org.gephi.preview.api.G2DTarget;
import org.gephi.preview.api.Item;
import org.gephi.preview.api.PDFTarget;
import org.gephi.preview.api.PreviewModel;
import org.gephi.preview.api.PreviewProperties;
import org.gephi.preview.api.PreviewProperty;
import org.gephi.preview.api.RenderTarget;
import org.gephi.preview.api.SVGTarget;
import org.gephi.preview.plugin.builders.NodeBuilder;
import org.gephi.preview.plugin.items.NodeItem;
import org.gephi.preview.spi.ItemBuilder;
import org.gephi.preview.spi.Renderer;
import org.gephi.preview.types.DependantColor;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;

public class NodeRenderer
implements Renderer {
    protected float defaultBorderWidth = 1.0f;
    protected DependantColor defaultBorderColor = new DependantColor(Color.BLACK);
    protected float defaultOpacity = 100.0f;

    public void preProcess(PreviewModel previewModel) {
    }

    public void render(Item item, RenderTarget target, PreviewProperties properties) {
        if (target instanceof G2DTarget) {
            this.renderG2D(item, (G2DTarget)target, properties);
        } else if (target instanceof SVGTarget) {
            this.renderSVG(item, (SVGTarget)target, properties);
        } else if (target instanceof PDFTarget) {
            this.renderPDF(item, (PDFTarget)target, properties);
        }
    }

    public CanvasSize getCanvasSize(Item item, PreviewProperties properties) {
        float x = ((Float)item.getData("x")).floatValue();
        float y = ((Float)item.getData("y")).floatValue();
        float s = ((Float)item.getData("size")).floatValue() + properties.getFloatValue("node.border.width");
        float r = s / 2.0f;
        int intS = Math.round(s);
        return new CanvasSize((float)Math.round(x - r), (float)Math.round(y - r), (float)intS, (float)intS);
    }

    public void renderG2D(Item item, G2DTarget target, PreviewProperties properties) {
        Float x = (Float)item.getData("x");
        Float y = (Float)item.getData("y");
        Float size = (Float)item.getData("size");
        Color color = (Color)item.getData("color");
        Color borderColor = ((DependantColor)properties.getValue("node.border.color")).getColor(color);
        float borderSize = properties.getFloatValue("node.border.width");
        int alpha = (int)(properties.getFloatValue("node.opacity") / 100.0f * 255.0f);
        if (alpha < 0) {
            alpha = 0;
        }
        if (alpha > 255) {
            alpha = 255;
        }
        Graphics2D graphics = target.getGraphics();
        x = Float.valueOf(x.floatValue() - size.floatValue() / 2.0f);
        y = Float.valueOf(y.floatValue() - size.floatValue() / 2.0f);
        Ellipse2D.Float ellipse = new Ellipse2D.Float(x.floatValue(), y.floatValue(), size.floatValue(), size.floatValue());
        if (borderSize > 0.0f) {
            graphics.setColor(new Color(borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue(), alpha));
            graphics.setStroke(new BasicStroke(borderSize));
            graphics.draw(ellipse);
        }
        graphics.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), alpha));
        graphics.fill(ellipse);
    }

    public void renderSVG(Item item, SVGTarget target, PreviewProperties properties) {
        Node node = (Node)item.getSource();
        Float x = (Float)item.getData("x");
        Float y = (Float)item.getData("y");
        Float size = (Float)item.getData("size");
        size = Float.valueOf(size.floatValue() / 2.0f);
        Color color = (Color)item.getData("color");
        Color borderColor = ((DependantColor)properties.getValue("node.border.color")).getColor(color);
        float borderSize = properties.getFloatValue("node.border.width");
        float alpha = properties.getFloatValue("node.opacity") / 100.0f;
        if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        Element nodeElem = target.createElement("circle");
        nodeElem.setAttribute("class", node.getId().toString());
        nodeElem.setAttribute("cx", x.toString());
        nodeElem.setAttribute("cy", y.toString());
        nodeElem.setAttribute("r", size.toString());
        nodeElem.setAttribute("fill", target.toHexString(color));
        nodeElem.setAttribute("fill-opacity", "" + alpha);
        if (borderSize > 0.0f) {
            nodeElem.setAttribute("stroke", target.toHexString(borderColor));
            nodeElem.setAttribute("stroke-width", Float.toString(borderSize * target.getScaleRatio()));
            nodeElem.setAttribute("stroke-opacity", "" + alpha);
        }
        target.getTopElement("nodes").appendChild(nodeElem);
    }

    public void renderPDF(Item item, PDFTarget target, PreviewProperties properties) {
        Float x = (Float)item.getData("x");
        Float y = (Float)item.getData("y");
        Float size = (Float)item.getData("size");
        size = Float.valueOf(size.floatValue() / 2.0f);
        Color color = (Color)item.getData("color");
        Color borderColor = ((DependantColor)properties.getValue("node.border.color")).getColor(color);
        float borderSize = properties.getFloatValue("node.border.width");
        float alpha = properties.getFloatValue("node.opacity") / 100.0f;
        PdfContentByte cb = target.getContentByte();
        cb.setRGBColorStroke(borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue());
        cb.setLineWidth(borderSize);
        cb.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
        if (alpha < 1.0f) {
            cb.saveState();
            PdfGState gState = new PdfGState();
            gState.setFillOpacity(alpha);
            gState.setStrokeOpacity(alpha);
            cb.setGState(gState);
        }
        cb.circle(x.floatValue(), -y.floatValue(), size.floatValue());
        if (borderSize > 0.0f) {
            cb.fillStroke();
        } else {
            cb.fill();
        }
        if (alpha < 1.0f) {
            cb.restoreState();
        }
    }

    public PreviewProperty[] getProperties() {
        return new PreviewProperty[]{PreviewProperty.createProperty((Object)this, (String)"node.border.width", Float.class, (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.borderWidth.displayName"), (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.borderWidth.description"), (String)PreviewProperty.CATEGORY_NODES).setValue((Object)Float.valueOf(this.defaultBorderWidth)), PreviewProperty.createProperty((Object)this, (String)"node.border.color", DependantColor.class, (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.borderColor.displayName"), (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.borderColor.description"), (String)PreviewProperty.CATEGORY_NODES).setValue((Object)this.defaultBorderColor), PreviewProperty.createProperty((Object)this, (String)"node.opacity", Float.class, (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.opacity.displayName"), (String)NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.property.opacity.description"), (String)PreviewProperty.CATEGORY_NODES).setValue((Object)Float.valueOf(this.defaultOpacity))};
    }

    private boolean showNodes(PreviewProperties properties) {
        return properties.getFloatValue("node.opacity") > 0.0f;
    }

    public boolean isRendererForitem(Item item, PreviewProperties properties) {
        return item instanceof NodeItem && this.showNodes(properties);
    }

    public boolean needsItemBuilder(ItemBuilder itemBuilder, PreviewProperties properties) {
        return itemBuilder instanceof NodeBuilder && this.showNodes(properties);
    }

    public String getDisplayName() {
        return NbBundle.getMessage(NodeRenderer.class, (String)"NodeRenderer.name");
    }
}

