/*
 * Decompiled with CFR 0.152.
 */
package org.lantern;

import java.io.IOException;
import java.util.Map;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;
import org.codehaus.jackson.map.SerializationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonUtils {
    private static final Logger LOG = LoggerFactory.getLogger(JsonUtils.class);

    public static String jsonify(Object all) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        try {
            return mapper.writeValueAsString(all);
        }
        catch (JsonGenerationException e) {
            LOG.warn("Error generating JSON", (Throwable)e);
        }
        catch (JsonMappingException e) {
            LOG.warn("Error generating JSON", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn("Error generating JSON", (Throwable)e);
        }
        return "";
    }

    public static String jsonify(Object all, Class<?> view) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationConfig.Feature.INDENT_OUTPUT, true);
        ObjectWriter writer = mapper.writerWithView(view);
        try {
            return writer.writeValueAsString(all);
        }
        catch (JsonGenerationException e) {
            LOG.warn("Error generating JSON", (Throwable)e);
        }
        catch (JsonMappingException e) {
            LOG.warn("Error generating JSON", (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn("Error generating JSON", (Throwable)e);
        }
        return "";
    }

    public static String getValueFromJson(String key, String json) {
        ObjectMapper om = new ObjectMapper();
        try {
            Map map = (Map)om.readValue(json, Map.class);
            return (String)map.get(key);
        }
        catch (JsonGenerationException e) {
            LOG.warn("Error getting JSON string: " + json, (Throwable)e);
        }
        catch (JsonMappingException e) {
            LOG.warn("Error getting JSON string: " + json, (Throwable)e);
        }
        catch (IOException e) {
            LOG.warn("Error getting JSON string: " + json, (Throwable)e);
        }
        return "";
    }
}

