/*
 * Decompiled with CFR 0.152.
 */
package org.lantern;

import java.io.Serializable;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.lantern.VersionNumberDeserializer;
import org.lantern.VersionNumberSerializer;

@JsonSerialize(using=VersionNumberSerializer.class)
@JsonDeserialize(using=VersionNumberDeserializer.class)
public class VersionNumber
implements Serializable,
Comparable<Object> {
    private static final long serialVersionUID = -9030368123761098914L;
    private final int[] components;

    public VersionNumber(String number) {
        String[] parts = number.split("\\.");
        this.components = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            this.components[i] = Integer.parseInt(parts[i]);
        }
    }

    public int getMajor() {
        return this.getComponentOrZero(0);
    }

    public int getMinor() {
        return this.getComponentOrZero(1);
    }

    public int getPatch() {
        return this.getComponentOrZero(2);
    }

    public int getComponentOrZero(int component) {
        if (this.components.length > component) {
            return this.components[component];
        }
        return 0;
    }

    public String toString() {
        String out = "";
        for (int i = 0; i < this.components.length - 1; ++i) {
            out = out + this.components[i];
            out = out + ".";
        }
        out = out + this.components[this.components.length - 1];
        return out;
    }

    @Override
    public int compareTo(Object other) {
        VersionNumber vn;
        if (other instanceof String) {
            vn = new VersionNumber((String)other);
        } else if (other instanceof VersionNumber) {
            vn = (VersionNumber)other;
        } else {
            throw new RuntimeException("Cannot compare " + other + " to VersionNumber");
        }
        int mostComponents = Math.max(this.components.length, vn.components.length);
        for (int i = 0; i < mostComponents; ++i) {
            int diff = this.getComponentOrZero(i) - vn.getComponentOrZero(i);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof VersionNumber)) {
            return false;
        }
        VersionNumber vnOther = (VersionNumber)other;
        return this.compareTo(vnOther) == 0;
    }

    public int hashCode() {
        int x = 0;
        for (int i = 0; i < 5; ++i) {
            x *= 100;
            x += this.getComponentOrZero(i);
        }
        return x;
    }
}

