/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.rewriter.service.rs;

import java.io.Serializable;
import javax.ejb.LocalBean;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.giavacms.rewriter.service.CacheService;
import org.jboss.logging.Logger;

@Path(value="/v1/writer")
@Stateless
@LocalBean
public class FileSystemWriter
implements Serializable {
    private static final long serialVersionUID = 1L;
    Logger logger = Logger.getLogger((String)this.getClass().getCanonicalName());
    @Inject
    CacheService cahCacheService;

    @GET
    @Path(value="/write/{page}")
    @Produces(value={"text/plain"})
    public String write(@PathParam(value="page") String pageId) {
        return this.cahCacheService.write(pageId);
    }

    @GET
    @Path(value="/writeAll")
    @Produces(value={"text/plain"})
    public String writeAll() {
        return this.cahCacheService.writeAll();
    }

    @GET
    @Path(value="/writeByTemplateId/{id}")
    @Produces(value={"text/plain"})
    public String writeByTemplate(@PathParam(value="id") Long id) {
        return this.cahCacheService.writeByTemplate(id);
    }

    @GET
    @Path(value="/clear/{page}")
    @Produces(value={"text/plain"})
    public String clear(@PathParam(value="page") String page) {
        return this.cahCacheService.clear(page);
    }

    @GET
    @Path(value="/clearAll")
    @Produces(value={"text/plain"})
    public String clearAll() {
        return this.cahCacheService.clearAll();
    }

    @GET
    @Path(value="/clearByTemplateId/{id}")
    @Produces(value={"text/plain"})
    public String clearByTemplateId(@PathParam(value="id") Long id) {
        return this.cahCacheService.clearByTemplateId(id);
    }
}

