/*
 * Decompiled with CFR 0.152.
 */
package org.giavacms.githubcontent.controller;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.giavacms.base.common.util.ResourceUtils;
import org.giavacms.base.controller.AbstractPageController;
import org.giavacms.base.model.attachment.Image;
import org.giavacms.common.annotation.BackPage;
import org.giavacms.common.annotation.EditPage;
import org.giavacms.common.annotation.ListPage;
import org.giavacms.common.annotation.OwnRepository;
import org.giavacms.common.annotation.ViewPage;
import org.giavacms.common.event.ResetEvent;
import org.giavacms.common.model.Group;
import org.giavacms.common.model.Search;
import org.giavacms.githubcontent.model.GithubContentType;
import org.giavacms.githubcontent.repository.GithubContentTypeRepository;
import org.giavacms.githubcontent.util.GithubImporter;
import org.giavacms.richcontent.model.RichContent;
import org.giavacms.richcontent.model.Tag;
import org.giavacms.richcontent.model.type.RichContentType;
import org.giavacms.richcontent.repository.RichContentRepository;
import org.giavacms.richcontent.repository.RichContentTypeRepository;
import org.giavacms.richcontent.repository.TagRepository;
import org.primefaces.event.FileUploadEvent;

@Named
@SessionScoped
public class GithubContentController
extends AbstractPageController<RichContent> {
    private static final long serialVersionUID = 1L;
    @BackPage
    public static String BACK = "/private/administration.xhtml";
    @ViewPage
    public static String VIEW = "/private/githubcontent/view.xhtml";
    @ListPage
    public static String LIST = "/private/githubcontent/list.xhtml";
    @EditPage
    public static String NEW_OR_EDIT = "/private/githubcontent/edit-url.xhtml";
    public static String EDIT_IMAGE = "/private/githubcontent/edit-image.xhtml";
    @Inject
    @OwnRepository(value=RichContentRepository.class)
    RichContentRepository richContentRepository;
    @Inject
    RichContentTypeRepository richContentTypeRepository;
    @Inject
    GithubContentTypeRepository githubContentTypeRepository;
    @Inject
    TagRepository tagRepository;
    private List<Group<Tag>> githubTags;
    private String githubContent = null;

    public String getExtension() {
        return "RichContent";
    }

    public void defaultCriteria() {
        List githubTypes = this.githubContentTypeRepository.getAllList();
        if (githubTypes != null && githubTypes.size() > 0) {
            ((RichContent)this.getSearch().getObj()).setRichContentType(new RichContentType());
            ((RichContent)this.getSearch().getObj()).getRichContentType().setId(((GithubContentType)githubTypes.get(0)).getRichContentType().getId());
        }
        super.defaultCriteria();
    }

    public void filterTag(String tagName) {
        ((RichContent)this.getSearch().getObj()).setTag(tagName);
        this.refreshModel();
    }

    @Produces
    @Named
    public List<Group<Tag>> getGithubTags() {
        if (this.githubTags == null) {
            if (((RichContent)this.getSearch().getObj()).getRichContentType() != null && ((RichContent)this.getSearch().getObj()).getRichContentType().getId() != null) {
                Search st = new Search(Tag.class);
                st.setGrouping("tagName");
                ((Tag)st.getObj()).setRichContent((RichContent)this.getSearch().getObj());
                this.githubTags = this.tagRepository.getGroups(st, 0, 50);
            } else {
                this.githubTags = new ArrayList<Group<Tag>>();
            }
        }
        return this.githubTags;
    }

    public void observeReset(@Observes ResetEvent resetEvent) {
        if (resetEvent.getObservedClass().equals(RichContent.class)) {
            this.githubTags = null;
        }
    }

    public String reload() {
        this.githubTags = null;
        this.githubContent = null;
        return super.reload();
    }

    public String reset() {
        this.githubTags = null;
        this.githubContent = null;
        return super.reset();
    }

    public String addElement() {
        this.githubTags = null;
        this.githubContent = null;
        String outcome = super.addElement();
        ((RichContent)this.getElement()).setDate(new Date());
        return outcome;
    }

    public String save() {
        ((RichContent)this.getElement()).setTemplate(((RichContentType)this.richContentTypeRepository.find((Object)((RichContent)this.getElement()).getRichContentType().getId())).getPage().getTemplate());
        if (super.save() == null) {
            super.addFacesMessage("Errori nel salvataggio");
            return null;
        }
        this.tagRepository.set(((RichContent)this.getElement()).getId(), ((RichContent)this.getElement()).getTagList(), ((RichContent)this.getElement()).getDate());
        return this.modImageCurrent();
    }

    public String modImageCurrent() {
        this.modCurrent();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String modImage() {
        this.modElement();
        return EDIT_IMAGE + "?faces-redirect=true";
    }

    public String update() {
        ((RichContent)this.getElement()).setTemplate(((RichContentType)this.richContentTypeRepository.find((Object)((RichContent)this.getElement()).getRichContentType().getId())).getPage().getTemplate());
        if (super.update() == null) {
            super.addFacesMessage("Errori nell'aggiornamento dei dati");
            return null;
        }
        this.tagRepository.set(((RichContent)this.getElement()).getId(), ((RichContent)this.getElement()).getTagList(), ((RichContent)this.getElement()).getDate());
        return this.viewCurrent();
    }

    public String delete() {
        this.githubContent = null;
        return super.delete();
    }

    public void handleUpload(FileUploadEvent event) {
        this.logger.info((Object)("Uploaded: " + event.getFile().getFileName() + " - " + event.getFile().getContentType() + "- " + event.getFile().getSize()));
        try {
            if (((RichContent)this.getElement()).getImages() != null && ((RichContent)this.getElement()).getImages().size() > 0) {
                this.removeImage(((Image)((RichContent)this.getElement()).getImages().get(0)).getId());
            }
            byte[] imgRes = event.getFile().getContents();
            Image img = new Image();
            img.setUploadedData(event.getFile());
            img.setData(imgRes);
            img.setType(event.getFile().getContentType());
            String filename = ResourceUtils.createImage_((String)"img", (String)event.getFile().getFileName(), (byte[])imgRes);
            img.setFilename(filename);
            ((RichContent)this.getElement()).getImages().add(img);
        }
        catch (Exception e) {
            super.addFacesMessage("Errori nel salvataggio dell'immagine");
            e.printStackTrace();
        }
        this.update();
    }

    public String removeImage(Long id) {
        if (id != null && this.getElement() != null && ((RichContent)this.getElement()).getImages() != null && ((RichContent)this.getElement()).getImages().size() > 0) {
            ArrayList<Image> imagesNew = new ArrayList<Image>();
            for (Image img : ((RichContent)this.getElement()).getImages()) {
                if (img.getId() == null || img.getId().equals(id)) continue;
                imagesNew.add(img);
            }
            ((RichContent)this.getElement()).setImages(imagesNew);
            this.richContentRepository.update(this.getElement());
        } else {
            super.addFacesMessage("Errori nella rimozione dell'immagine precedente");
            this.logger.warn((Object)("removeImage: non posso rimuovere id:" + id));
        }
        return this.viewCurrent();
    }

    public String getGithubContent() {
        return this.githubContent;
    }

    public void setGithubContent(String githubContent) {
        this.githubContent = githubContent;
    }

    public String viewElement() {
        String outcome = super.viewElement();
        this.githubContent = GithubImporter.getContent(((RichContent)this.getElement()).getContent());
        return outcome;
    }

    public String viewCurrent() {
        String outcome = super.viewCurrent();
        this.githubContent = GithubImporter.getContent(((RichContent)this.getElement()).getContent());
        return outcome;
    }

    public String modCurrent() {
        String outcome = super.modCurrent();
        this.githubContent = GithubImporter.getContent(((RichContent)this.getElement()).getContent());
        return outcome;
    }
}

