/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab4j.api;

import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Response;
import java.util.Date;
import java.util.List;
import org.gitlab4j.api.AbstractApi;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.GitLabApiException;
import org.gitlab4j.api.GitLabApiForm;
import org.gitlab4j.api.models.PersonalAccessToken;
import org.gitlab4j.models.utils.ISO8601;

public class PersonalAccessTokenApi
extends AbstractApi {
    public PersonalAccessTokenApi(GitLabApi gitLabApi) {
        super(gitLabApi);
    }

    public PersonalAccessToken rotatePersonalAccessToken() throws GitLabApiException {
        return this.rotatePersonalAccessToken(null);
    }

    public PersonalAccessToken rotatePersonalAccessToken(Date expiresAt) throws GitLabApiException {
        return this.rotatePersonalAccessToken("self", expiresAt);
    }

    public PersonalAccessToken rotatePersonalAccessToken(String id, Date expiresAt) throws GitLabApiException {
        GitLabApiForm formData = new GitLabApiForm().withParam("expires_at", ISO8601.dateOnly((Date)expiresAt));
        Response response = this.post(Response.Status.OK, (Form)formData, new Object[]{"personal_access_tokens", id, "rotate"});
        return (PersonalAccessToken)response.readEntity(PersonalAccessToken.class);
    }

    public List<PersonalAccessToken> getPersonalAccessTokens() throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "personal_access_tokens");
        return (List)response.readEntity((GenericType)new GenericType<List<PersonalAccessToken>>(){});
    }

    public PersonalAccessToken getPersonalAccessToken() throws GitLabApiException {
        return this.getPersonalAccessToken("self");
    }

    public PersonalAccessToken getPersonalAccessToken(String id) throws GitLabApiException {
        Response response = this.get(Response.Status.OK, null, "personal_access_tokens", id);
        return (PersonalAccessToken)response.readEntity(PersonalAccessToken.class);
    }

    public void revokePersonalAccessToken(Long tokenId) throws GitLabApiException {
        if (tokenId == null) {
            throw new RuntimeException("tokenId cannot be null");
        }
        Response.Status expectedStatus = this.isApiVersion(GitLabApi.ApiVersion.V3) ? Response.Status.OK : Response.Status.NO_CONTENT;
        this.delete(expectedStatus, null, "personal_access_tokens", tokenId);
    }
}

