/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest;

import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.glassfish.admin.rest.RestConfig;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Singleton;

@Service
@Scoped(value=Singleton.class)
public class SessionManager {
    @Inject
    private Habitat habitat;
    private RestConfig restConfig = null;
    private final SecureRandom randomGenerator = new SecureRandom();
    private Map<String, SessionData> activeSessions = new ConcurrentHashMap<String, SessionData>();

    public String createSession(GrizzlyRequest req) {
        String sessionId;
        while (this.isSessionExist(sessionId = new BigInteger(130, this.randomGenerator).toString(16))) {
        }
        this.saveSession(sessionId, req);
        return sessionId;
    }

    public boolean authenticate(String sessionId, GrizzlyRequest req) {
        SessionData sessionData;
        boolean authenticated = false;
        this.purgeInactiveSessions();
        if (sessionId != null && (sessionData = this.activeSessions.get(sessionId)) != null) {
            authenticated = sessionData.authenticate(req);
            if (authenticated) {
                sessionData.updateLastAccessTime();
            } else {
                this.activeSessions.remove(sessionId);
            }
        }
        return authenticated;
    }

    public boolean deleteSession(String sessionId) {
        boolean sessionDeleted = false;
        if (sessionId != null) {
            SessionData removedSession = this.activeSessions.remove(sessionId);
            sessionDeleted = removedSession != null;
        }
        return sessionDeleted;
    }

    private void saveSession(String sessionId, GrizzlyRequest req) {
        this.purgeInactiveSessions();
        this.activeSessions.put(sessionId, new SessionData(sessionId, req));
    }

    private void purgeInactiveSessions() {
        Set<Map.Entry<String, SessionData>> activeSessionsSet = this.activeSessions.entrySet();
        for (Map.Entry<String, SessionData> entry : activeSessionsSet) {
            if (entry.getValue().isSessionActive()) continue;
            activeSessionsSet.remove(entry);
        }
    }

    private RestConfig getRestConfig() {
        Config config;
        Domain domain;
        if (this.restConfig == null && (domain = (Domain)this.habitat.getComponent(Domain.class)) != null && (config = domain.getConfigNamed("server-config")) != null) {
            this.restConfig = (RestConfig)config.getExtensionByType(RestConfig.class);
        }
        return this.restConfig;
    }

    private boolean isSessionExist(String sessionId) {
        return this.activeSessions.containsKey(sessionId);
    }

    private class SessionData {
        private String clientAddress;
        private long lastAccessedTime = System.currentTimeMillis();
        private final String DISABLE_REMOTE_ADDRESS_VALIDATION_PROPERTY_NAME = "org.glassfish.admin.rest.disable.remote.address.validation";
        private final boolean disableRemoteAddressValidation = Boolean.getBoolean("org.glassfish.admin.rest.disable.remote.address.validation");

        public SessionData(String sessionId, GrizzlyRequest req) {
            this.clientAddress = req.getRemoteAddr();
        }

        public boolean isSessionActive() {
            long inactiveSessionLifeTime = 1800000L;
            RestConfig restConfig = SessionManager.this.getRestConfig();
            if (restConfig != null) {
                inactiveSessionLifeTime = Integer.parseInt(restConfig.getSessionTokenTimeout()) * 60000;
            }
            return this.lastAccessedTime + inactiveSessionLifeTime > System.currentTimeMillis();
        }

        public void updateLastAccessTime() {
            this.lastAccessedTime = System.currentTimeMillis();
        }

        public boolean authenticate(GrizzlyRequest req) {
            return this.isSessionActive() && (this.clientAddress.equals(req.getRemoteAddr()) || this.disableRemoteAddressValidation);
        }
    }
}

