/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.annotation.processing.logging;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import javax.annotation.processing.AbstractProcessor;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.glassfish.annotation.processing.logging.LoggingMetadata;

public abstract class BaseLoggingProcessor
extends AbstractProcessor {
    protected void debug(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, msg);
    }

    protected void debug(String msg, Throwable t) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.OTHER, t.getMessage() + ":" + msg);
    }

    protected void info(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, this.getClass().getName() + ": " + msg);
    }

    protected void warn(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, this.getClass().getName() + ": " + msg);
    }

    protected void warn(String msg, Throwable t) {
        String errMsg = msg + ": " + t.getMessage();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, this.getClass().getName() + ": " + errMsg);
    }

    protected void error(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.getClass().getName() + ": " + msg);
    }

    protected void error(String msg, Throwable t) {
        String errMsg = msg + ": " + t.getMessage();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, this.getClass().getName() + ": " + errMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadLogMessages(LoggingMetadata lrb, String rbName) {
        BufferedReader bufferedReader = null;
        try {
            FileObject rbFileObject = this.getRBFileObject(rbName, true);
            if (rbFileObject.getLastModified() > 0L) {
                bufferedReader = new BufferedReader(new InputStreamReader(rbFileObject.openInputStream()));
                lrb.load(bufferedReader);
            }
        }
        catch (IllegalArgumentException e) {
            this.error("Unable to load resource bundle: " + rbName, e);
        }
        catch (IOException e) {
            this.debug("Unable to load resource bundle: " + rbName, e);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException e) {
                    this.error("Unable to close reader for resource bundle: " + rbName, e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeLogMessages(LoggingMetadata lrb, String rbName) {
        BufferedWriter bufferedWriter = null;
        try {
            FileObject rbFileObject = this.getRBFileObject(rbName, false);
            bufferedWriter = new BufferedWriter(new OutputStreamWriter(rbFileObject.openOutputStream()));
            lrb.store(bufferedWriter);
        }
        catch (IllegalArgumentException e) {
            this.error("Unable to store resource bundle: " + rbName, e);
        }
        catch (IOException e) {
            this.error("Unable to store resource bundle: " + rbName, e);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    this.error("Unable to store resource bundle: " + rbName, e);
                }
            }
        }
    }

    private FileObject getRBFileObject(String rbName, boolean readObject) throws IllegalArgumentException, IOException {
        Object rbFileName = rbName;
        String rbPkg = "";
        int lastIndex = rbName.lastIndexOf(46);
        if (lastIndex > 0) {
            rbFileName = rbName.substring(lastIndex + 1);
            rbPkg = rbName.substring(0, lastIndex);
        }
        rbFileName = (String)rbFileName + ".properties";
        if (readObject) {
            return this.processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, rbPkg, (CharSequence)rbFileName);
        }
        return this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, rbPkg, (CharSequence)rbFileName, null);
    }
}

