/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.annotation.processing.logging;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Pattern;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.glassfish.annotation.processing.logging.BaseLoggingProcessor;
import org.glassfish.annotation.processing.logging.LoggingMetadata;
import org.glassfish.logging.annotation.LoggerInfo;

@SupportedAnnotationTypes(value={"org.glassfish.logging.annotation.LoggerInfo"})
public class LoggerInfoMetadataGenerator
extends BaseLoggingProcessor {
    private static final String PUBLISH_SUFFIX = ".publish";
    private static final String SUBSYSTEM_SUFFIX = ".subsystem";
    private static final String DESCRIPTION_SUFFIX = ".description";
    private static final String RBNAME = "META-INF/loggerinfo/LoggerInfoMetadata";
    private static final String VALID_PATTERN = "[a-z[A-Z]][^|]*";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        this.debug("LoggerInfoMetadataGenerator invoked.");
        LoggingMetadata loggerMetadata = new LoggingMetadata();
        this.loadLogMessages(loggerMetadata, RBNAME);
        this.debug("Total Messages including ones found from disk so far: " + loggerMetadata);
        if (!env.processingOver()) {
            TreeMap<String, VariableElement> loggerInfoElements = new TreeMap<String, VariableElement>();
            Set<? extends Element> elements = env.getElementsAnnotatedWith(LoggerInfo.class);
            if (elements.isEmpty()) {
                return false;
            }
            for (VariableElement variableElement : elements) {
                String loggerName = (String)variableElement.getConstantValue();
                if (loggerName == null) {
                    StringBuffer buf = new StringBuffer();
                    buf.append("Logger name must be a constant string literal value, it cannot be a compile time computed expression.");
                    buf.append(System.getProperty("line.separator"));
                    buf.append("Please check if the LoggerInfo annotation is on the logger name constant.");
                    this.error(buf.toString());
                    return false;
                }
                this.debug("Processing: " + loggerName + " on element " + variableElement.getSimpleName());
                this.debug("Enclosing type is " + variableElement.getEnclosingElement().asType());
                LoggerInfo loggerInfo = variableElement.getAnnotation(LoggerInfo.class);
                this.validateLoggerInfo(loggerInfo);
                if (loggerInfoElements.containsKey(loggerName)) {
                    LoggerInfo prevLoggerInfo = ((Element)loggerInfoElements.get(loggerName)).getAnnotation(LoggerInfo.class);
                    if (this.compareLoggerInfos(loggerInfo, prevLoggerInfo)) continue;
                    this.warn("Overwriting entry for logger " + loggerName);
                    continue;
                }
                this.renderLoggerInfo(loggerMetadata, loggerName, loggerInfo);
                loggerInfoElements.put(loggerName, variableElement);
            }
            this.debug("Loggers found so far: " + loggerMetadata);
            this.info("Generating logger metadata service.");
            Element element = (Element)loggerInfoElements.get(loggerInfoElements.firstKey());
            boolean result = this.generateLoggerInfoMetadataService(element, loggerMetadata);
            this.info("Annotation processing finished successfully.");
            return result;
        }
        return false;
    }

    private boolean compareLoggerInfos(LoggerInfo info1, LoggerInfo info2) {
        return info1.description().equals(info2.description()) && info1.subsystem().equals(info2.subsystem()) && info1.publish() == info2.publish();
    }

    private void validateLoggerInfo(LoggerInfo loggerInfo) {
        if (!Pattern.matches(VALID_PATTERN, loggerInfo.subsystem())) {
            this.error("Subsystem name is not valid: " + loggerInfo.subsystem());
        }
        if (!Pattern.matches(VALID_PATTERN, loggerInfo.description())) {
            this.error("Description for the Logger is not valid: " + loggerInfo.description());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateLoggerInfoMetadataService(Element element, LoggingMetadata loggerInfos) {
        String packageName = null;
        do {
            Element enclosing = element.getEnclosingElement();
            this.debug("Found enclosing element " + element);
            if (enclosing.getKind() == ElementKind.PACKAGE) {
                packageName = enclosing.toString();
            }
            element = enclosing;
        } while (packageName == null);
        BufferedWriter bufferedWriter = null;
        try {
            String resourceName = RBNAME;
            this.storeLogMessages(loggerInfos, resourceName);
        }
        catch (Exception e) {
            this.error("Unable to generate LoggerMetadataInfoService class", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException e) {
                    this.error("Unable to close LoggerMetadataInfoService writer", e);
                }
            }
        }
        return true;
    }

    private boolean renderLoggerInfo(LoggingMetadata loggerMetadata, String loggerName, LoggerInfo loggerInfo) {
        loggerMetadata.put(loggerName + DESCRIPTION_SUFFIX, loggerInfo.description());
        loggerMetadata.put(loggerName + SUBSYSTEM_SUFFIX, loggerInfo.subsystem());
        loggerMetadata.put(loggerName + PUBLISH_SUFFIX, loggerInfo.publish());
        return true;
    }
}

