/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.annotation.processing.logging;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.TreeMap;
import org.glassfish.annotation.processing.logging.GPLCopyright;

class LoggingMetadata
extends TreeMap<String, Object> {
    private static final long serialVersionUID = 4958871376396137141L;
    private static final String COMMENT = ".MSG_COMMENT";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingMetadata load(BufferedReader reader) throws IOException {
        String unusedLine = null;
        try {
            String line;
            while ((line = this.nextLine(unusedLine, reader)) != null) {
                int pos;
                unusedLine = null;
                if (line.indexOf(35) == 0) {
                    String commentLine = line;
                    line = reader.readLine();
                    if (line == null) continue;
                    pos = line.indexOf(35);
                    if (line.indexOf(35) == 0) {
                        unusedLine = line;
                        continue;
                    }
                    pos = line.indexOf(61);
                    if (pos == -1) {
                        unusedLine = line;
                        continue;
                    }
                    unusedLine = null;
                    this.setProperty(line, pos, commentLine);
                    continue;
                }
                pos = line.indexOf(61);
                if (pos == -1) continue;
                this.setProperty(line, pos);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return this;
    }

    public boolean store(Writer out) throws IOException {
        if (this.isEmpty()) {
            return false;
        }
        out.write(GPLCopyright.getCopyright());
        for (String key : this.keySet()) {
            Object value;
            if (key.endsWith(COMMENT)) continue;
            if (this.containsKey(key + COMMENT)) {
                out.write(this.get(key + COMMENT) + "\n");
            }
            value = (value = this.get(key)) != null ? this.escapeSpecialChars(value.toString()) : "";
            out.write(key + "=" + value + "\n\n");
        }
        out.flush();
        return true;
    }

    private String escapeSpecialChars(String str) {
        return str.replaceAll("\\n", "\\\\n");
    }

    public void putComment(String key, String comment) {
        this.put(key + COMMENT, "# " + comment);
    }

    private void setProperty(String line, int pos, String commentLine) {
        String key = line.substring(0, pos).trim();
        String value = line.substring(pos + 1).trim();
        this.put(key, value);
        this.put(key + COMMENT, commentLine);
    }

    private void setProperty(String line, int pos) {
        String key = line.substring(0, pos).trim();
        String value = line.substring(pos + 1).trim();
        this.put(key, value);
    }

    private String nextLine(String unusedLine, BufferedReader reader) throws IOException {
        if (unusedLine != null) {
            return unusedLine;
        }
        return reader.readLine();
    }
}

