/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.annotation.processing.logging;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.glassfish.annotation.processing.logging.BaseLoggingProcessor;
import org.glassfish.annotation.processing.logging.LoggingMetadata;
import org.glassfish.logging.annotation.LogMessageInfo;
import org.glassfish.logging.annotation.LogMessagesResourceBundle;

@SupportedAnnotationTypes(value={"org.glassfish.logging.annotation.LogMessageInfo", "org.glassfish.logging.annotation.LogMessagesResourceBundle"})
public class LogMessagesResourceBundleGenerator
extends BaseLoggingProcessor {
    private static final String DETAILS_SUFFIX = "_details";
    private static final String RESOURCE_BUNDLE_KEY = "resourceBundle";
    private static final String[] VALIDATE_LEVELS = new String[]{"EMERGENCY", "ALERT", "SEVERE"};
    private static final String LOG_MESSAGES_METADATA = "META-INF/logmessages/LogMessagesMetadata";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment env) {
        this.debug("LogMessagesResourceBundleGenerator invoked.");
        if (!env.processingOver()) {
            LoggingMetadata logMessagesMap = new LoggingMetadata();
            LoggingMetadata logMessagesDetails = new LoggingMetadata();
            LoggingMetadata logMessagesMetada = new LoggingMetadata();
            Set<? extends Element> logMessageElements = env.getElementsAnnotatedWith(LogMessageInfo.class);
            Set<? extends Element> logMessagesResourceBundleElements = env.getElementsAnnotatedWith(LogMessagesResourceBundle.class);
            HashSet<String> rbNames = new HashSet<String>();
            if (logMessagesResourceBundleElements.isEmpty() || logMessageElements.isEmpty()) {
                this.loadLogMessages(logMessagesMetada, LOG_MESSAGES_METADATA);
                if (logMessagesMetada.containsKey(RESOURCE_BUNDLE_KEY)) {
                    String rb = (String)logMessagesMetada.get(RESOURCE_BUNDLE_KEY);
                    if (rb != null && !rb.isEmpty()) {
                        rbNames.add(rb);
                    }
                } else {
                    this.warn("Skipping LogMessages resource bundle generation, either the LogMessageInfo or LogMessagesResourceBundle annotation is not specified in the current compilation round.");
                    return false;
                }
            }
            for (Element element : logMessagesResourceBundleElements) {
                if (!(element instanceof VariableElement)) {
                    this.error("The LogMessagesResourceBundle annotation is applied on an invalid element.");
                    return false;
                }
                Object rbValue = ((VariableElement)element).getConstantValue();
                if (rbValue == null) {
                    this.error("The resource bundle name value could not be computed. Specify the LogMessagesResourceBundle annotation only on a compile time constant String literal field in the class.");
                    return false;
                }
                rbNames.add(rbValue.toString());
            }
            if (rbNames.isEmpty()) {
                this.error("No resource bundle name found. Atleast one String literal constant needs to be decorated with the LogMessagesResourceBundle annotation.");
                return false;
            }
            if (rbNames.size() > 1) {
                this.error("More than one resource bundle name specified. Found the following resource bundle names: " + rbNames + ". Please specify only one resource bundle name per module.");
                return false;
            }
            String rbName = (String)rbNames.iterator().next();
            if (!rbName.endsWith("LogMessages")) {
                this.error("The resource bundle name '" + rbName + "' annotated by @LogMessagesResourceBundle does not end with 'LogMessages'");
                return false;
            }
            Iterator<? extends Element> iterator = logMessageElements.iterator();
            HashSet<String> messageIds = new HashSet<String>();
            this.loadLogMessages(logMessagesMap, rbName);
            this.loadLogMessages(logMessagesDetails, rbName + DETAILS_SUFFIX);
            this.debug("Initial messages found so far: " + logMessagesMap);
            while (iterator.hasNext()) {
                Element elem = iterator.next();
                if (!(elem instanceof VariableElement)) {
                    this.error("The LogMessageInfo annotation is applied on an invalid element.");
                    return false;
                }
                VariableElement varElem = (VariableElement)elem;
                String msgId = (String)varElem.getConstantValue();
                if (msgId == null) {
                    this.error("The LogMessageInfo annotation is not applied on a String constant field.");
                    return false;
                }
                this.debug("Processing: " + msgId);
                if (!messageIds.contains(msgId)) {
                    String level;
                    String action;
                    String cause;
                    LogMessageInfo lmi = varElem.getAnnotation(LogMessageInfo.class);
                    this.checkLogMessageInfo(msgId, lmi);
                    logMessagesMap.put(msgId, lmi.message());
                    String comment = lmi.comment();
                    if (comment != null && !comment.isEmpty()) {
                        logMessagesMap.putComment(msgId, comment);
                        logMessagesDetails.put(msgId + ".comment", comment);
                    }
                    if ((cause = lmi.cause()) == null) {
                        cause = "";
                    }
                    if ((action = lmi.action()) == null) {
                        action = "";
                    }
                    if ((level = lmi.level()) == null || level.isEmpty()) {
                        level = "INFO";
                    }
                    logMessagesDetails.put(msgId + ".cause", cause);
                    logMessagesDetails.put(msgId + ".action", action);
                    logMessagesDetails.put(msgId + ".level", level);
                    messageIds.add(msgId);
                    continue;
                }
                this.error("Duplicate use of message-id " + msgId);
            }
            this.debug("Total Messages including ones found from disk so far: " + logMessagesMap);
            this.storeLogMessages(logMessagesMap, rbName);
            this.storeLogMessages(logMessagesDetails, rbName + DETAILS_SUFFIX);
            logMessagesMetada.put(RESOURCE_BUNDLE_KEY, rbName);
            this.storeLogMessages(logMessagesMetada, LOG_MESSAGES_METADATA);
            this.info("Annotation processing finished successfully.");
            return true;
        }
        return false;
    }

    private void checkLogMessageInfo(String msgId, LogMessageInfo lmi) {
        boolean needsCheck = false;
        for (String checkLevel : VALIDATE_LEVELS) {
            if (!checkLevel.equals(lmi.level())) continue;
            needsCheck = true;
        }
        this.debug("Message " + msgId + " needs checking for cause/action: " + needsCheck);
        if (needsCheck) {
            if (lmi.cause().trim().length() == 0) {
                this.error("Missing cause for message id '" + msgId + "' for levels SEVERE and above.");
            }
            if (lmi.action().trim().length() == 0) {
                this.error("Missing action for message id '" + msgId + "' for levels SEVERE and above.");
            }
        }
    }
}

