/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.module.maven.commandsecurityplugin;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.glassfish.module.maven.commandsecurityplugin.CommandAuthorizationInfo;
import org.glassfish.module.maven.commandsecurityplugin.RestEndpointInfo;
import org.glassfish.module.maven.commandsecurityplugin.TypeProcessor;
import org.glassfish.module.maven.commandsecurityplugin.TypeProcessorImpl;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Type;

public class TypeAnalyzer {
    private final InputStream classStream;
    private final boolean isOpenedAsFile;
    private static final String ACCESS_REQUIRED_DESC_PATH_ONLY = "org/glassfish/api/admin/AccessRequired";
    private static final String ACCESS_REQUIRED_DESC = "Lorg/glassfish/api/admin/AccessRequired;";
    private static final String ACCESS_REQUIRED_LIST_DESC = "Lorg/glassfish/api/admin/AccessRequired$List;";
    private static final String ACCESS_REQUIRED_DELEGATE_PATH_ONLY = "org/glassfish/api/admin/AccessRequired$Delegate";
    private static final String ACCESS_REQUIRED_DELEGATE_DESC = "Lorg/glassfish/api/admin/AccessRequired$Delegate;";
    private static final String REST_ENDPOINT_DESC_PATH_ONLY = "org/glassfish/api/admin/RestEndpoint";
    private static final String REST_ENDPOINT_DESC = "Lorg/glassfish/api/admin/RestEndpoint;";
    private static final String REST_ENDPOINTS_DESC = "Lorg/glassfish/api/admin/RestEndpoints;";
    private static final String SERVICE_ANNO_DESC = "Lorg/jvnet/hk2/annotations/Service;";
    private static final String SUPPLEMENTAL_ANNO_DESC = "Lorg/glassfish/api/admin/Supplemental;";
    private static final String CONFIGURED_ANNO_DESC = "Lorg/jvnet/hk2/config/Configured;";
    private static final String ADMIN_COMMAND_INTERNAL_NAME = "org/glassfish/api/admin/AdminCommand";
    private static final String CLI_COMMAND_INTERNAL_NAME = "com/sun/enterprise/admin/cli/CLICommand";
    private static final String DOMAIN_EXTENSION_INTERNAL_NAME = "com/sun/enterprise/config/serverbeans/DomainExtension";
    private static final String DOMAIN_INTERNAL_NAME = "com/sun/enterprise/config/serverbeans/Domain";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final Collection<String> AUTHORIZATION_RELATED_INTERFACES = new HashSet<String>(Arrays.asList("org/glassfish/api/admin/AdminCommandSecurity$AccessCheckProvider"));
    private StringBuilder trace = null;
    private CommandAuthorizationInfo commandAuthInfo = null;
    private boolean isCommand = false;
    private final Map<String, CommandAuthorizationInfo> knownCommandTypes;
    private final TypeProcessor typeProcessor;
    private ServiceAnnotationScanner service;
    private SupplementalAnnotationScanner supplemental;
    private CommandScanner cs;

    TypeAnalyzer(InputStream classStream, Map<String, CommandAuthorizationInfo> knownCommandTypes, TypeProcessor typeProcessor) {
        this(classStream, false, knownCommandTypes, typeProcessor);
    }

    void setTrace(StringBuilder sb) {
        this.trace = sb;
    }

    private TypeAnalyzer(InputStream classStream, boolean isOpenedAsFile, Map<String, CommandAuthorizationInfo> knownCommandTypes, TypeProcessor typeProcessor) {
        this.classStream = classStream;
        this.isOpenedAsFile = isOpenedAsFile;
        this.knownCommandTypes = knownCommandTypes;
        this.typeProcessor = typeProcessor;
    }

    void run() throws FileNotFoundException, IOException {
        try {
            ClassReader classReader = new ClassReader(this.classStream);
            this.cs = new CommandScanner();
            classReader.accept((ClassVisitor)this.cs, 7);
            this.isCommand = this.cs.isCommand();
            this.commandAuthInfo = this.cs.commandInfo();
        }
        finally {
            if (this.isOpenedAsFile) {
                this.classStream.close();
            }
        }
    }

    List<String> interfaces() {
        return this.cs == null ? Collections.EMPTY_LIST : this.cs.interfaces;
    }

    CommandAuthorizationInfo commandAuthInfo() {
        return this.commandAuthInfo;
    }

    boolean isCommand() {
        return this.isCommand;
    }

    private class AccessRequiredNewChildAnnotationScanner
    extends AnnotationVisitor {
        private final FieldScanner fieldScanner;
        private final CommandAuthorizationInfo authInfo;
        private final CommandAuthorizationInfo.Param param;
        private final List<String> actions;
        private String collection;
        private String type;

        AccessRequiredNewChildAnnotationScanner(FieldScanner fieldScanner, CommandAuthorizationInfo authInfo, CommandAuthorizationInfo.Param param) {
            super(458752);
            this.actions = new ArrayList<String>();
            this.collection = "";
            this.type = "";
            this.fieldScanner = fieldScanner;
            this.authInfo = authInfo;
            this.param = param;
        }

        public void visit(String name, Object value) {
            if (name.equals("type")) {
                String typeName;
                this.type = typeName = ((Type)value).getClassName();
            } else if (name.equals("collection")) {
                this.collection = (String)value;
            } else if (name.equals("action")) {
                if (value instanceof String) {
                    this.actions.add((String)value);
                } else {
                    this.actions.addAll(Arrays.asList((String[])value));
                }
            }
            super.visit(name, value);
        }

        public AnnotationVisitor visitArray(String name) {
            if (name.equals("action")) {
                return new MultiValuedAnnoVisitor(this.actions);
            }
            return null;
        }

        public void visitEnd() {
            String dottedTypeName = this.fieldScanner.fullFriendlyTypeName().replace("/", ".");
            TypeProcessorImpl.Inhabitant i = TypeAnalyzer.this.typeProcessor.configBeans().get(dottedTypeName);
            if (i == null) {
                throw new IllegalArgumentException("Could not find configBean for " + dottedTypeName);
            }
            if (this.actions.isEmpty()) {
                this.actions.add("create");
            }
            for (String action : this.actions) {
                this.authInfo.addResourceAction(i.fullPath() + (!this.type.isEmpty() ? "/" : "") + this.type + (!this.collection.isEmpty() ? "/" : "") + this.collection, action, "@AccessRequired.NewChild");
            }
            super.visitEnd();
        }
    }

    private static class MultiValuedAnnoVisitor
    extends AnnotationVisitor {
        private final Collection<String> values;

        MultiValuedAnnoVisitor(Collection<String> values) {
            super(458752);
            this.values = values;
        }

        public void visit(String name, Object value) {
            this.values.add((String)value);
            super.visit(name, value);
        }
    }

    private class AccessRequiredToAnnotationScanner
    extends AnnotationVisitor {
        private final FieldScanner fieldScanner;
        private final CommandAuthorizationInfo authInfo;
        private final CommandAuthorizationInfo.Param param;
        private final List<String> actions;
        private String collection;

        AccessRequiredToAnnotationScanner(FieldScanner fieldScanner, CommandAuthorizationInfo authInfo, CommandAuthorizationInfo.Param param) {
            super(458752);
            this.actions = new ArrayList<String>();
            this.collection = "";
            this.fieldScanner = fieldScanner;
            this.authInfo = authInfo;
            this.param = param;
        }

        public void visit(String name, Object value) {
            if (name.equals("value")) {
                if (value instanceof String) {
                    this.actions.add((String)value);
                } else {
                    this.actions.addAll(Arrays.asList((String[])value));
                }
            } else if (name.equals("collection")) {
                this.collection = (String)value;
            }
            super.visit(name, value);
        }

        public AnnotationVisitor visitArray(String name) {
            if (name.equals("value")) {
                return new MultiValuedAnnoVisitor(this.actions);
            }
            return null;
        }

        public void visitEnd() {
            String dottedTypeName = this.fieldScanner.fullFriendlyTypeName().replace("/", ".");
            TypeProcessorImpl.Inhabitant i = TypeAnalyzer.this.typeProcessor.configBeans().get(dottedTypeName);
            for (String action : this.actions) {
                this.authInfo.addResourceAction(i.fullPath() + (!this.collection.isEmpty() ? "/" : "") + this.collection + "/$xxx", action, "@AccessRequired.To");
            }
            super.visitEnd();
        }
    }

    private static class ParamAnnotationScanner
    extends AnnotationVisitor {
        private final CommandAuthorizationInfo.Param param;

        ParamAnnotationScanner(CommandAuthorizationInfo.Param p) {
            super(458752);
            this.param = p;
        }

        public void visit(String name, Object value) {
            if (name.equals("name")) {
                if (value instanceof String) {
                    this.param.setName((String)value);
                } else {
                    System.err.println("@Param name value is not a String but is " + value.getClass().getName());
                }
            }
            this.param.addValue(name, value);
            super.visit(name, value);
        }
    }

    private static class FieldScannerForOutput
    extends FieldVisitor {
        private static final String PARAM_ANNO_DESC = "Lorg/glassfish/api/Param;";
        private static final String STRING_DESC = "Ljava/lang/String;";
        private final String name;
        private final String desc;
        private final String friendlyTypeName;
        private final CommandAuthorizationInfo commandAuthInfo;
        private CommandAuthorizationInfo.Param param = null;

        FieldScannerForOutput(CommandAuthorizationInfo commandInfo, String name, String desc) {
            super(458752);
            this.commandAuthInfo = commandInfo;
            this.name = name;
            this.desc = desc;
            this.friendlyTypeName = desc.startsWith("L") ? (desc.equals(STRING_DESC) ? "" : desc.substring(desc.lastIndexOf(47) + 1, desc.length() - 1)) : desc;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(PARAM_ANNO_DESC)) {
                this.param = new CommandAuthorizationInfo.Param(this.name, this.friendlyTypeName);
                return new ParamAnnotationScanner(this.param);
            }
            return null;
        }

        public void visitEnd() {
            if (this.param != null) {
                Object nameValue = this.param.values().get("name");
                if (nameValue != null && nameValue instanceof String) {
                    this.param.setName((String)nameValue);
                }
                this.commandAuthInfo.addParam(this.param);
            }
            super.visitEnd();
        }
    }

    private static class SupplementalAnnotationScanner
    extends AnnotationVisitor {
        private static final String SUPPLEMENTAL_TIMING_DESC = "Lorg/glassfish/api/admin/Supplemental$Timing;";
        private static final String BEFORE = "Before";
        private static final String AFTER = "After";
        private static final String AFTER_REPLICATION = "AfterReplication";
        private String relatedCommand;
        private boolean isBefore = false;
        private boolean isAfter = false;
        private boolean isAfterReplication = false;

        public SupplementalAnnotationScanner() {
            super(458752);
        }

        public void visit(String name, Object value) {
            if (name.equals("value")) {
                if (value instanceof String) {
                    this.relatedCommand = (String)value;
                } else {
                    System.err.println("** @Supplemental 'value' value is not a String");
                }
            }
        }

        public void visitEnum(String name, String desc, String value) {
            if (name.equals("on") && desc.equals(SUPPLEMENTAL_TIMING_DESC)) {
                this.isBefore |= value.equals(BEFORE);
                this.isAfter |= value.equals(AFTER);
                this.isAfterReplication |= value.equals(AFTER_REPLICATION);
            }
        }

        String relatedCommand() {
            return this.relatedCommand;
        }

        String relation() {
            return "[" + (this.isBefore ? "+" : "") + this.relatedCommand + (this.isAfter ? "+" : (this.isAfterReplication ? "++" : "")) + "]";
        }
    }

    private static class ServiceAnnotationScanner
    extends AnnotationVisitor {
        private String name = null;
        private final CommandAuthorizationInfo authInfo;

        ServiceAnnotationScanner(CommandAuthorizationInfo authInfo) {
            super(458752);
            this.authInfo = authInfo;
        }

        public void visit(String name, Object value) {
            if (name.equals("name")) {
                if (value instanceof String) {
                    this.name = (String)value;
                    this.authInfo.setName(this.name);
                } else {
                    System.err.println("** @Service name value is not a String");
                }
            }
        }

        String name() {
            return this.name;
        }
    }

    private class FieldScanner
    extends FieldVisitor {
        private final String ACCESS_REQUIRED_TO_DESC = "Lorg/glassfish/api/admin/AccessRequired$To;";
        private final String ACCESS_REQUIRED_NEW_CHILD_DESC = "Lorg/glassfish/api/admin/AccessRequired$NewChild;";
        private final Collection<String> FIELD_LEVEL_ANNOS;
        private final CommandAuthorizationInfo commandAuthInfo;
        private static final String PARAM_ANNO_DESC = "Lorg/glassfish/api/Param;";
        private static final String STRING_DESC = "Ljava/lang/String;";
        private final String name;
        private final String desc;
        private final String friendlyTypeName;
        private CommandAuthorizationInfo.Param param;

        FieldScanner(CommandAuthorizationInfo commandAuthInfo, String name, String desc) {
            super(458752);
            this.ACCESS_REQUIRED_TO_DESC = "Lorg/glassfish/api/admin/AccessRequired$To;";
            this.ACCESS_REQUIRED_NEW_CHILD_DESC = "Lorg/glassfish/api/admin/AccessRequired$NewChild;";
            this.FIELD_LEVEL_ANNOS = Arrays.asList("Lorg/glassfish/api/admin/AccessRequired$To;", "Lorg/glassfish/api/admin/AccessRequired$NewChild;");
            this.param = null;
            this.commandAuthInfo = commandAuthInfo;
            this.name = name;
            this.desc = desc;
            this.friendlyTypeName = this.friendlyTypeName(desc);
        }

        String fullFriendlyTypeName() {
            if (this.desc.startsWith("L")) {
                return this.desc.substring(1, this.desc.length() - 1);
            }
            return this.desc;
        }

        private String friendlyTypeName(String desc) {
            if (desc.startsWith("L")) {
                if (desc.equals(STRING_DESC)) {
                    return "";
                }
                return desc.substring(desc.lastIndexOf(47) + 1, desc.length() - 1);
            }
            return desc;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (this.FIELD_LEVEL_ANNOS.contains(desc)) {
                if (TypeAnalyzer.this.trace != null) {
                    TypeAnalyzer.this.trace.append(LINE_SEP).append("    Found anno ").append(desc);
                }
                this.commandAuthInfo.hasFieldLevelAccessRequiredAnno.set(true);
            }
            if (desc.equals(PARAM_ANNO_DESC)) {
                this.param = new CommandAuthorizationInfo.Param(this.name, this.friendlyTypeName);
                return new ParamAnnotationScanner(this.param);
            }
            if (desc.equals("Lorg/glassfish/api/admin/AccessRequired$To;")) {
                return new AccessRequiredToAnnotationScanner(this, this.commandAuthInfo, this.param);
            }
            if (desc.equals("Lorg/glassfish/api/admin/AccessRequired$NewChild;")) {
                return new AccessRequiredNewChildAnnotationScanner(this, this.commandAuthInfo, this.param);
            }
            return null;
        }

        public void visitEnd() {
            if (this.param != null) {
                Object nameValue = this.param.values().get("name");
                if (nameValue != null && nameValue instanceof String) {
                    this.param.setName((String)nameValue);
                }
                this.commandAuthInfo.addParam(this.param);
            }
            super.visitEnd();
        }
    }

    private class AnnoScanner
    extends AnnotationVisitor {
        private final CommandAuthorizationInfo authInfo;
        private final String descToProcess;

        private AnnoScanner(CommandAuthorizationInfo authInfo, String descToProcess) {
            super(458752);
            this.authInfo = authInfo;
            this.descToProcess = descToProcess;
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            if (desc.equals(this.descToProcess)) {
                if (TypeAnalyzer.this.trace != null) {
                    TypeAnalyzer.this.trace.append(LINE_SEP).append("    Found anno name=").append(name).append(", desc=").append(desc);
                }
                this.authInfo.hasCommandLevelAccessRequiredAnno.set(true);
            }
            return null;
        }
    }

    private class RepeatingAnnoScanner
    extends AnnotationVisitor {
        private final CommandAuthorizationInfo authInfo;
        private final String singleAnnoDesc;
        private final Class<? extends AnnotationVisitor> scannerClass;

        private RepeatingAnnoScanner(CommandAuthorizationInfo authInfo, String singleAnnoDesc, Class<? extends AnnotationVisitor> scannerClass) {
            super(458752);
            this.authInfo = authInfo;
            this.singleAnnoDesc = singleAnnoDesc;
            this.scannerClass = scannerClass;
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            if (name.equals(this.singleAnnoDesc) && TypeAnalyzer.this.trace != null) {
                TypeAnalyzer.this.trace.append(LINE_SEP).append("    Found ").append(name).append(" in array of ").append(this.singleAnnoDesc).append(" at class level");
            }
            return null;
        }

        public AnnotationVisitor visitArray(String name) {
            try {
                Constructor<? extends AnnotationVisitor> c = this.scannerClass.getConstructor(CommandAuthorizationInfo.class);
                AnnotationVisitor v = c.newInstance(this.authInfo);
                return v;
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private class RestEndpointAnnoScanner
    extends AnnotationVisitor {
        private final CommandAuthorizationInfo authInfo;
        private String configBeanClassName;
        private String path;
        private String opType;
        private boolean useForAuthorization;
        private RestEndpointInfo info;

        private RestEndpointAnnoScanner(CommandAuthorizationInfo authInfo) {
            super(458752);
            this.configBeanClassName = null;
            this.path = null;
            this.opType = null;
            this.useForAuthorization = false;
            this.authInfo = authInfo;
        }

        public void visit(String name, Object value) {
            if (name.equals("configBean")) {
                this.configBeanClassName = ((Type)value).getInternalName();
            } else if (name.equals("path")) {
                this.path = (String)value;
            } else if (name.equals("opType")) {
                this.opType = ((Type)value).getInternalName();
            } else if (name.equals("useForAuthorization")) {
                this.useForAuthorization = (Boolean)value;
            }
            super.visit(name, value);
        }

        public void visitEnum(String name, String desc, String value) {
            if (name.equals("opType")) {
                this.opType = value;
            }
        }

        public void visitEnd() {
            this.info = new RestEndpointInfo(this.configBeanClassName, this.path, this.opType, this.useForAuthorization);
            this.authInfo.addRestEndpoint(this.info);
            if (this.useForAuthorization) {
                this.authInfo.hasRestAnno.set(true);
            }
            super.visitEnd();
        }

        private RestEndpointInfo restEndpointInfo() {
            return this.info;
        }
    }

    private class RestEndpointsAnnoScanner
    extends AnnotationVisitor {
        private final CommandAuthorizationInfo authInfo;

        private RestEndpointsAnnoScanner(CommandAuthorizationInfo authInfo) {
            super(458752);
            this.authInfo = authInfo;
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            if (desc.equals(TypeAnalyzer.REST_ENDPOINT_DESC)) {
                if (TypeAnalyzer.this.trace != null) {
                    TypeAnalyzer.this.trace.append(LINE_SEP).append("    Found ").append(name).append(" in array at class level");
                }
                return new RestEndpointAnnoScanner(this.authInfo);
            }
            return null;
        }

        public AnnotationVisitor visitArray(String name) {
            return new RestEndpointsAnnoScanner(this.authInfo);
        }
    }

    private class CommandLevelAccessRequiredDelegateAnnotationScanner
    extends AnnotationVisitor {
        private final CommandAuthorizationInfo commandAuthInfo;

        private CommandLevelAccessRequiredDelegateAnnotationScanner(CommandAuthorizationInfo commandAuthInfo) {
            super(458752);
            this.commandAuthInfo = commandAuthInfo;
        }

        public void visit(String name, Object value) {
            if (name.equals("value")) {
                this.commandAuthInfo.setDelegate(((Type)value).getInternalName());
            } else {
                super.visit(name, value);
            }
        }
    }

    private static class CommandLevelAccessRequiredAnnotationScanner
    extends AnnotationVisitor {
        private final List<String> resources = new ArrayList<String>();
        private final List<String> actions = new ArrayList<String>();
        private final CommandAuthorizationInfo commandAuthInfo;

        public CommandLevelAccessRequiredAnnotationScanner(CommandAuthorizationInfo commandAuthInfo) {
            super(458752);
            this.commandAuthInfo = commandAuthInfo;
        }

        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new CommandLevelAccessRequiredAnnotationScanner(this.commandAuthInfo);
        }

        public AnnotationVisitor visitArray(String name) {
            if (name.equals("resource")) {
                return new MultiValuedAnnoVisitor(this.resources);
            }
            if (name.equals("action")) {
                return new MultiValuedAnnoVisitor(this.actions);
            }
            return super.visitArray(name);
        }

        public void visitEnd() {
            if (!this.resources.isEmpty() && !this.actions.isEmpty()) {
                this.commandAuthInfo.hasCommandLevelAccessRequiredAnno.set(true);
            }
            for (String resource : this.resources) {
                for (String action : this.actions) {
                    this.commandAuthInfo.addResourceAction(resource, action, "@AccessRequired");
                }
            }
            super.visitEnd();
        }
    }

    private class CommandScanner
    extends ClassVisitor {
        private CommandAuthorizationInfo commandAuthInfo;
        private boolean isCommand;
        private String superName;
        private String className;
        private List<String> interfaces;

        CommandScanner() {
            super(458752);
            this.commandAuthInfo = null;
            this.isCommand = false;
        }

        boolean isCommand() {
            return this.isCommand;
        }

        CommandAuthorizationInfo commandInfo() {
            return this.commandAuthInfo;
        }

        List<String> interfaces() {
            return this.interfaces;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            if (TypeAnalyzer.this.trace != null) {
                TypeAnalyzer.this.trace.append(LINE_SEP).append("  Starting to analyze class ").append(name);
            }
            this.superName = superName;
            this.interfaces = new ArrayList<String>(Arrays.asList(interfaces));
            this.isCommand = this.isExtensionOrImplementationOfCommandType(name, interfaces);
            this.commandAuthInfo = new CommandAuthorizationInfo();
            this.commandAuthInfo.setClassName(this.className);
            this.checkForAuthRelatedInterfaces(interfaces);
        }

        private void checkForAuthRelatedInterfaces(String[] interfaces) {
            for (String iface : interfaces) {
                if (!AUTHORIZATION_RELATED_INTERFACES.contains(iface)) continue;
                this.commandAuthInfo.isAccessCheckProvider.set(true);
                return;
            }
        }

        private boolean isExtensionOrImplementationOfCommandType(String name, String[] interfaces) {
            String i;
            boolean result = false;
            String[] stringArray = interfaces;
            int n = stringArray.length;
            for (int j = 0; j < n && !(result = (i = stringArray[j]).equals(TypeAnalyzer.ADMIN_COMMAND_INTERNAL_NAME)); ++j) {
            }
            return result;
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            FieldScanner f = new FieldScanner(this.commandAuthInfo, name, desc);
            return f;
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals(TypeAnalyzer.ACCESS_REQUIRED_DESC)) {
                if (TypeAnalyzer.this.trace != null) {
                    TypeAnalyzer.this.trace.append(LINE_SEP).append("  Found @AccessRequired at class level");
                }
                this.commandAuthInfo.hasCommandLevelAccessRequiredAnno.set(true);
                return new CommandLevelAccessRequiredAnnotationScanner(this.commandAuthInfo);
            }
            if (desc.equals(TypeAnalyzer.ACCESS_REQUIRED_DELEGATE_DESC)) {
                if (TypeAnalyzer.this.trace != null) {
                    TypeAnalyzer.this.trace.append(LINE_SEP).append("  Found @AccessRequired.Delegate at class level");
                }
                this.commandAuthInfo.hasCommandLevelAccessRequiredAnno.set(true);
                return new CommandLevelAccessRequiredDelegateAnnotationScanner(this.commandAuthInfo);
            }
            if (desc.equals(TypeAnalyzer.REST_ENDPOINT_DESC)) {
                if (TypeAnalyzer.this.trace != null) {
                    TypeAnalyzer.this.trace.append(LINE_SEP).append("  Found @RestEndpoint at class level");
                }
                return new RestEndpointAnnoScanner(this.commandAuthInfo);
            }
            if (desc.equals(TypeAnalyzer.ACCESS_REQUIRED_LIST_DESC)) {
                return new RepeatingAnnoScanner(this.commandAuthInfo, TypeAnalyzer.ACCESS_REQUIRED_DESC, CommandLevelAccessRequiredAnnotationScanner.class);
            }
            if (desc.equals(TypeAnalyzer.REST_ENDPOINTS_DESC)) {
                return new RestEndpointsAnnoScanner(this.commandAuthInfo);
            }
            if (desc.equals(TypeAnalyzer.SERVICE_ANNO_DESC)) {
                return new ServiceAnnotationScanner(this.commandAuthInfo);
            }
            if (desc.equals(TypeAnalyzer.SUPPLEMENTAL_ANNO_DESC)) {
                return new SupplementalAnnotationScanner();
            }
            return null;
        }

        public void visitEnd() {
            if (this.isCommand) {
                if (this.commandAuthInfo.isOK()) {
                    if (TypeAnalyzer.this.trace != null) {
                        TypeAnalyzer.this.trace.append(LINE_SEP).append("  Recognized that ").append(this.className).append(" is a command and has authorization without checking ancestors");
                    }
                } else if (TypeAnalyzer.this.trace != null) {
                    TypeAnalyzer.this.trace.append(LINE_SEP).append("  Recognized that ").append(this.className).append(" is a command but itself has no authorization");
                }
            } else if (TypeAnalyzer.this.trace != null) {
                TypeAnalyzer.this.trace.append(LINE_SEP).append("  Recognized that ").append(this.className).append(" is not itself a command; an ancestor might be");
            }
            try {
                if (this.superName != null) {
                    CommandAuthorizationInfo parentInfo = TypeAnalyzer.this.typeProcessor.processType(this.superName);
                    boolean isParentCommand = TypeAnalyzer.this.knownCommandTypes.containsKey(this.superName);
                    this.isCommand |= isParentCommand;
                    if (isParentCommand) {
                        if (TypeAnalyzer.this.trace != null) {
                            TypeAnalyzer.this.trace.append(LINE_SEP).append("  Detected that ").append(this.className).append(" is a command based on its ancestry; check of parent and its ancestry for auth: ").append(parentInfo.isOKDeep());
                        }
                    } else if (!this.isCommand && TypeAnalyzer.this.trace != null) {
                        TypeAnalyzer.this.trace.append(LINE_SEP).append("  Detected that ").append(this.className).append(" is not a command, even including its ancestry");
                    }
                    this.commandAuthInfo.setParent(parentInfo);
                }
                if (this.isCommand && TypeAnalyzer.this.service != null) {
                    if (TypeAnalyzer.this.supplemental != null) {
                        this.commandAuthInfo.setName(TypeAnalyzer.this.supplemental.relation());
                    } else {
                        this.commandAuthInfo.setName(TypeAnalyzer.this.service.name());
                    }
                    this.commandAuthInfo.setClassName(this.className);
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

