/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.module.maven.commandsecurityplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.glassfish.module.maven.commandsecurityplugin.RestEndpointInfo;

public class CommandAuthorizationInfo {
    private static final String LINE_SEP = System.getProperty("line.separator");
    final AtomicBoolean hasRestAnno = new AtomicBoolean(false);
    final AtomicBoolean hasCommandLevelAccessRequiredAnno = new AtomicBoolean(false);
    final AtomicBoolean hasFieldLevelAccessRequiredAnno = new AtomicBoolean(false);
    final AtomicBoolean isAccessCheckProvider = new AtomicBoolean(false);
    final AtomicBoolean isLocal = new AtomicBoolean(false);
    private List<RestEndpointInfo> endpoints = new ArrayList<RestEndpointInfo>();
    private CommandAuthorizationInfo parent = null;
    private String genericMethodListActual = "";
    private String fullPath = "";
    private String genericAction = "";
    private Delegate delegate = null;
    private final List<ResourceAction> resourceActionPairs = new ArrayList<ResourceAction>();
    private static final List<String> GENERIC_ACTIONS_USING_FULL_GENERIC_SUBPATH = new ArrayList<String>(Arrays.asList("read", "update", "delete"));
    private String name;
    private String className;
    private List<Param> params = new ArrayList<Param>();

    public void setDelegate(String delegateClassName) {
        this.delegate = new Delegate(delegateClassName);
    }

    public void addRestEndpoint(RestEndpointInfo endpoint) {
        this.endpoints.add(endpoint);
    }

    public void addResourceAction(String resource, String action, String origin) {
        this.resourceActionPairs.add(new ResourceAction(resource, action, origin));
    }

    public List<ResourceAction> resourceActionPairs() {
        return this.resourceActionPairs;
    }

    public void overrideResourceActions(List<ResourceAction> newPairs) {
        this.resourceActionPairs.clear();
        this.resourceActionPairs.addAll(newPairs);
    }

    public String genericSubpath(String separator) {
        if (this.genericMethodListActual == null || this.genericMethodListActual.isEmpty()) {
            return "";
        }
        return this.fullPath;
    }

    public String genericSubpathPerAction(String separator) {
        Object subpath = this.genericSubpath(separator);
        if (GENERIC_ACTIONS_USING_FULL_GENERIC_SUBPATH.contains(this.genericAction)) {
            subpath = (String)subpath + separator + "$name";
        } else if (this.genericAction.equals("list")) {
            subpath = ((String)subpath).substring(0, ((String)subpath).lastIndexOf(47));
        }
        return subpath;
    }

    public String adjustedGenericAction() {
        if (this.genericAction.equals("list")) {
            return "read";
        }
        return this.genericAction;
    }

    public String genericAction() {
        return this.genericAction;
    }

    public void setGeneric(String methodListActual, String methodName, String fullPath, String action) {
        this.genericMethodListActual = methodListActual;
        this.fullPath = fullPath;
        this.genericAction = action;
    }

    public List<RestEndpointInfo> restEndpoints() {
        return this.endpoints;
    }

    public void setParent(CommandAuthorizationInfo parent) {
        this.parent = parent;
    }

    public void setLocal(boolean local) {
        this.isLocal.set(local);
    }

    public boolean isLocalDeep() {
        return this.isLocal.get() || this.parent != null && this.parent.isLocalDeep();
    }

    boolean isOK() {
        return this.delegate != null || this.hasRestAnno.get() || this.hasCommandLevelAccessRequiredAnno.get() || this.hasFieldLevelAccessRequiredAnno.get() || this.isAccessCheckProvider.get();
    }

    boolean isOKDeep() {
        return this.isOK() || this.parent != null && this.parent.isOKDeep();
    }

    boolean isAccessCheckProvider() {
        return this.isAccessCheckProvider.get();
    }

    Delegate delegate() {
        return this.delegate;
    }

    void setName(String name) {
        this.name = name;
    }

    void addParam(Param p) {
        this.params.add(p);
    }

    void setClassName(String className) {
        this.className = className;
    }

    List<Param> params() {
        return this.params;
    }

    String name() {
        return this.name;
    }

    String className() {
        return this.className;
    }

    public String toString() {
        return this.toString("", true);
    }

    public String toString(String indent, boolean isFull) {
        StringBuffer sb = new StringBuffer();
        if (this.delegate != null) {
            sb.append(this.name).append(" delegates to ").append(this.delegate.delegateInternalClassName);
        } else {
            sb.append(this.name).append(" (").append((String)(this.fullPath != null && !this.fullPath.isEmpty() ? "[" + this.adjustedGenericAction() + "] " + this.genericSubpathPerAction("/") : this.className)).append(")");
        }
        if (isFull) {
            sb.append(LINE_SEP);
            LinkedList<CommandAuthorizationInfo> levelsToProcess = new LinkedList<CommandAuthorizationInfo>();
            CommandAuthorizationInfo info = this;
            while (info != null) {
                levelsToProcess.addFirst(info);
                info = info.parent;
            }
            for (CommandAuthorizationInfo level : levelsToProcess) {
                for (Param p : level.params()) {
                    sb.append(indent).append("  ").append(p);
                }
            }
            for (RestEndpointInfo i : this.restEndpoints()) {
                if (!i.useForAuthorization()) continue;
                sb.append(LINE_SEP).append(indent).append("  ").append(i.toString());
            }
        }
        return sb.append(LINE_SEP).toString();
    }

    static class Delegate {
        String delegateInternalClassName;

        Delegate(String delegateInternalClassName) {
            this.delegateInternalClassName = delegateInternalClassName;
        }

        String delegateInternalClassName() {
            return this.delegateInternalClassName;
        }
    }

    static class ResourceAction {
        String resource;
        String action;
        String origin;

        ResourceAction(String resource, String action, String origin) {
            this.resource = resource;
            this.action = action;
            this.origin = origin;
        }
    }

    static class Param {
        private String name;
        private String type;
        private Map<String, Object> values = new HashMap<String, Object>();

        Param(String name, String type) {
            this.name = name;
            this.type = type;
        }

        void setName(String name) {
            this.name = name;
        }

        void setType(String type) {
            this.type = type;
        }

        void addValue(String name, Object value) {
            this.values.put(name, value);
        }

        Map<String, Object> values() {
            return this.values;
        }

        boolean isOptional() {
            return this.booleanValue("optional");
        }

        boolean isPrimary() {
            return this.booleanValue("primary");
        }

        private boolean booleanValue(String key) {
            boolean result = false;
            Object v = this.values.get(key);
            if (v != null && v instanceof Boolean) {
                result = (Boolean)v;
            }
            return result;
        }

        String type() {
            return this.type;
        }

        public String toString() {
            return (this.isOptional() ? "[" : "") + (this.isPrimary() ? "**" : "--") + this.name + this.friendlyType() + (this.isOptional() ? "]" : "");
        }

        private String friendlyType() {
            return this.type.isEmpty() ? "" : " (" + this.type + ")";
        }
    }
}

