/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.module.maven.commandsecurityplugin;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Properties;
import org.apache.maven.model.Developer;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.glassfish.module.maven.commandsecurityplugin.CommonMojo;
import org.glassfish.module.maven.commandsecurityplugin.TypeProcessorImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckMojo
extends CommonMojo {
    private String isFailureFatal;
    protected String violationWikiPath;
    protected String moduleOwnersPath;
    private static final String WIKI_INFO_SET = "is-wiki-info-set";
    private static WikiOutputInfo wikiOutputInfo;

    private boolean isLastProject() {
        List projects = this.reactorProjects;
        return this.project.equals(projects.get(projects.size() - 1));
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        List<String> offendingClassNames;
        try {
            this.initWikiOutputInfo();
        }
        catch (IOException ex) {
            throw new MojoFailureException("Error initializing output file", (Throwable)ex);
        }
        TypeProcessorImpl typeProcessor = new TypeProcessorImpl((AbstractMojo)this, this.session, this.project, this.isFailureFatal, this.isCheckAPIvsParse);
        typeProcessor.execute();
        StringBuilder trace = typeProcessor.trace();
        if (trace != null) {
            this.getLog().debug((CharSequence)trace.toString());
        }
        if (typeProcessor.okClassNames() != null) {
            this.getLog().debug((CharSequence)("Command classes with authorization: " + typeProcessor.okClassNames().toString()));
        }
        if (!(offendingClassNames = typeProcessor.offendingClassNames()).isEmpty()) {
            if (wikiOutputInfo != null) {
                try {
                    this.ensureViolationWikiTitleIsPresent();
                }
                catch (IOException ex) {
                    throw new MojoFailureException("Error opening output file and writing title", (Throwable)ex);
                }
                this.printViolationWikiRow(typeProcessor.offendingClassNames());
            }
            if (typeProcessor.isFailureFatal()) {
                this.getLog().error((CharSequence)("Following command classes neither provide nor inherit authorization: " + offendingClassNames.toString()));
                throw new MojoFailureException("Command class(es) with no authorization");
            }
            this.getLog().warn((CharSequence)("Following command classes neither provide nor inherit authorization: " + offendingClassNames.toString()));
        }
        if (wikiOutputInfo != null && CheckMojo.wikiOutputInfo.wikiWriter != null) {
            CheckMojo.wikiOutputInfo.wikiWriter.flush();
        }
        if (this.isLastProject() && wikiOutputInfo != null) {
            CheckMojo.wikiOutputInfo.finish();
        }
    }

    private void ensureViolationWikiTitleIsPresent() throws IOException {
        if (wikiOutputInfo != null) {
            CheckMojo.wikiOutputInfo.ensureInitialized();
        }
    }

    private void printViolationWikiRow(List<String> offendingClassNames) {
        String output = "| " + this.project.getGroupId() + ":" + this.project.getArtifactId() + " |" + this.project.getName() + " | " + this.relativeToTop(this.project.getBasedir()) + " | " + this.formattedList(offendingClassNames) + " | " + this.nameOrId(this.getLead()) + " |";
        CheckMojo.wikiOutputInfo.wikiWriter.println(output);
    }

    private Developer getLead() {
        List devs = this.project.getDevelopers();
        Developer lead = devs.isEmpty() ? null : (Developer)devs.get(0);
        for (Developer d : this.project.getDevelopers()) {
            List roles = d.getRoles();
            if (roles == null || !roles.contains("lead")) continue;
            lead = d;
        }
        return lead;
    }

    private String nameOrId(Developer d) {
        String result = "?";
        if (d != null) {
            if (d.getName() != null) {
                result = d.getName();
            } else if (d.getId() != null) {
                result = d.getId();
            }
        }
        return result;
    }

    private String formattedList(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        for (String s : strings) {
            if (sb.length() > 0) {
                sb.append("\\\\\n");
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private String relativeToTop(File f) {
        return new File(this.session.getExecutionRootDirectory()).toURI().relativize(f.toURI()).toASCIIString();
    }

    private void initWikiOutputInfo() throws IOException {
        if (wikiOutputInfo == null) {
            if (this.violationWikiPath == null || this.violationWikiPath.isEmpty()) {
                return;
            }
            Properties p = this.session.getUserProperties();
            String infoState = p.getProperty(WIKI_INFO_SET);
            if (infoState == null) {
                wikiOutputInfo = new WikiOutputInfo(true);
                p.setProperty(WIKI_INFO_SET, "unopened");
            } else {
                wikiOutputInfo = new WikiOutputInfo(infoState);
            }
        }
    }

    private class WikiOutputInfo {
        File wikiFile = null;
        PrintWriter wikiWriter = null;
        final boolean isNew;

        private WikiOutputInfo(boolean isNew) throws IOException {
            this.isNew = isNew;
            if (CheckMojo.this.violationWikiPath != null && !CheckMojo.this.violationWikiPath.isEmpty()) {
                this.wikiFile = new File(CheckMojo.this.session.getExecutionRootDirectory(), CheckMojo.this.violationWikiPath);
            }
        }

        private WikiOutputInfo(String state) throws IOException {
            this(false);
            if (!state.equals("unopened")) {
                this.openWriter();
            }
        }

        private void openWriter() throws IOException {
            this.wikiWriter = new PrintWriter(new FileWriter(this.wikiFile, !this.isNew));
            CheckMojo.this.session.getUserProperties().setProperty(CheckMojo.WIKI_INFO_SET, "open");
        }

        private void ensureInitialized() throws IOException {
            if (this.wikiWriter == null) {
                this.openWriter();
                this.wikiWriter.println("{table-plus}");
                this.wikiWriter.println("|| Module ID || Module Name || Path || Classes Needing Attention || Owner ||");
            }
        }

        private void finish() {
            String state;
            if (this.wikiWriter != null && !"unopened".equals(state = CheckMojo.this.session.getUserProperties().getProperty(CheckMojo.WIKI_INFO_SET))) {
                this.wikiWriter.println("{table-plus}");
                this.wikiWriter.close();
            }
        }
    }
}

