/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.module.maven.commandsecurityplugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.glassfish.module.maven.commandsecurityplugin.CommandAuthorizationInfo;
import org.glassfish.module.maven.commandsecurityplugin.TypeProcessor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class ConfigBeanAnalyzer {
    private final InputStream classStream;
    private StringBuilder trace = null;
    private CommandAuthorizationInfo commandAuthInfo = null;
    private boolean isCommand = false;
    private final TypeProcessor typeProcessor;

    ConfigBeanAnalyzer(InputStream classStream, TypeProcessor typeProcessor) {
        this.typeProcessor = typeProcessor;
        this.classStream = classStream;
    }

    void setTrace(StringBuilder trace) {
        this.trace = trace;
    }

    void run() throws IOException {
        ClassReader classReader = new ClassReader(this.classStream);
        ConfigBeanScanner cs = new ConfigBeanScanner();
        classReader.accept((ClassVisitor)cs, 7);
        this.isCommand = cs.isCommand();
    }

    CommandAuthorizationInfo commandAuthInfo() {
        return this.commandAuthInfo;
    }

    boolean isCommand() {
        return this.isCommand;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ConfigBeanScanner
    extends ClassVisitor {
        private boolean isCommand;
        private Collection<CommandAuthorizationInfo> commandInfos;

        private ConfigBeanScanner() {
            super(262144);
            this.isCommand = false;
            this.commandInfos = Collections.EMPTY_LIST;
        }

        private boolean isCommand() {
            return this.isCommand;
        }

        private Collection<CommandAuthorizationInfo> commandInfos() {
            return this.commandInfos;
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }
    }
}

