/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.module.maven.commandsecurityplugin;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.glassfish.hk2.utilities.DescriptorImpl;
import org.glassfish.module.maven.commandsecurityplugin.CommandAuthorizationInfo;
import org.glassfish.module.maven.commandsecurityplugin.TypeAnalyzer;
import org.glassfish.module.maven.commandsecurityplugin.TypeProcessor;
import org.glassfish.module.maven.commandsecurityplugin.Util;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeProcessorImpl
implements TypeProcessor {
    static Properties shared = new Properties();
    private boolean isFailureFatal;
    private boolean isCheckAPIvsParse;
    private static final String KNOWN_NONCOMMAND_TYPES_NAME = "org.glassfish.api.admin.knownNonCommandTypes";
    private static final String PROCESSED_MODULES_NAME = "org.glassfish.api.admin.processedModules";
    private static final String CONFIG_BEANS_NAME = "org.glassfish.api.admin.configBeans";
    private static final String INHABITANTS_PATHS_PREFIX = "META-INF/hk2-locator/";
    private static final String[] INHABITANTS_PATHS = new String[]{"default", "tenant-scoped"};
    private static final Pattern INHABITANT_IMPL_CLASS_PATTERN = Pattern.compile("\\[([^\\]]+)\\]");
    private static final Pattern INHABITANT_CONTRACTS_PATTERN = Pattern.compile("contract=\\{([^\\}]+)\\}");
    private static final Pattern INHABITANT_NAME_PATTERN = Pattern.compile("name=(.+)");
    private static final Pattern CONFIG_BEAN_METADATA_PREFIX_PATTERN = Pattern.compile("metadata=target=\\{([^\\}]+)\\}(.*)");
    private static final Pattern CONFIG_BEAN_CHILD_PATTERN = Pattern.compile(",(?:<([^>]+)>=\\{(?:collection\\\\:)?([^,}]+)[},])|(?:\\@[^}]+})|(?:key=[^}]+)|(?:keyed-as=[^}]+)");
    private static final Pattern GENERIC_COMMAND_INFO_PATTERN = Pattern.compile("metadata=MethodListActual=\\{([^\\}]+)\\},MethodName=\\{([^\\}]+)\\},ParentConfigured=\\{([^\\}]+)\\}");
    private static final Pattern CONFIG_BEAN_CHILD_NAME_KEY_PATTERN = Pattern.compile("<([^>]+)>");
    private static final String ADMIN_COMMAND_NAME = "org.glassfish.api.admin.AdminCommand";
    private static final String CLI_COMMAND_NAME = "com.sun.enterprise.admin.cli.CLICommand";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String CONFIG_INJECTOR_NAME = "org.jvnet.hk2.config.ConfigInjector";
    private static final String GENERIC_CREATE_COMMAND = "org.glassfish.config.support.GenericCreateCommand";
    private static final String GENERIC_DELETE_COMMAND = "org.glassfish.config.support.GenericDeleteCommand";
    private static final String GENERIC_LIST_COMMAND = "org.glassfish.config.support.GenericListCommand";
    private static final Set<String> GENERIC_CRUD_COMMAND_CLASS_NAMES = new HashSet<String>(Arrays.asList("org.glassfish.config.support.GenericCreateCommand", "org.glassfish.config.support.GenericDeleteCommand", "org.glassfish.config.support.GenericListCommand"));
    private static final List<String> EXTENSION_INTERNAL_NAMES = new ArrayList<String>(Arrays.asList("com/sun/enterprise/config/serverbeans/DomainExtension", "com/sun/enterprise/config/serverbeans/ConfigExtension", "com/oracle/cloudlogic/tenantmanager/entity/TenantExtension", "com/sun/enterprise/config/serverbeans/ApplicationExtension", "com/oracle/cloudlogic/tenantmanager/entity/TenantEnvironmentExtension"));
    private static final String CONFIG_BEAN_NAME = "org.jvnet.hk2.config.ConfigBean";
    private static final String CONFIG_BEAN_PROXY_NAME = "org.jvnet.hk2.config.ConfigBeanProxy";
    private static final Map<String, String> genericCommandNameToAction = TypeProcessorImpl.initCommandNameToActionMap();
    private URLClassLoader loader;
    private File buildDir;
    private StringBuilder trace = null;
    private Map<String, CommandAuthorizationInfo> knownCommandTypes = null;
    private Set<String> knownNonCommandTypes = null;
    private Map<String, CommandAuthorizationInfo> knownCRUDConfigBeanTypes = null;
    private Collection<CommandAuthorizationInfo> authInfosThisModule = new ArrayList<CommandAuthorizationInfo>();
    private final List<String> offendingClassNames = new ArrayList<String>();
    private List<String> okClassNames = null;
    private Set<URL> jarsProcessedForConfigBeans = null;
    private Map<String, Inhabitant> configBeans = null;
    private final AbstractMojo mojo;
    private final MavenSession session;
    private final MavenProject project;

    private static Map<String, String> initCommandNameToActionMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(GENERIC_CREATE_COMMAND, "create");
        result.put(GENERIC_DELETE_COMMAND, "delete");
        result.put(GENERIC_LIST_COMMAND, "list");
        return result;
    }

    TypeProcessorImpl(AbstractMojo mojo, MavenSession session, MavenProject project) {
        this(mojo, session, project, false, false);
    }

    private TypeProcessorImpl(AbstractMojo mojo, MavenSession session, MavenProject project, boolean isFailureFatal, boolean isCheckAPIvsParse) {
        this.mojo = mojo;
        this.session = session;
        this.project = project;
        this.isFailureFatal = isFailureFatal;
        this.isCheckAPIvsParse = isCheckAPIvsParse;
    }

    TypeProcessorImpl(AbstractMojo mojo, MavenSession session, MavenProject project, String isFailureFatalSetting, String isCheckAPIvsParse) {
        this(mojo, session, project, Boolean.parseBoolean(isFailureFatalSetting), Boolean.parseBoolean(isCheckAPIvsParse));
    }

    @Override
    public Map<String, Inhabitant> configBeans() {
        return this.configBeans;
    }

    private Log getLog() {
        return this.mojo.getLog();
    }

    @Override
    public CommandAuthorizationInfo processType(String internalClassName) throws MojoFailureException, MojoExecutionException {
        return this.processType(internalClassName, false);
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        List<Inhabitant> inhabitants;
        this.trace = this.getLog().isDebugEnabled() ? new StringBuilder() : null;
        this.okClassNames = this.getLog().isDebugEnabled() ? new ArrayList() : null;
        this.buildDir = new File(this.project.getBuild().getOutputDirectory());
        try {
            this.setUpKnownTypes();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error retrieving information about earlier processing results" + ex.toString());
        }
        this.loader = this.createClassLoader();
        try {
            this.loadConfigBeans();
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error loading config beans", ex);
        }
        try {
            inhabitants = this.findInhabitantsInModule();
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Error searching inhabitants for commands", (Exception)ex);
        }
        Collection<Inhabitant> commandInhabitants = this.findCommandInhabitants(inhabitants);
        for (Inhabitant i : commandInhabitants) {
            this.authInfosThisModule.add(this.processType(i));
        }
        if (this.trace != null) {
            this.getLog().debug((CharSequence)this.trace.toString());
        }
    }

    private void loadConfigBeans() throws MalformedURLException, IOException {
        for (URL url : this.loader.getURLs()) {
            if (this.jarsProcessedForConfigBeans.contains(url)) continue;
            this.getLog().debug((CharSequence)("Starting to load configBeans from " + url.toExternalForm()));
            this.loadConfigBeansFromJar(url);
            this.jarsProcessedForConfigBeans.add(url);
        }
    }

    private void loadConfigBeansFromJar(URL url) throws MalformedURLException, IOException {
        for (String inhabitantsPath : INHABITANTS_PATHS) {
            URL inhabitantsURL;
            String fullURL;
            String fullPath = INHABITANTS_PATHS_PREFIX + inhabitantsPath;
            if (url.getPath().endsWith(".jar")) {
                fullURL = "jar:file:" + url.getPath() + "!/" + fullPath;
                inhabitantsURL = new URL(fullURL);
            } else {
                fullURL = fullPath;
                inhabitantsURL = new URL(url, fullURL);
            }
            try {
                this.loadConfigBeans(url, inhabitantsURL);
            }
            catch (FileNotFoundException ex) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfigBeans(URL url, URL inhabitantsURL) throws IOException {
        BufferedInputStream is = new BufferedInputStream(inhabitantsURL.openStream());
        try {
            HashMap<String, Inhabitant> preBeans = this.isCheckAPIvsParse ? new HashMap<String, Inhabitant>(this.configBeans) : null;
            List<Inhabitant> inhabitants = this.findInhabitantsInModule(new BufferedReader(new InputStreamReader(is)));
            if (this.isCheckAPIvsParse) {
                HashSet<Inhabitant> beansAddedByNew = new HashSet<Inhabitant>(this.configBeans.values());
                beansAddedByNew.removeAll(preBeans.values());
                BufferedInputStream isAgain = new BufferedInputStream(inhabitantsURL.openStream());
                List<Inhabitant> old = this.findInhabitantsInModule(new InputStreamReader(isAgain));
                HashSet<Inhabitant> beansAddedByOld = new HashSet<Inhabitant>(this.configBeans.values());
                beansAddedByOld.removeAll(preBeans.values());
                if (!beansAddedByOld.equals(beansAddedByNew)) {
                    HashSet<Inhabitant> beansAddedByNewNotOld = beansAddedByNew;
                    beansAddedByNewNotOld.removeAll(beansAddedByOld);
                    HashSet<Inhabitant> beansAddedByOldNotNew = beansAddedByOld;
                    beansAddedByOldNotNew.removeAll(beansAddedByNew);
                    throw new RuntimeException("Beans added mismatch for URL " + url.toExternalForm() + "\n  added by new not old: " + ((Object)beansAddedByNewNotOld).toString() + "\n  added by old not new: " + ((Object)beansAddedByOldNotNew).toString());
                }
                this.getLog().info((CharSequence)("ConfigBeans match for file " + url.toExternalForm()));
                if (!old.equals(inhabitants)) {
                    HashSet<Inhabitant> inNewerNotInOld = new HashSet<Inhabitant>(inhabitants);
                    inNewerNotInOld.removeAll(old);
                    HashSet<Inhabitant> inOldNotInNewer = new HashSet<Inhabitant>(old);
                    inOldNotInNewer.removeAll(inhabitants);
                    throw new RuntimeException("Inhabitants mismatch for file " + inhabitantsURL.toExternalForm() + "\n  extra in old: " + ((Object)inOldNotInNewer).toString() + "\n  extra in new: " + ((Object)inNewerNotInOld).toString());
                }
            }
        }
        finally {
            ((InputStream)is).close();
        }
    }

    @Override
    public Collection<CommandAuthorizationInfo> authInfosThisModule() {
        return this.authInfosThisModule;
    }

    @Override
    public List<String> okClassNames() {
        return this.okClassNames;
    }

    @Override
    public List<String> offendingClassNames() {
        return this.offendingClassNames;
    }

    @Override
    public boolean isFailureFatal() {
        return this.isFailureFatal;
    }

    @Override
    public StringBuilder trace() {
        return this.trace;
    }

    private CommandAuthorizationInfo processType(Inhabitant i) throws MojoFailureException, MojoExecutionException {
        if (!GENERIC_CRUD_COMMAND_CLASS_NAMES.contains(i.className)) {
            return this.processType(i.className, true);
        }
        CommandAuthorizationInfo info = new CommandAuthorizationInfo();
        CommandAuthorizationInfo.Param primary = new CommandAuthorizationInfo.Param("name", "");
        primary.addValue("primary", Boolean.TRUE);
        info.addParam(primary);
        info.setName(i.serviceName);
        info.setClassName(i.className);
        info.setLocal(false);
        info.setGeneric(i.methodListActual, i.methodName, i.fullPath(), i.action);
        return info;
    }

    private CommandAuthorizationInfo processType(String internalClassName, boolean isInhabitant) throws MojoExecutionException, MojoFailureException {
        if (this.knownCommandTypes.containsKey(internalClassName)) {
            this.getLog().debug((CharSequence)("Recognized previously-IDd class as command: " + internalClassName));
            return this.knownCommandTypes.get(internalClassName);
        }
        if (this.knownNonCommandTypes.contains(internalClassName)) {
            this.getLog().debug((CharSequence)("Recognized previously-IDd class as non-command: " + internalClassName));
            return null;
        }
        String resourcePath = internalClassName.replace('.', '/') + ".class";
        InputStream is = this.loader.getResourceAsStream(resourcePath);
        if (is == null) {
            throw new MojoFailureException("Cannot locate byte code for inhabitant class " + resourcePath);
        }
        try {
            CommandAuthorizationInfo authInfo;
            TypeAnalyzer typeAnalyzer = new TypeAnalyzer(is, this.knownCommandTypes, this);
            typeAnalyzer.setTrace(this.trace);
            typeAnalyzer.run();
            if (this.trace != null) {
                this.getLog().debug((CharSequence)this.trace.toString());
                this.trace = new StringBuilder();
            }
            if ((authInfo = typeAnalyzer.commandAuthInfo()) != null) {
                if (this.trace != null) {
                    this.trace.append(LINE_SEP).append("Adding ").append(internalClassName).append(" to knownCommandTypes");
                }
                this.knownCommandTypes.put(internalClassName, authInfo);
            } else {
                if (this.trace != null) {
                    this.trace.append(LINE_SEP).append("Adding ").append(internalClassName).append(" to knownNonCommandTypes");
                }
                this.knownNonCommandTypes.add(internalClassName);
            }
            if (isInhabitant) {
                if (authInfo == null || !authInfo.isOKDeep()) {
                    this.offendingClassNames.add(internalClassName);
                } else if (this.okClassNames != null) {
                    this.okClassNames.add(internalClassName);
                }
            }
            CommandAuthorizationInfo commandAuthorizationInfo = typeAnalyzer.commandAuthInfo();
            return commandAuthorizationInfo;
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error analyzing " + internalClassName, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    this.getLog().warn((CharSequence)("Error closing input stream for " + internalClassName + "; " + ex.getLocalizedMessage()));
                }
            }
        }
    }

    private void setUpKnownTypes() throws InstantiationException, IllegalAccessException {
        this.knownCommandTypes = this.getOrCreate("org.glassfish.api.admin.knownAuthTypes", this.knownCommandTypes);
        this.knownNonCommandTypes = this.getOrCreate(KNOWN_NONCOMMAND_TYPES_NAME, this.knownNonCommandTypes);
        this.knownCRUDConfigBeanTypes = this.getOrCreate("org.glassfish.api.admin.knownCRUDConfigBeansTypes", this.knownCRUDConfigBeanTypes);
        this.jarsProcessedForConfigBeans = this.getOrCreate(PROCESSED_MODULES_NAME, this.jarsProcessedForConfigBeans);
        this.configBeans = this.getOrCreate(CONFIG_BEANS_NAME, this.configBeans);
    }

    private <T, U> Map<T, U> getOrCreate(String propertyName, Map<T, U> m) {
        HashMap collection = (HashMap)this.getSessionProperties().get(propertyName);
        if (collection == null) {
            collection = new HashMap();
            this.getSessionProperties().put(propertyName, collection);
        }
        return collection;
    }

    private <T> Set<T> getOrCreate(String propertyName, Set<T> s) {
        HashSet collection = (HashSet)this.getSessionProperties().get(propertyName);
        if (collection == null) {
            collection = new HashSet();
            this.getSessionProperties().put(propertyName, collection);
        }
        return collection;
    }

    private Collection<Inhabitant> findCommandInhabitants(Collection<Inhabitant> inhabitants) {
        ArrayList<Inhabitant> result = new ArrayList<Inhabitant>();
        for (Inhabitant inh : inhabitants) {
            if (!inh.contracts.contains(ADMIN_COMMAND_NAME)) continue;
            if (this.trace != null) {
                this.trace.append(LINE_SEP).append(" Inhabitant ").append(inh.className).append(" seems to be a command");
            }
            result.add(inh);
        }
        return result;
    }

    private Properties getSessionProperties() {
        return shared;
    }

    private List<Inhabitant> findInhabitantsInModule() throws IOException {
        ArrayList<Inhabitant> inhabitants = new ArrayList<Inhabitant>();
        for (String inhabitantsPath : INHABITANTS_PATHS) {
            String fullPath = INHABITANTS_PATHS_PREFIX + inhabitantsPath;
            File inhabFile = new File(this.buildDir, fullPath);
            inhabitants.addAll(this.findInhabitantsInModule(inhabFile));
        }
        return inhabitants;
    }

    private List<Inhabitant> findInhabitantsInModule(File inhabFile) throws FileNotFoundException, IOException {
        if (!inhabFile.canRead()) {
            this.getLog().debug((CharSequence)("Cannot read " + inhabFile.getAbsolutePath()));
            return Collections.EMPTY_LIST;
        }
        HashMap<String, Inhabitant> preBeans = this.isCheckAPIvsParse ? new HashMap<String, Inhabitant>(this.configBeans) : null;
        List<Inhabitant> inhabitants = this.findInhabitantsInModule(new BufferedReader(new InputStreamReader(new BufferedInputStream(new FileInputStream(inhabFile)))));
        if (this.isCheckAPIvsParse) {
            List<Inhabitant> old = this.findInhabitantsInModule(new InputStreamReader(new BufferedInputStream(new FileInputStream(inhabFile))));
            HashSet<Inhabitant> beansAddedByOld = new HashSet<Inhabitant>(this.configBeans.values());
            beansAddedByOld.removeAll(preBeans.values());
            HashSet<Inhabitant> beansAddedByNew = new HashSet<Inhabitant>(this.configBeans.values());
            beansAddedByNew.removeAll(preBeans.values());
            if (!beansAddedByOld.equals(beansAddedByNew)) {
                HashSet<Inhabitant> beansAddedByNewNotOld = beansAddedByNew;
                beansAddedByNewNotOld.removeAll(beansAddedByOld);
                HashSet<Inhabitant> beansAddedByOldNotNew = beansAddedByOld;
                beansAddedByOldNotNew.removeAll(beansAddedByNew);
                throw new RuntimeException("Beans added mismatch for URL " + inhabFile.getAbsolutePath() + "\n  added by new not old: " + ((Object)beansAddedByNewNotOld).toString() + "\n  added by old not new: " + ((Object)beansAddedByOldNotNew).toString());
            }
            this.getLog().info((CharSequence)("ConfigBeans match for file " + inhabFile.getAbsolutePath()));
            if (!old.equals(inhabitants)) {
                HashSet<Inhabitant> inNewerNotInOld = new HashSet<Inhabitant>(inhabitants);
                inNewerNotInOld.removeAll(old);
                HashSet<Inhabitant> inOldNotInNewer = new HashSet<Inhabitant>(old);
                inOldNotInNewer.removeAll(inhabitants);
                throw new RuntimeException("Inhabitants mismatch for file " + inhabFile.getAbsolutePath() + "\n  extra in old: " + ((Object)inOldNotInNewer).toString() + "\n  extra in new: " + ((Object)inNewerNotInOld).toString());
            }
        }
        return inhabitants;
    }

    private List<Inhabitant> findInhabitantsInModule(BufferedReader br) throws IOException {
        DescriptorImpl di;
        ArrayList<Inhabitant> result = new ArrayList<Inhabitant>();
        while ((di = new DescriptorImpl()).readObject(br)) {
            List targets;
            Inhabitant inhabitant = new Inhabitant(di.getImplementation());
            inhabitant.contracts = new ArrayList(di.getAdvertisedContracts());
            inhabitant.serviceName = di.getName();
            inhabitant.methodListActual = this.getFirstIfAny(di.getMetadata(), "MethodListActual");
            inhabitant.methodName = this.getFirstIfAny(di.getMetadata(), "MethodName");
            inhabitant.parentConfigured = this.getParentConfigured(di);
            if (inhabitant.methodName != null) {
                this.getLog().debug((CharSequence)("Recognized generic command " + inhabitant.serviceName));
                inhabitant.action = TypeProcessorImpl.genericCommandNameToAction.get(inhabitant.className);
                Inhabitant configBeanParent = this.configBeans.get(inhabitant.parentConfigured);
                if (configBeanParent == null) {
                    configBeanParent = new Inhabitant(inhabitant.parentConfigured);
                    this.configBeans.put(configBeanParent.className, configBeanParent);
                    this.getLog().debug((CharSequence)("Created parent bean " + configBeanParent.className + " for target bean " + inhabitant.methodListActual));
                } else {
                    this.getLog().debug((CharSequence)("Found parent bean " + configBeanParent.className + " for target bean " + inhabitant.methodListActual));
                }
                Inhabitant configBean = this.configBeans.get(inhabitant.methodListActual);
                if (configBean == null) {
                    configBean = new Inhabitant(inhabitant.methodListActual);
                    this.configBeans.put(configBean.className, configBean);
                    this.getLog().debug((CharSequence)("Created new config bean for " + configBean.className));
                } else {
                    this.getLog().debug((CharSequence)("Found existing config bean for " + configBean.className));
                }
                configBean.parent = configBeanParent;
                inhabitant.configBeanForCommand = configBean;
            }
            if ((targets = (List)di.getMetadata().get("target")) != null && targets.size() > 0) {
                Inhabitant parent;
                String configBeanClassName = (String)targets.get(0);
                this.getLog().debug((CharSequence)("Recognized " + configBeanClassName + " as a config bean"));
                Inhabitant configBean = this.configBeans.get(configBeanClassName);
                if (configBean == null) {
                    configBean = new Inhabitant(configBeanClassName);
                }
                if (configBean.parent == null && (parent = this.findParent(configBean)) != null) {
                    configBean.parent = parent;
                }
                this.configBeans.put(configBeanClassName, configBean);
                for (Map.Entry entry : di.getMetadata().entrySet()) {
                    Child child;
                    Matcher m = CONFIG_BEAN_CHILD_NAME_KEY_PATTERN.matcher((CharSequence)entry.getKey());
                    if (!m.matches()) continue;
                    String childClassName = (String)((List)entry.getValue()).get(0);
                    String subpathInParent = m.group(1);
                    boolean isCollection = childClassName.startsWith("collection:");
                    if (isCollection) {
                        childClassName = childClassName.substring("collection:".length());
                    }
                    this.getLog().debug((CharSequence)("Identified " + childClassName + " as child " + (isCollection ? "collection " : "") + subpathInParent + " of " + configBean.className));
                    Inhabitant childInh = this.configBeans.get(childClassName);
                    if (childInh == null) {
                        childInh = new Inhabitant(childClassName);
                        this.configBeans.put(childClassName, childInh);
                        this.getLog().debug((CharSequence)"Added child inhabitant to configBeans");
                    } else {
                        this.getLog().debug((CharSequence)"Found child as previously-defined config bean");
                    }
                    this.getLog().debug((CharSequence)("Assigning " + configBean.className + " as parent of " + childInh.className));
                    childInh.parent = configBean;
                    if (configBean.children == null) {
                        configBean.children = new HashMap();
                    }
                    if ((child = (Child)configBean.children.get(childClassName)) != null) continue;
                    child = new Child(subpathInParent, childInh);
                    configBean.children.put(childClassName, child);
                    this.getLog().debug((CharSequence)("Adding config bean " + childClassName + " as child " + subpathInParent + " to config bean " + configBean.className));
                }
            }
            result.add(inhabitant);
        }
        return result;
    }

    private Inhabitant findParent(Inhabitant cb) {
        if (cb.parent != null) {
            return cb.parent;
        }
        String parentName = this.getParentNameFromByteCode(cb.className);
        if (parentName != null) {
            Inhabitant parent = this.configBeans.get(parentName);
            if (parent == null) {
                parent = new Inhabitant(parentName);
            }
            this.configBeans.put(parentName, parent);
            return parent;
        }
        return null;
    }

    private String getParentConfigured(DescriptorImpl di) {
        List targets;
        String parentConfigured = this.getFirstIfAny(di.getMetadata(), "ParentConfigured");
        if (parentConfigured == null && (di.getAdvertisedContracts().contains(CONFIG_BEAN_NAME) || di.getAdvertisedContracts().contains(CONFIG_BEAN_PROXY_NAME)) && (targets = (List)di.getMetadata().get("target")) != null && targets.size() > 0) {
            parentConfigured = this.getParentNameFromByteCode((String)targets.get(0));
        }
        return parentConfigured;
    }

    private String getParentNameFromByteCode(String className) {
        String result = null;
        InputStream is = null;
        try {
            is = this.loader.getResourceAsStream(className.replace('.', '/') + ".class");
            if (is == null) {
                String string = null;
                return string;
            }
            TypeAnalyzer ta = new TypeAnalyzer(is, this.knownCommandTypes, this);
            ta.run();
            for (String extensionName : EXTENSION_INTERNAL_NAMES) {
                if (!ta.interfaces().contains(extensionName)) continue;
                Type t = Type.getObjectType((String)extensionName);
                String string = t.getClassName();
                return string;
            }
            String string = result;
            return string;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private String getFirstIfAny(Map<String, List<String>> map, String key) {
        List<String> values = map.get(key);
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Inhabitant> findInhabitantsInModule(Reader r) throws IOException {
        ArrayList<Inhabitant> result = new ArrayList<Inhabitant>();
        LineNumberReader rdr = new LineNumberReader(r);
        Inhabitant inhabitant = null;
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                String restOfLine;
                Matcher configBeanPrefixMatcher;
                int commentSlot = line.indexOf(35);
                if (commentSlot != -1) {
                    line = line.substring(0, commentSlot);
                }
                if ((line = line.trim()).isEmpty()) {
                    inhabitant = null;
                    continue;
                }
                Matcher implClassNameMatcher = INHABITANT_IMPL_CLASS_PATTERN.matcher(line);
                if (implClassNameMatcher.matches()) {
                    String implClassName = implClassNameMatcher.group(1);
                    this.getLog().debug((CharSequence)("Detected start of inhabitant: " + implClassName));
                    inhabitant = new Inhabitant(implClassName);
                    result.add(inhabitant);
                } else {
                    Matcher contractsMatcher = INHABITANT_CONTRACTS_PATTERN.matcher(line);
                    if (contractsMatcher.matches()) {
                        inhabitant.contracts.addAll(Arrays.asList(contractsMatcher.group(1).split(",")));
                    } else {
                        Matcher genericInfoMatcher;
                        Matcher nameMatcher = INHABITANT_NAME_PATTERN.matcher(line);
                        if (nameMatcher.matches()) {
                            inhabitant.serviceName = nameMatcher.group(1);
                        } else if (GENERIC_CRUD_COMMAND_CLASS_NAMES.contains(inhabitant.className) && (genericInfoMatcher = GENERIC_COMMAND_INFO_PATTERN.matcher(line)).matches()) {
                            inhabitant.methodListActual = genericInfoMatcher.group(1);
                            inhabitant.methodName = genericInfoMatcher.group(2);
                            inhabitant.parentConfigured = genericInfoMatcher.group(3);
                            this.getLog().debug((CharSequence)("Recognized generic command " + inhabitant.serviceName));
                            inhabitant.action = TypeProcessorImpl.genericCommandNameToAction.get(inhabitant.className);
                            Inhabitant configBeanParent = this.configBeans.get(inhabitant.parentConfigured);
                            if (configBeanParent == null) {
                                configBeanParent = new Inhabitant(inhabitant.parentConfigured);
                                this.configBeans.put(configBeanParent.className, configBeanParent);
                                this.getLog().debug((CharSequence)("Created parent bean " + configBeanParent.className + " for target bean " + inhabitant.methodListActual));
                            } else {
                                this.getLog().debug((CharSequence)("Found parent bean " + configBeanParent.className + " for target bean " + inhabitant.methodListActual));
                            }
                            Inhabitant configBean = this.configBeans.get(inhabitant.methodListActual);
                            if (configBean == null) {
                                configBean = new Inhabitant(inhabitant.methodListActual);
                                this.configBeans.put(configBean.className, configBean);
                                this.getLog().debug((CharSequence)("Created new config bean for " + configBean.className));
                            } else {
                                this.getLog().debug((CharSequence)("Found existing config bean for " + configBean.className));
                            }
                            configBean.parent = configBeanParent;
                            inhabitant.configBeanForCommand = configBean;
                        }
                    }
                }
                if (!(configBeanPrefixMatcher = CONFIG_BEAN_METADATA_PREFIX_PATTERN.matcher(line)).matches()) continue;
                String configBeanClassName = configBeanPrefixMatcher.group(1);
                this.getLog().debug((CharSequence)("Recognized " + configBeanClassName + " as a config bean"));
                Inhabitant configBean = this.configBeans.get(configBeanClassName);
                if (configBean == null) {
                    configBean = new Inhabitant(configBeanClassName);
                    this.configBeans.put(configBeanClassName, configBean);
                }
                if ((restOfLine = configBeanPrefixMatcher.group(2)) == null || restOfLine.length() <= 0) continue;
                Matcher configBeanChildMatcher = CONFIG_BEAN_CHILD_PATTERN.matcher(restOfLine);
                while (configBeanChildMatcher.find()) {
                    Child child;
                    if (configBeanChildMatcher.groupCount() <= 0 || configBeanChildMatcher.group(1) == null) continue;
                    String childClassName = configBeanChildMatcher.group(2);
                    String subpathInParent = configBeanChildMatcher.group(1);
                    this.getLog().debug((CharSequence)("Identified " + childClassName + " as child " + subpathInParent + " of " + configBean.className));
                    Inhabitant childInh = this.configBeans.get(childClassName);
                    if (childInh == null) {
                        childInh = new Inhabitant(childClassName);
                        this.configBeans.put(childClassName, childInh);
                        this.getLog().debug((CharSequence)"Added child inhabitant to configBeans");
                    } else {
                        this.getLog().debug((CharSequence)"Found child as previously-defined config bean");
                    }
                    this.getLog().debug((CharSequence)("Assigning " + configBean.className + " as parent of " + childInh.className));
                    childInh.parent = configBean;
                    if (configBean.children == null) {
                        configBean.children = new HashMap();
                    }
                    if ((child = (Child)configBean.children.get(childClassName)) != null) continue;
                    child = new Child(subpathInParent, childInh);
                    configBean.children.put(childClassName, child);
                    this.getLog().debug((CharSequence)("Adding config bean " + childClassName + " as child " + subpathInParent + " to config bean " + configBean.className));
                }
            }
        }
        finally {
            rdr.close();
        }
        return result;
    }

    private URLClassLoader createClassLoader() throws MojoExecutionException {
        try {
            List compileClasspathElements = this.project.getRuntimeClasspathElements();
            URL[] urls = new URL[compileClasspathElements.size()];
            int urlSlot = 0;
            for (String cpElement : compileClasspathElements) {
                this.getLog().debug((CharSequence)(" Processing class path element " + cpElement));
                urls[urlSlot++] = new File(cpElement).toURI().toURL();
            }
            return new URLClassLoader(urls);
        }
        catch (DependencyResolutionRequiredException ex) {
            throw new MojoExecutionException("Error fetching compile-time classpath", (Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new MojoExecutionException("Error processing class path URL segment", (Exception)ex);
        }
    }

    static class Child {
        private String subpathInParent;
        private Inhabitant child;

        Child(String subpathInParent, Inhabitant childInh) {
            this.subpathInParent = subpathInParent;
            this.child = childInh;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Inhabitant {
        private List<String> contracts = new ArrayList<String>();
        private boolean isFilledIn = false;
        private String className;
        private String serviceName;
        private String methodListActual;
        private String methodName;
        private String parentConfigured;
        private Inhabitant parent = null;
        private String nameInParent = null;
        private String action;
        private Inhabitant configBeanForCommand = null;
        private Map<String, Child> children = null;

        private Inhabitant() {
        }

        private Inhabitant(String className) {
            this.className = className;
        }

        private Inhabitant(String className, List<String> contracts, String serviceName, String methodListActual, String methodName, String parentConfigured) {
            this.className = className;
            this.contracts.addAll(contracts);
            this.serviceName = serviceName;
            this.methodListActual = methodListActual;
            this.methodName = methodName;
            this.parentConfigured = parentConfigured;
            this.action = GenericCommand.match(className).action;
            this.isFilledIn = true;
        }

        void setParent(Inhabitant p) {
            this.parent = p;
            Inhabitant ancestor = this;
            while (ancestor != null) {
                if (p == ancestor) {
                    throw new RuntimeException("Ancestry loop: me=" + this.toString() + " and candidate parent = " + p.toString());
                }
                ancestor = ancestor.parent;
            }
        }

        void set(List<String> contracts, String serviceName, String methodListActual, String methodName, String parentConfigured) {
            this.contracts = contracts;
            this.serviceName = serviceName;
            this.methodListActual = methodListActual;
            this.methodName = methodName;
            this.parentConfigured = parentConfigured;
            this.isFilledIn = true;
        }

        public boolean equals(Object obj) {
            if (obj == null || !Inhabitant.class.isAssignableFrom(obj.getClass())) {
                return false;
            }
            Inhabitant other = (Inhabitant)obj;
            return this.check(this.action, other.action) && this.check(this.className, other.className) && this.check(this.configBeanForCommand, other.configBeanForCommand) && this.check(this.contracts, other.contracts) && this.isFilledIn == other.isFilledIn && this.check(this.methodListActual, other.methodListActual) && this.check(this.methodName, other.methodName) && this.check(this.nameInParent, other.nameInParent) && this.check(this.parentConfigured, other.parentConfigured) && this.check(this.serviceName, other.serviceName);
        }

        public int hashCode() {
            int hash = 7;
            hash = 29 * hash + (this.contracts != null ? this.contracts.hashCode() : 0);
            hash = 29 * hash + (this.isFilledIn ? 1 : 0);
            hash = 29 * hash + (this.className != null ? this.className.hashCode() : 0);
            hash = 29 * hash + (this.serviceName != null ? this.serviceName.hashCode() : 0);
            hash = 29 * hash + (this.methodListActual != null ? this.methodListActual.hashCode() : 0);
            hash = 29 * hash + (this.methodName != null ? this.methodName.hashCode() : 0);
            hash = 29 * hash + (this.parentConfigured != null ? this.parentConfigured.hashCode() : 0);
            hash = 29 * hash + (this.nameInParent != null ? this.nameInParent.hashCode() : 0);
            hash = 29 * hash + (this.action != null ? this.action.hashCode() : 0);
            hash = 29 * hash + (this.configBeanForCommand != null ? this.configBeanForCommand.hashCode() : 0);
            return hash;
        }

        private boolean check(Object x, Object y) {
            return x == null ? y == null : x.equals(y);
        }

        public String toString() {
            return "Inhabitant: " + this.className + " @Service(\"" + this.serviceName + "\")\n";
        }

        boolean isFilledIn() {
            return this.isFilledIn;
        }

        Inhabitant parent() {
            return this.parent;
        }

        String nameInParent() {
            return this.nameInParent;
        }

        String fullPath() {
            Inhabitant i;
            StringBuilder path = new StringBuilder();
            Inhabitant inhabitant = i = this.configBeanForCommand != null ? this.configBeanForCommand : this;
            while (i != null) {
                Inhabitant p;
                if (path.length() > 0 && path.charAt(0) != '/') {
                    path.insert(0, '/');
                }
                if ((p = i.parent) != null) {
                    Child childForThisInh = null;
                    if (p.children != null && (childForThisInh = p.children.get(i.className)) != null) {
                        if (childForThisInh.subpathInParent.equals("*") && path.length() > 0) {
                            path.replace(0, 0, "");
                            if (path.substring(0, 1).equals("//")) {
                                path.replace(0, 0, "");
                            }
                        } else {
                            path.insert(0, childForThisInh.subpathInParent);
                        }
                    } else {
                        path.insert(0, Util.convertName(Util.lastPart(i.className)));
                    }
                } else {
                    path.insert(0, Util.convertName(Util.lastPart(i.className)));
                }
                i = i.parent;
            }
            return path.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum GenericCommand {
        CREATE("org.glassfish.config.support.GenericCreateCommand", "create"),
        DELETE("org.glassfish.config.support.GenericDeleteCommand", "delete"),
        LIST("org.glassfish.config.support.GenericListCommand", "read"),
        UNKNOWN("", "????");

        private final String commandType;
        private final String action;

        private GenericCommand(String commandType, String action) {
            this.commandType = commandType;
            this.action = action;
        }

        String action() {
            return this.action;
        }

        static GenericCommand match(String commandType) {
            for (GenericCommand gc : GenericCommand.values()) {
                if (!gc.commandType.equals(commandType)) continue;
                return gc;
            }
            return UNKNOWN;
        }
    }
}

