/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build.nexus.mojos;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.DeploymentRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.glassfish.nexus.client.NexusClient;
import org.glassfish.nexus.client.NexusClientException;
import org.glassfish.nexus.client.NexusClientImpl;
import org.glassfish.nexus.client.RestClient;
import org.glassfish.nexus.client.logging.CustomPrinter;

public abstract class AbstractNexusMojo
extends AbstractMojo
implements CustomPrinter {
    protected MavenProject project;
    protected MavenSession session;
    protected Settings settings;
    protected ArtifactResolver artifactResolver;
    protected ArtifactRepository localRepository;
    protected boolean ignoreFailures;
    protected NexusClient nexusClient;

    public void info(String message) {
        this.getLog().debug((CharSequence)message);
    }

    public void warning(String message) {
        this.getLog().warn((CharSequence)message);
    }

    public void error(String message) {
        this.getLog().error((CharSequence)message);
    }

    public void debug(String message) {
        this.getLog().debug((CharSequence)message);
    }

    private static DeploymentRepository getDeploymentRepoFromModel(Model m) throws MojoFailureException {
        DeploymentRepository r;
        DistributionManagement dm = m.getDistributionManagement();
        if (dm != null && (r = dm.getRepository()) != null) {
            return r;
        }
        throw new MojoFailureException("unable to get deployment repo from distributionManagement");
    }

    private static String getRepoUrlFromModel(Model m) throws MojoFailureException {
        DeploymentRepository dr = AbstractNexusMojo.getDeploymentRepoFromModel(m);
        String u = dr.getUrl();
        if (u != null) {
            return u;
        }
        throw new MojoFailureException("unable to get repo URL from distributionManagement");
    }

    private static String getRepoIdFromModel(Model m) throws MojoFailureException {
        DeploymentRepository dr = AbstractNexusMojo.getDeploymentRepoFromModel(m);
        String id = dr.getId();
        if (id != null) {
            return id;
        }
        throw new MojoFailureException("unable to get repo Id from distributionManagement");
    }

    private static Server getServerFromSettings(Settings s, String repoId) throws MojoFailureException {
        if (s == null) {
            throw new IllegalArgumentException("settings can't be null");
        }
        Server server = s.getServer(repoId);
        if (server == null) {
            throw new MojoFailureException(String.format("unable to retrieve the server entry for '%s' in settings.xml", repoId));
        }
        return server;
    }

    protected void createNexusClient() throws MojoFailureException, MojoExecutionException {
        String[] tokens;
        String _repoURL = this.session.getUserProperties().getProperty("nexusRepoUrl");
        String repoId = this.session.getUserProperties().getProperty("nexusRepoId");
        String username = this.session.getUserProperties().getProperty("nexusRepoUsername");
        String password = this.session.getUserProperties().getProperty("nexusRepoPassword");
        String altDeployRepo = this.session.getUserProperties().getProperty("altDeploymentRepository");
        if (altDeployRepo != null && (tokens = altDeployRepo.split("::")).length == 3) {
            repoId = tokens[0];
            _repoURL = tokens[2];
        }
        if (_repoURL == null) {
            _repoURL = AbstractNexusMojo.getRepoUrlFromModel(this.project.getModel());
        }
        if (repoId == null) {
            repoId = AbstractNexusMojo.getRepoIdFromModel(this.project.getModel());
        }
        if (username == null) {
            username = AbstractNexusMojo.getServerFromSettings(this.settings, repoId).getUsername();
        }
        if (password == null) {
            password = AbstractNexusMojo.getServerFromSettings(this.settings, repoId).getPassword();
        }
        this.createNexusClient(_repoURL, repoId, username, password);
    }

    protected void createNexusClient(String nexusURL, String repoId, String username, String password) throws MojoFailureException, MojoExecutionException {
        URL repoURL = null;
        if (nexusURL != null && !nexusURL.isEmpty()) {
            try {
                repoURL = new URL(nexusURL.replaceAll("/service/local/staging/deploy/maven2", ""));
            }
            catch (MalformedURLException ex) {
                throw new MojoFailureException("Error in resolving nexusRepoUrl", (Throwable)ex);
            }
        }
        String proxyHost = null;
        int proxyPort = 80;
        for (Proxy proxy : this.settings.getProxies()) {
            if (!proxy.getProtocol().equals(repoURL.getProtocol())) continue;
            proxyHost = proxy.getHost();
            proxyPort = proxy.getPort();
        }
        if (proxyHost == null) {
            Properties props = System.getProperties();
            proxyHost = props.getProperty(repoURL.getProtocol() + ".proxyHost");
            String proxyPortString = props.getProperty(repoURL.getProtocol() + ".proxyPort");
            if (proxyPortString != null) {
                proxyPort = Integer.valueOf(proxyPortString);
            }
        }
        try {
            RestClient restClient = new RestClient(proxyHost, proxyPort, username, password, repoURL.getProtocol().equals("https"), this);
            this.nexusClient = NexusClientImpl.init(restClient, repoURL.toString(), this);
        }
        catch (NexusClientException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
        }
    }
}

