/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.build.nexus.mojos;

import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.glassfish.build.nexus.mojos.AbstractNexusMojo;
import org.glassfish.build.nexus.mojos.StagingRepoConf;
import org.glassfish.nexus.client.NexusClientException;
import org.glassfish.nexus.client.beans.Repo;

public abstract class AbstractNexusStagingMojo
extends AbstractNexusMojo {
    private List<StagingRepoConf> stagingRepos;
    protected String nexusRepoUrl = null;
    protected String nexusRepoId = null;
    protected String nexusRepoUsername = null;
    protected String nexusRepoPassword = null;
    protected String message = null;
    protected Repo stagingRepo;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.createNexusClient();
        if (this.message == null) {
            this.message = this.session.getUserProperties().getProperty("nexusRepoUrl");
        }
        for (StagingRepoConf repo : this.stagingRepos) {
            try {
                this.stagingRepo = this.nexusClient.getStagingRepo(repo.getProfile(), repo.getRefArtifact(this.project.getVersion(), this.artifactResolver, this.localRepository, this.project.getRemoteArtifactRepositories()));
                this.nexusMojoExecute();
            }
            catch (NexusClientException ex) {
                if (this.ignoreFailures) continue;
                throw ex;
            }
        }
    }

    public abstract void nexusMojoExecute() throws NexusClientException, MojoFailureException;
}

