/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.nexus.client;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.MessageProcessingException;
import javax.ws.rs.client.ClientException;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.glassfish.nexus.client.NexusClient;
import org.glassfish.nexus.client.NexusClientException;
import org.glassfish.nexus.client.NexusFailureException;
import org.glassfish.nexus.client.NexusResponseException;
import org.glassfish.nexus.client.RestClient;
import org.glassfish.nexus.client.beans.ContentItem;
import org.glassfish.nexus.client.beans.ContentItems;
import org.glassfish.nexus.client.beans.Failures;
import org.glassfish.nexus.client.beans.MavenArtifactInfo;
import org.glassfish.nexus.client.beans.MavenInfo;
import org.glassfish.nexus.client.beans.Repo;
import org.glassfish.nexus.client.beans.RepoDetail;
import org.glassfish.nexus.client.beans.RepoDetails;
import org.glassfish.nexus.client.beans.Repos;
import org.glassfish.nexus.client.beans.StagingOperationRequest;
import org.glassfish.nexus.client.beans.StagingOperationRequestData;
import org.glassfish.nexus.client.beans.StagingProfile;
import org.glassfish.nexus.client.beans.StagingProfileRepo;
import org.glassfish.nexus.client.beans.StagingProfileRepos;
import org.glassfish.nexus.client.beans.StagingProfiles;
import org.glassfish.nexus.client.logging.CustomHandler;
import org.glassfish.nexus.client.logging.CustomPrinter;
import org.glassfish.nexus.client.logging.DefaultNexusClientPrinter;
import org.glassfish.nexus.client.logging.DefaultRestClientPrinter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexusClientImpl
implements NexusClient {
    private RestClient restClient;
    private String nexusUrl;
    private static final String REPOSITORY_GROUP_PATH = "service/local/repo_groups/";
    private static final String REPOSITORIES_PATH = "service/local/repositories";
    private static final String STAGING_REPO_BULK_PATH = "service/local/staging/bulk/";
    private static final String PROFILES_PATH = "/service/local/staging/profiles";
    private static final String PROFILES_REPOS_PATH = "/service/local/staging/profile_repositories";
    private static final String SEARCH_PATH = "service/local/lucene/search";
    private static final Logger logger = Logger.getLogger(NexusClientImpl.class.getSimpleName());
    private static final CustomHandler handler = new CustomHandler();
    private static NexusClientImpl instance;
    private static List<StagingProfileRepo> stagingProfileRepositories;
    private static HashMap<String, StagingProfileRepo> stagingProfileRepositoriesMap;

    public static NexusClient init(RestClient restClient, String nexusUrl, CustomPrinter p) {
        logger.setUseParentHandlers(false);
        handler.setPrinter(p);
        instance = new NexusClientImpl(restClient, nexusUrl);
        return instance;
    }

    @Override
    public String getNexusURL() {
        return this.nexusUrl;
    }

    public static NexusClient getInstance() {
        return instance;
    }

    private NexusClientImpl(RestClient restClient, String nexusUrl) {
        this.restClient = restClient;
        this.nexusUrl = nexusUrl;
    }

    WebTarget target(String path) {
        return this.restClient.getClient().target(this.nexusUrl).path(path);
    }

    Invocation.Builder request(String path) {
        return this.target(path).request(new String[]{"application/json"});
    }

    private Response get(String path) throws NexusClientException {
        try {
            return this.request(path).get();
        }
        catch (ClientException ex) {
            throw new NexusClientException(ex);
        }
    }

    private void refreshStagingRepos() throws NexusClientException {
        stagingProfileRepositories = Arrays.asList(((StagingProfileRepos)NexusClientImpl.handleResponse(this.get(PROFILES_REPOS_PATH), StagingProfileRepos.class)).getData());
        stagingProfileRepositoriesMap = new HashMap();
        for (StagingProfileRepo profileRepo : stagingProfileRepositories) {
            stagingProfileRepositoriesMap.put(profileRepo.getRepositoryId(), profileRepo);
        }
    }

    private static String checksum(File datafile) {
        try {
            int nread;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            FileInputStream fis = new FileInputStream(datafile);
            byte[] dataBytes = new byte[1024];
            while ((nread = fis.read(dataBytes)) != -1) {
                md.update(dataBytes, 0, nread);
            }
            byte[] mdbytes = md.digest();
            StringBuilder sb = new StringBuilder("");
            for (int i = 0; i < mdbytes.length; ++i) {
                sb.append(Integer.toString((mdbytes[i] & 0xFF) + 256, 16).substring(1));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new NexusClientException(ex);
        }
        catch (IOException ex) {
            throw new NexusClientException(ex);
        }
    }

    private Response stagingOperation(Operation op, String[] repoIds, String profileGroup, String desc) throws NexusClientException {
        if (repoIds == null || repoIds.length == 0) {
            throw new NexusClientException("repoId list is null or empty, can't perform a staging operation");
        }
        try {
            Response response = this.request("service/local/staging/bulk//" + (Object)((Object)op)).post(Entity.entity((Object)new StagingOperationRequestData(new StagingOperationRequest(repoIds, profileGroup, (Object)((Object)op) + " - " + String.valueOf(desc))), (String)"application/json"));
            this.refreshStagingRepos();
            return response;
        }
        catch (ClientException ex) {
            throw new NexusClientException(ex);
        }
    }

    private static Object handleResponse(Response r, Class c) throws NexusClientException {
        if (r.getStatus() == 400) {
            try {
                throw new NexusFailureException((Failures)r.readEntity(Failures.class));
            }
            catch (MessageProcessingException ex) {
                throw new NexusClientException(ex);
            }
        }
        if (r.getStatus() >= 299) {
            throw new NexusResponseException(r.getStatus());
        }
        if (c != null) {
            try {
                return r.readEntity(c);
            }
            catch (MessageProcessingException ex) {
                throw new NexusClientException(ex);
            }
        }
        return null;
    }

    public Repo getStagingRepo(String repoName) throws NexusClientException {
        if (stagingProfileRepositories == null) {
            this.refreshStagingRepos();
        }
        return ((Repos)NexusClientImpl.handleResponse(this.get("service/local/repositories/" + repoName), Repos.class)).getData();
    }

    public Set<Repo> getGroupTree(String repoId) {
        HashSet<Repo> repos = new HashSet<Repo>();
        for (ContentItem item : ((ContentItems)NexusClientImpl.handleResponse(this.get("/service/local/staging/profile_repositories/tree/" + repoId), ContentItems.class)).getData()) {
            String[] tokens = item.getResourceURI().split("/");
            repos.add(new Repo(stagingProfileRepositoriesMap.get(tokens[tokens.length - 1])));
        }
        return repos;
    }

    public StagingProfileRepo getStagingProfileRepo(String repoId) {
        return stagingProfileRepositoriesMap.get(repoId);
    }

    public void closeStagingRepo(String desc, String[] repoIds) throws NexusClientException {
        logger.info(" ");
        logger.log(Level.INFO, "-- closing {0} --", Arrays.toString(repoIds));
        NexusClientImpl.handleResponse(this.stagingOperation(Operation.close, repoIds, null, desc), null);
    }

    public void dropStagingRepo(String desc, String[] repoIds) throws NexusClientException {
        logger.info(" ");
        logger.log(Level.INFO, "-- droping {0} --", Arrays.toString(repoIds));
        NexusClientImpl.handleResponse(this.stagingOperation(Operation.drop, repoIds, null, desc), null);
    }

    public Repo promoteStagingRepo(String promotionProfile, String desc, String[] repoIds) throws NexusClientException {
        logger.info(" ");
        logger.log(Level.INFO, "-- searching for the promotion profile id of \"{0}\" --", promotionProfile);
        for (StagingProfile profile : ((StagingProfiles)NexusClientImpl.handleResponse(this.get(PROFILES_PATH), StagingProfiles.class)).getData()) {
            if (!profile.getMode().equals("GROUP") || !profile.getName().equals(promotionProfile)) continue;
            logger.info(" ");
            logger.log(Level.INFO, "-- promoting {0} with promotion profile \"{1}\" --", new Object[]{Arrays.toString(repoIds), promotionProfile});
            NexusClientImpl.handleResponse(this.stagingOperation(Operation.promote, repoIds, profile.getId(), desc), null);
            StagingProfileRepo repo = stagingProfileRepositoriesMap.get(repoIds[0]);
            if (repo != null) {
                return new Repo(stagingProfileRepositoriesMap.get(repo.getParentGroupId()));
            }
            throw new NexusClientException("unable to find the promoted repository after promotion");
        }
        throw new NexusClientException("unable to find the following promotion profile\"" + promotionProfile + "\"");
    }

    private static StringBuilder getRepoContentURL(String repoId) {
        StringBuilder sb = new StringBuilder(REPOSITORIES_PATH);
        sb.append('/');
        sb.append(repoId);
        sb.append('/');
        sb.append("content");
        sb.append('/');
        return sb;
    }

    private ContentItems getRepoContent(StringBuilder contentPath, String path) {
        ContentItems content = (ContentItems)NexusClientImpl.handleResponse(this.request(contentPath.append(path).toString()).get(), ContentItems.class);
        return content;
    }

    private void scrubRepo(String repoId, String path, Set<MavenArtifactInfo> artifacts) throws NexusClientException {
        StringBuilder repoContentURL = NexusClientImpl.getRepoContentURL(repoId);
        String root = repoContentURL.toString();
        ContentItems content = this.getRepoContent(repoContentURL, path);
        for (ContentItem item : content.getData()) {
            if (item.getLeaf().booleanValue()) {
                if (!item.isValidArtifactFile()) continue;
                MavenArtifactInfo artifact = ((MavenInfo)NexusClientImpl.handleResponse(this.target(root + "/" + item.getRelativePath()).queryParam("describe", new Object[]{"maven2"}).request(new String[]{"application/json"}).get(), MavenInfo.class)).getData()[0];
                logger.log(Level.INFO, "found {0}", artifact);
                artifacts.add(artifact);
                continue;
            }
            if (item.getSizeOnDisk() != -1) continue;
            this.scrubRepo(repoId, item.getRelativePath(), artifacts);
        }
    }

    @Override
    public boolean existsInRepoGroup(String repoGroup, MavenArtifactInfo artifact) throws NexusClientException {
        ContentItem[] items = ((ContentItems)NexusClientImpl.handleResponse(this.get(REPOSITORY_GROUP_PATH + repoGroup + "/" + artifact.getRepositoryRelativePath()), ContentItems.class)).getData();
        return items != null && items.length > 0;
    }

    public Set<MavenArtifactInfo> getArtifactsInRepo(String repoId) throws NexusClientException {
        logger.info(" ");
        logger.log(Level.INFO, "-- retrieving full content of repository [{0}] --", repoId);
        HashSet<MavenArtifactInfo> artifacts = new HashSet<MavenArtifactInfo>();
        this.scrubRepo(repoId, "", artifacts);
        return artifacts;
    }

    public Set<MavenArtifactInfo> getArtifactsInRepo(String repoId, String path) throws NexusClientException {
        logger.info(" ");
        logger.log(Level.INFO, "-- retrieving content of [{0}] in repository [{1}] --", new Object[]{repoId});
        HashSet<MavenArtifactInfo> artifacts = new HashSet<MavenArtifactInfo>();
        this.scrubRepo(repoId, "", artifacts);
        return artifacts;
    }

    @Override
    public void deleteContent(String repoId, String path) throws NexusClientException {
        logger.info(" ");
        logger.log(Level.INFO, "-- deleting content of [{0}] in repository [{1}]] --", new Object[]{path, this.nexusUrl});
        StringBuilder repoContentURL = NexusClientImpl.getRepoContentURL(repoId);
        ContentItems repoContent = this.getRepoContent(repoContentURL, path);
        if (repoContent != null && repoContent.getData() != null) {
            for (ContentItem item : repoContent.getData()) {
                if (!item.getLeaf().booleanValue()) continue;
                String itemPath = item.getResourceURI().replace(this.nexusUrl, "");
                NexusClientImpl.handleResponse(this.target(itemPath).request().delete(), null);
                logger.log(Level.INFO, "deleted {0}", item.getRelativePath());
            }
        }
    }

    @Override
    public Repo getStagingRepo(String stagingProfile, MavenArtifactInfo refArtifact) throws NexusClientException {
        String refChecksum = NexusClientImpl.checksum(refArtifact.getFile());
        logger.info(" ");
        logger.info("-- searching for the staging repository --");
        if (stagingProfileRepositories == null) {
            this.refreshStagingRepos();
        }
        for (StagingProfileRepo repo : stagingProfileRepositories) {
            if (!repo.getProfileName().equals(stagingProfile) || !repo.getUserId().equals(this.restClient.getUsername())) continue;
            StringBuilder sb = new StringBuilder(REPOSITORIES_PATH);
            sb.append('/');
            sb.append(repo.getRepositoryId());
            sb.append('/');
            sb.append("content");
            sb.append('/');
            sb.append(refArtifact.getRepositoryRelativePath());
            sb.append(".sha1");
            String checksum = null;
            try {
                checksum = (String)NexusClientImpl.handleResponse(this.request(sb.toString()).get(), String.class);
            }
            catch (NexusResponseException ex) {
                logger.log(Level.INFO, "[{0}] does not contain the ref artifact", new Object[]{repo.getRepositoryId()});
            }
            if (checksum == null) continue;
            if (refChecksum.equals(checksum)) {
                logger.log(Level.INFO, "found staging repository: [{0}]", new Object[]{repo.getRepositoryId()});
            } else {
                logger.log(Level.WARNING, "[{0}] contains a different version of {1}", new Object[]{repo.getRepositoryId(), refArtifact});
            }
            return this.getStagingRepo(repo.getRepositoryId());
        }
        throw new NexusClientException("unable to find an open staging repository for staging profile \"" + stagingProfile + "\" and ref artifact \"" + refArtifact + "\"");
    }

    @Override
    public Repo getStagingRepo(File f) throws NexusClientException {
        RepoDetail[] results = ((RepoDetails)NexusClientImpl.handleResponse(this.target(SEARCH_PATH).queryParam("sha1", new Object[]{NexusClientImpl.checksum(f)}).request(new String[]{"application/json"}).get(), RepoDetails.class)).getRepoDetails();
        if (results != null) {
            for (RepoDetail detail : results) {
                if (detail.isGroup()) continue;
                return this.getStagingRepo(detail.getRepositoryId());
            }
        }
        return null;
    }

    public static void main(String[] args) {
        NexusClient nexusClient = NexusClientImpl.init(new RestClient(null, 0, "user", "password", true, new DefaultRestClientPrinter()), "https://maven.java.net", new DefaultNexusClientPrinter());
        Repo repo = nexusClient.getStagingRepo("org-glassfish", new MavenArtifactInfo("groupId", "artifactId", "version", "classifier", "extension", null));
        repo.close("Add some message here");
    }

    static {
        stagingProfileRepositories = null;
        logger.addHandler(handler);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Operation {
        close,
        promote,
        drop;

    }
}

